/*
* @category    Store Dientes Actividaees Proxima Cita x Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridDienteActividadesProxCitaDetalle = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridDienteActividadesProxCitaDetalle.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridDienteActividadesProxCitaDetalle',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/controlador_odontologia.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerDientesActividadesProximaCitaDetalle"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'IdConsecutivoDientesActividad' },
                { name: 'Paciente' },
                { name: 'CAS' },
                { name: 'FechaAtencion' },
                { name: 'Diente' },
                { name: 'Superficie' },
                { name: 'IdProced' },
                { name: 'CodProced' },
                { name: 'DesProced' },
                { name: 'EstadoRegistro' },
                { name: 'VlrActividad' },
                { name: 'Cantidad', type: 'decimal' },
                { name: 'VlrCopago' },
                { name: 'VlrNeto' }
            ]),
            sortInfo:{field: 'IdConsecutivoDientesActividad', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridDienteActividadesProxCitaDetalle();

