/*
* @category    Store Dientes Actividaees Proxima Cita x Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridDienteActividadesProxCita = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridDienteActividadesProxCita.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridDienteActividadesProxCita',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/controlador_odontologia.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerDientesActividadesProximaCita"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Paciente' },
                { name: 'CAS' },
                { name: 'FechaAtencion' },
                { name: 'Profesional' }
            ]),
            sortInfo:{field: 'FechaAtencion', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridDienteActividadesProxCita();

