/*
* @category    Store Ingresos Egresos Hogar Paso Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridAcompanantesxIngreso = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridAcompanantesxIngreso.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridAcompanantesxIngreso',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/hogardepaso.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerAcompanantesIngresosEgresos"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Origen' },
                { name: 'ID_CONSECUTIVO_ACOMPANANTE' },
                { name: 'ID_INGRESO' },
                { name: 'FECHA_INGRESO', type: 'date', dateFormat: 'd/m/Y'},
                { name: 'FecIngreso', type: 'string' },
                { name: 'HORA_INGRESO_ACOMPANANTE' },
                { name: 'newHORA_INGRESO_ACOMPANANTE' },
                { name: 'TDOC_ACOMPANANTE' },
                { name: 'DOCUMENTO_ACOMPANANTE' },
                { name: 'NOMBRE_ACOMPANANTE' },
                { name: 'GENERO_ACOMPANANTE' },
                { name: 'TELEFONO_ACOMPANANTE' },
                { name: 'PARENTESCO_ACOMPANANTE' },
                { name: 'INGRESO_HOGAR_ACOMPANANTE' },
                { name: 'HABITACION_ACOMPANANTE' },
                { name: 'CAMA_ACOMPANANTE' },
                { name: 'NOM_HABITACION' },
                { name: 'NOM_CAMA' },
                { name: 'ALIMENTO_DESAYUNO_ACOMPANANTE' },
                { name: 'ALIMENTO_ALMUERZO_ACOMPANANTE' },
                { name: 'ALIMENTO_COMIDA_ACOMPANANTE' },
                { name: 'ACTIVO' },
                { name: 'FECHA_EGRESO', type: 'string'},
                { name: 'HORA_EGRESO_ACOMPANANTE' },
                { name: 'ALERTA_ACOMPANANTE' },
                { name: 'USUARIO_EGRESO_ACOMPANANTE' }
            ]),
            sortInfo:{field: 'FECHA_INGRESO', direction: "DESC", field: 'ID_CONSECUTIVO_ACOMPANANTE', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridAcompanantesxIngreso();

