/*
* @category    Store Factores Riesgo Salud Ocupacional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreFacRiesgoSO = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreFacRiesgoSO.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreFacRiesgoSO',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/combobox/cbfactoresriesgoso.php',
                method: 'GET'
            }),
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'rows'
            },
            [
                {
                    name: 'Descripcion'
                },
                {
                    name: 'Seleccionar',
                    type: 'bool'
                }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreFacRiesgoSO();

