/*
* @category    Store Elementos Proteccion Salud Ocupacional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreElementosProteccionSO = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreElementosProteccionSO.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreElementosProteccionSO',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/combobox/cbelementosprotecso.php',
                method: 'GET'
            }),
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'rows'
            },
            [
                {
                    name: 'Descripcion'
                },
                {
                    name: 'Seleccionar',
                    type: 'bool'
                }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreElementosProteccionSO();

