/*
* @category    Store Evoluciones HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridTratamientoControl = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridTratamientoControl.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridTratamientoControl',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/brestrepo.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerTratamientoControlesxPaciente"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdTratamiento'},
                {name: 'Paciente'},
                {name: 'Formato'},
                {name: 'FechaTto', type: 'date', dateFormat: 'd/m/Y'},
                {name: 'Hora'},
                {name: 'Sesion'},
                {name: 'TipoTratamiento'},
                {name: 'Observaciones'}
            ]),
            sortInfo:{field: 'FechaTto', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridTratamientoControl();

