/*
* @category    Store Grid Consultas por Confirmar
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridConsultasxConfirmar = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridConsultasxConfirmar.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridConsultasxConfirmar',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asignarcitasesp/controlador_confirmacion_citas.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'Cod'},
                {name: 'CAS'},
                {name: 'Paciente'},
                {name: 'TipDoc'},
                {name: 'Documento'},
                {name: 'PrimerApellido'},
                {name: 'SegundoApellido'},
                {name: 'PrimerNombre'},
                {name: 'SegundoNombre'},
                {name: 'FechaCita'},
                {name: 'HoraCita'},
                {name: 'Profesional'},
                {name: 'Observaciones'},
                {name: 'Estado'},
                {name: 'EstadoCon'},
                {name: 'Sede'},
                {name: 'Telefono'},
                {name: 'Telefono1'},
                {name: 'Cliente'}
            ]),
            sortInfo:{field: 'FechaCita', direction: "DESC", field: 'EstadoCon', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridConsultasxConfirmar();

