/*
* @category    Store Tipos de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridTiposHorario = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridTiposHorario.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridTiposHorario',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_tipohorario.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdTipoHorario', type: 'int', mapping: 'IdTipoHorario'},
                {name: 'Prestador', type: 'int', mapping: 'Prestador'},
                {name: 'IdCita', type: 'int', mapping: 'IdCita'},
                {name: 'DesCita', type: 'string', mapping: 'DesCita'},
                {name: 'DesImprime', type: 'string', mapping: 'DesImprime'},
                {name: 'HoraAtencion', type: 'string', mapping: 'HoraAtencion'},
                {name: 'Usuario', type: 'string', mapping: 'Usuario'},
                {name: 'FechaAct', type: 'string', mapping: 'FechaAct'}
            ]),
            sortInfo:{field: 'IdCita', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridTiposHorario();

