/*
* @category    Modelo Maestro IPS
* @package     OfiClinic Web
* @author      Jorge Ancizar GAleano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.desarrollo@ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var DGDataStore;
var DGColumnModel;
var DGListingEditorGrid;
var DGListingWindow;
var DGCreateForm;
var DGCreateWindow;
var DGModifyForm;
var DGModifyWindow;
var DGViewForm;
var DGViewWindow;
var IdRecordField;
var DescripcionField;
var EspecialidadField;
var RegistroField;
var DireccionField;
var TelefonoField;
var EmailField;
var TipoProfeField;
var ProgramarAgendaField;
var ModificarKardexField;
var VlrMultaField;
var ActivoField;

var IdRecordField1;
var DescripcionField1;
var EspecialidadField1;
var RegistroField1;
var DireccionField1;
var TelefonoField1;
var EmailField1;
var TipoProfeField1;
var ProgramarAgendaField1;
var ModificarKardexField1;
var VlrMultaField1;
var ActivoField1;

var IdRecordField2;
var DescripcionField2;
var EspecialidadField2;
var RegistroField2;
var DireccionField2;
var TelefonoField2;
var EmailField2;
var TipoProfeField2;
var ProgramarAgendaField2;
var ModificarKardexField2;
var VlrMultaField2;
var ActivoField2;

var DGListingSelectedRow;
var DGListingContextMenu;
var anchoPantalla;
var MargenIzquierdo;

Ext.onReady(function(){
    Ext.QuickTips.init();

    setTimeout(function(){
        Ext.get('loading').remove();
        Ext.get('loading-mask').fadeOut({remove:true});
    }, 150);

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    Ext.util.Format.Currency = function(v)
    {
        return FormatoMoneda(v);
    };

    Ext.apply(Ext.form.VTypes,{
        exclusionNotZero: function(val, field){
            try{
                if (val < 1){
                    return false;
                } else {
                    field.clearInvalid();
                    return true;
                }
            }catch(e){
                return false;
            }
        },
        exclusionNotZeroText: 'No puede tener valor cero!'
    });

    var dsEspecialidades = new Ext.data.JsonStore({
        proxy: new Ext.data.HttpProxy ({
            url: '../data/especialidades.php',
            method: 'POST'
        }),
        id: 'dsEspecialidades',
        idProperty: 'Codigo',
        root: 'rows',
        fields:[
           {name: 'Codigo'},
           {name: 'Descripcion'}
        ]
    });
    dsEspecialidades.load();

    var dsTipoProfe = new Ext.data.JsonStore({
        proxy: new Ext.data.HttpProxy ({
            url: '../data/tipo_profesional.php',
            method: 'POST'
        }),
        id: 'dsTipoProfe',
        idProperty: 'Codigo',
        root: 'rows',
        fields:[
           {name: 'Codigo'},
           {name: 'Descripcion'}
        ]
    });
    dsTipoProfe.load();

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            window.close();
        }
    });
    
    function modifyRecord(oGrid_event){
        Ext.Msg.show({
            title: 'eOfiClinic',
            buttons: Ext.MessageBox.YESNO,
            msg: "Esta Seguro que Desea Modificar la información, Si Hace Esto no Podra Deshacer los Cambios'",
            icon: Ext.MessageBox.QUESTION,
            fn: function(btn)
            {
                if (btn == 'yes')
                {
                    Ext.Ajax.request({
                        waitMsg: 'Por favor Espere...',
                        url: '../data/controlador_profesionales.php',
                        params: {
                            task: "UPDATE",
                            USUARIO: ID_USUARIO,
                            IDRecord: IdRecordField2.getValue(),
                            Profesional: DescripcionField2.getValue(),
                            Especialidad: EspecialidadField2.getValue(),
                            RegistroMed: RegistroField2.getValue(),
                            Direccion: DireccionField2.getValue(),
                            Telefono: TelefonoField2.getValue(),
                            Email: EmailField2.getValue(),
                            TipoProfe: TipoProfeField2.getValue(),
                            ProgramarAgenda: ProgramarAgendaField2.getValue(),
                            ModificaKardex: ModificarKardexField2.getValue(),
                            VlrMulta: VlrMultaField2.getValue(),
                            Activo: ActivoField2.getValue()
                        },
                        success: function(response){
                            var result=eval(response.responseText);
                            switch(result){
                                case 1:
                                    Ext.MessageBox.alert('eOfiClinic','El Profesional se modifico satisfactoriamente.');
                                    DGDataStore.commitChanges();
                                    DGDataStore.reload();
                                    DGModifyWindow.hide();
                                    break;
                                default:
                                    Ext.MessageBox.alert('Error...','No podemos guardar la información en estos momentos...');
                                    break;
                            }
                        },
                        failure: function(response){
                            var result=response.responseText;
                            Ext.MessageBox.alert('Error Base Datos...','No podemos guardar la información en estos momentos...');
                        }
                    });
                } else {
                    DGDataStore.rejectChanges();
                }
            }
        });
    }

    function createRecord(){
        if(isDGFormValid()){
            Ext.Ajax.request({
                waitMsg: 'Por favor Espere...',
                url: '../data/controlador_profesionales.php',
                params: {
                    task: "CREATE",
                    USUARIO: ID_USUARIO,
                    IdRecord: IdRecordField.getValue(),
                    Profesional: DescripcionField.getValue(),
                    Especialidad: EspecialidadField.getValue(),
                    RegistroMed: RegistroField.getValue(),
                    Direccion: DireccionField.getValue(),
                    Telefono: TelefonoField.getValue(),
                    Email: EmailField.getValue(),
                    TipoProfe: TipoProfeField.getValue(),
                    ProgramarAgenda: ProgramarAgendaField.getValue(),
                    ModificaKardex: ModificarKardexField.getValue(),
                    VlrMulta: VlrMultaField.getValue(),
                    Activo: ActivoField.getValue()
                },
                success: function(response){
                    var result=eval(response.responseText);
                    switch(result){
                        case 1:
                            Ext.MessageBox.alert('eOfiClinic','El Profesional se creo satisfactoriamente.');
                            DGDataStore.reload();
                            //DGCreateWindow.hide();
                            break;
                        default:
                            Ext.MessageBox.alert('Error...','No podemos guardar el Profesional en estos momentos, verifique nuevamente la información');
                        break;
                    }
                },
                failure: function(response){
                    var result=response.responseText;
                    Ext.MessageBox.alert('Error Base Datos...','No podemos guardar la información en estos momentos...');
                }
            });
        } else {
            Ext.MessageBox.alert('Atención', 'La información ingresada no es valida!');
        }
    }

    function resetForm(){
        if(DescripcionField.getValue() != null)
        {
            IdRecordField.setValue('');
            DescripcionField.setValue('');
            EspecialidadField.setValue('');
            RegistroField.setValue('');
            DireccionField.setValue('');
            TelefonoField.setValue('');
            EmailField.setValue('');
            TipoProfeField.setValue('');
            ProgramarAgendaField.setValue('');
            ModificarKardexField.setValue('');
            VlrMultaField.setValue('');
            ActivoField.setValue('');
        }
    }

    function isDGFormValid(){
        return(DescripcionField.isValid() && VlrMultaField.isValid() && IdRecordField.isValid() && EspecialidadField.isValid() && RegistroField.isValid() && DireccionField.isValid() && TelefonoField.isValid() && TipoProfeField.isValid());
    }

    function displayFormWindow(){
        if(!DGCreateWindow.isVisible()){
            resetForm();
            DGCreateWindow.show();
        } else {
            DGCreateWindow.toFront();
        }
    }

    function ViewFormWindowView(){
        if(!DGViewWindow.isVisible()){
            //resetForm();
            var selections = DGListingEditorGrid.selModel.getSelections();
            IdRecordField1.setValue(selections[0].json.idrecord);
            DescripcionField1.setValue(selections[0].json.descripcion);
            EspecialidadField1.setValue(selections[0].json.especialidad);
            RegistroField1.setValue(selections[0].json.registro);
            DireccionField1.setValue(selections[0].json.direccion);
            TelefonoField1.setValue(selections[0].json.telefono);
            EmailField1.setValue(selections[0].json.email);
            TipoProfeField1.setValue(selections[0].json.tipoprofe);
            if(selections[0].json.programar == "SI")
                ProgramarAgendaField1.setValue(1);
            else
                ProgramarAgendaField1.setValue(0);
            if(selections[0].json.modificar == "SI")
                ModificarKardexField1.setValue(1);
            else
                ModificarKardexField1.setValue(0);
            VlrMultaField1.setValue(selections[0].json.vlrmulta);
            if(selections[0].json.activo == "SI")
                ActivoField1.setValue(1);
            else
                ActivoField1.setValue(0);
            DGViewWindow.show();
        } else {
            DGViewWindow.toFront();
        }
    }

    function ViewFormWindowEdit(){
        if(!DGModifyWindow.isVisible()){
            //resetForm();
            var selections = DGListingEditorGrid.selModel.getSelections();
            IdRecordField2.setValue(selections[0].json.idrecord);
            DescripcionField2.setValue(selections[0].json.descripcion);
            EspecialidadField2.setValue(selections[0].json.especialidad);
            RegistroField2.setValue(selections[0].json.registro);
            DireccionField2.setValue(selections[0].json.direccion);
            TelefonoField2.setValue(selections[0].json.telefono);
            EmailField2.setValue(selections[0].json.email);
            TipoProfeField2.setValue(selections[0].json.tipoprofe);
            if(selections[0].json.programar == "SI")
                ProgramarAgendaField2.setValue(1);
            else
                ProgramarAgendaField2.setValue(0);
            if(selections[0].json.modificar == "SI")
                ModificarKardexField2.setValue(1);
            else
                ModificarKardexField2.setValue(0);
            VlrMultaField2.setValue(selections[0].json.vlrmulta);
            if(selections[0].json.activo == "SI")
                ActivoField2.setValue(1);
            else
                ActivoField2.setValue(0);
            DGModifyWindow.show();
        } else {
            DGModifyWindow.toFront();
        }
    }

    function confirmDelete(){
        if(DGListingEditorGrid.selModel.getCount() == 1) // only one president is selected here
        {
            Ext.MessageBox.confirm('Confirmación','Es Seguro que Desea Eliminar el Registro, si hace esto no podrá deshacer los cambios y se perderan los datos definitivamente..!', deleteRecord);
        } else if(DGListingEditorGrid.selModel.getCount() > 1){
            Ext.MessageBox.confirm('Confirmación','Es Seguro que Desea Eliminar los Registros Seleccionados, si hace esto no podrá deshacer los cambios y se perderan los datos definitivamente..!', deleteRecord);
        } else {
            Ext.MessageBox.alert('Error...','No podemos eliminar los registros en estos momentos');
        }
    }
   
    function deleteRecord(btn){
        if(btn=='yes'){
            var selections = DGListingEditorGrid.selModel.getSelections();
            var prez = [];
            for(i = 0; i< DGListingEditorGrid.selModel.getCount(); i++){
                prez.push(selections[i].json.idrecord);
            }
            var encoded_array = Ext.encode(prez);
            Ext.Ajax.request({
                waitMsg: 'Por favor Espere...',
                url: '../data/controlador_profesionales.php',
                params: {
                    task: "DELETE",
                    ids:  encoded_array
                },
                success: function(response){
                    var result=eval(response.responseText);
                    switch(result){
                        case 1:  // Success : simply reload
                            DGDataStore.reload();
                            break;
                        default:
                            Ext.MessageBox.alert('Error...','No podemos eliminar los registros en estos momentos');
                            break;
                    }
                },
                failure: function(response){
                    var result=response.responseText;
                    Ext.MessageBox.alert('Error Base Datos...','No podemos eliminar la información en estos momentos...');
                }
            });
        }
    }

    function startAdvancedSearch(){
        var SearchForm;
        var SearchWindow;
        var SearchDes;
        var SearchEsp;
        var SearchTipo;

        function listSearch(){
         // render according to a SQL date format.
         /*var startDate = "";
         var endDate = "";
         if(SearchEnteringItem.getValue() !== "") {
            startDate = SearchEnteringItem.getValue().format('Y-m-d');
         }
         if(SearchLeavingItem.getValue() !== "") {
            endDate = SearchLeavingItem.getValue().format('Y-m-d');
         }*/

            DGDataStore.baseParams = {
                task: 'SEARCH',
                Des: SearchDes.getValue(),
                Esp: SearchEsp.getValue(),
                Tipo: SearchTipo.getValue()
            };
            DGDataStore.reload({params: {start: 0, limit: 15}});
        }

        function resetSearch(){
            DGDataStore.baseParams = {
                task: 'LISTING',
                Des: null,
                Esp: null,
                Tipo: null
            };
            DGDataStore.reload({params: {start: 0, limit: 15}});
            SearchWindow.close();
        }

        SearchDes = new Ext.form.TextField({
            fieldLabel: 'Nombre',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });

        SearchEsp = new Ext.form.ComboBox({
            fieldLabel: 'Especialidad',
            store: dsEspecialidades,
            mode: 'local',
            loadingText: 'Cargando Especialidades...!',
            valueField: 'Codigo',
            displayField: 'Descripcion',
            emptyText: 'Todos',
            anchor:'95%',
            triggerAction: 'all'
        });

        SearchTipo = new Ext.form.ComboBox({
            fieldLabel: 'Tipo Profesional',
            store: dsTipoProfe,
            mode: 'local',
            loadingText: 'Cargando Tipo de Profesionales...!',
            valueField: 'Codigo',
            displayField: 'Descripcion',
            emptyText: 'Todos',
            anchor:'95%',
            triggerAction: 'all'
        });

        SearchForm = new Ext.FormPanel({
            bodyStyle: 'padding: 5px',
            width: 700,
            items: [{
                layout: 'form',
                border: false,
                items: [ SearchDes,SearchEsp,SearchTipo],
                buttons: [{
                    text: 'Buscar',
                    handler: listSearch
                },{
                    text: 'Cerrar y Limpair Busqueda',
                    handler: resetSearch
                }]
            }]
        });

        SearchWindow = new Ext.Window({
            title: 'Busqueda',
            closable:true,
            width: 750,
            height: 170,
            plain:true,
            modal:true,
            layout: 'fit',
            items: SearchForm
        });

        SearchWindow.show();
    }

    function onListingEditorGridContextMenu(grid, rowIndex, e) {
        e.stopEvent();
        var coords = e.getXY();
        DGListingContextMenu.rowRecord = grid.store.getAt(rowIndex);
        grid.selModel.selectRow(rowIndex);
        DGListingSelectedRow=rowIndex;
        DGListingContextMenu.showAt([coords[0], coords[1]]);
    }

    function modifyContextMenu(){
        DGListingEditorGrid.startEditing(DGListingSelectedRow,1);
    }

    function deleteContextMenu(){
        confirmDelete();
    }

    DGDataStore = new Ext.data.GroupingStore({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../data/controlador_profesionales.php',
            method: 'POST'
        }),
        baseParams:{task: "LISTING"},
        groupField: 'TipoProfe',
        loadMask: true,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'IDRecord', type: 'int', mapping: 'idrecord'},
            {name: 'Descripcion', type: 'string', mapping: 'descripcion'},
            {name: 'Especialidad', type: 'string', mapping: 'nomespecialidad'},
            {name: 'Registro', type: 'string', mapping: 'registro'},
            {name: 'Direccion', type: 'string', mapping: 'direccion'},
            {name: 'Telefono', type: 'string', mapping: 'telefono'},
            {name: 'Email', type: 'string', mapping: 'email'},
            {name: 'TipoProfe', type: 'string', mapping: 'nomtipoprofe'},
            {name: 'ProgramarAgenda', type: 'string', mapping: 'programar'},
            {name: 'ModificarKardex', type: 'string', mapping: 'modificar'},
            {name: 'VlrMulta', type: 'string', mapping: 'vlrmulta'},
            {name: 'Activo', type: 'string', mapping: 'activo'},
            {name: 'IdEsp', type: 'string', mapping: 'especialidad'},
            {name: 'IdTipo', type: 'int', mapping: 'tipoprofe'}
          ]),
      sortInfo:{field: 'IDRecord', direction: "ASC"}
    });

    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: 'ID Profesional',
            readOnly: true,
            sortable: true,
            dataIndex: 'IDRecord',
            width: 100,
            hidden: false
        },{
            header: 'Nombre',
            dataIndex: 'Descripcion',
            sortable: true,
            width: 300
        },{
            header: 'Especialidad',
            dataIndex: 'Especialidad',
            width: 250
        },{
            header: 'Registro Medico',
            dataIndex: 'Registro',
            width: 100
        },{
            header: 'Dirección',
            dataIndex: 'Direccion',
            width: 150
        },{
            header: 'Teléfono',
            dataIndex: 'Telefono',
            width: 150
        },{
            header: 'Email',
            dataIndex: 'Email',
            width: 150
        },{
            header: 'Tipo Profesional',
            dataIndex: 'TipoProfe',
            width: 150
        },{
            header: 'Programar Agenda',
            dataIndex: 'ProgramarAgenda',
            width: 50
        },{
            header: 'Modificar Kardex',
            dataIndex: 'ModificarKardex',
            width: 50
        },{
            header: "Vlr Multa",
            dataIndex: 'VlrMulta',
            align: 'right',
            width: 100,
            renderer:  Ext.util.Format.Currency
        },{
            header: 'Activo',
            dataIndex: 'Activo',
            width: 50
        },{
            header: 'IdEsp',
            readOnly: true,
            dataIndex: 'IdEsp',
            width: 0,
            hidden: true
        },{
            header: 'IdTipo',
            readOnly: true,
            dataIndex: 'IdTipo',
            width: 0,
            hidden: true
        }]
    );
    DGColumnModel.defaultSortable= true;

    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
        iconCls:'icon-grid',
        loadMask:true,
        view: new Ext.grid.GroupingView({
            groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
            getRowClass: function(record, index, rowParams, store){
                var estado = record.data.Activo;
                switch (estado)
                {
                    case "NO":
                        return 'NoActivo';
                        break;
                    default:
                        break;
                }
            }
        }),
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar: [{
            text: 'Adicionar',
            tooltip: 'Adicionar Registro...',
            iconCls:'add',                      
            handler: displayFormWindow
        },'-',{
            text: 'Modificar',
            tooltip: 'Modificar Registro...',
            iconCls:'edit',                     
            handler: ViewFormWindowEdit
        },'-',{
            text: 'Consultar',
            tooltip: 'Consultar Registro...',
            iconCls:'view',                     
            handler: ViewFormWindowView
        }, '-',{
            text: 'Eliminar',
            tooltip: 'Eliminar Registro(s)...',
            handler: confirmDelete,   
            iconCls:'remove'
        }, '-', { 
            text: 'Buscar',
            tooltip: 'Buscar Registros...',
            handler: startAdvancedSearch,
            iconCls:'search'
        }, '-', new Ext.app.SearchField({
                store: DGDataStore,
                params: {start: 0, limit: 15},
                width: 120
        })]
    });
    
    DGListingEditorGrid.addListener('rowcontextmenu', onListingEditorGridContextMenu);

    DGListingContextMenu = new Ext.menu.Menu({
        id: 'DGListingEditorGridContextMenu',
        items: [
            {text: 'Eliminar este Registro', handler: deleteContextMenu}
        ]
    });

    DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: ' ',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        tbar:['->',btnSalir],
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        }]
    });

    DGDataStore.load({params: {start: 0, limit: 15}});
    DGListingWindow.show();

    /*EnteringOfficeField = new Ext.form.DateField({
    id:'EnteringOfficeField',
    fieldLabel: 'Entering Office',
    format : 'm/d/Y',
    allowBlank: false,
    anchor:'95%'
    });*/

    IdRecordField = new Ext.form.NumberField({
        id: 'IdRecordField',
        fieldLabel: 'ID Profesional',
        maxLength: 200,
        anchor : '95%',
        vtype: 'exclusionNotZero',
        allowNegative: false,
        allowBlank: false
    });
    var pnIdRecordField = new Ext.Panel({
            id: 'pnIdRecordField',
            name:'pnIdRecordField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[IdRecordField]
    });
                
    DescripcionField = new Ext.form.TextField({
        id: 'DescripcionField',
        fieldLabel: 'Nombre',
        maxLength: 200,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnDescripcionField = new Ext.Panel({
            id: 'pnDescripcionField',
            name:'pnDescripcionField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[DescripcionField]
    });

    EspecialidadField = new Ext.form.ComboBox({
        id:'EspecialidadField',
        fieldLabel: 'Especialidad',
        store: dsEspecialidades,
        mode: 'local',
        loadingText: 'Cargando Especialidades...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione una Especialidad',
        allowBlank: false,
        anchor:'95%',
        listWidth : 500,
        triggerAction: 'all'
    });
    var pnEspecialidadField = new Ext.Panel({
            id: 'pnEspecialidadField',
            name:'pnEspecialidadField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[EspecialidadField]
    });

    RegistroField = new Ext.form.TextField({
        id: 'RegistroField',
        fieldLabel: 'Registro Medico',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        blankText: 'NA',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnRegistroField = new Ext.Panel({
            id: 'pnRegistroField',
            name:'pnRegistroField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[RegistroField]
    });

    DireccionField = new Ext.form.TextField({
        id: 'DireccionField',
        fieldLabel: 'Dirección',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnDireccionField = new Ext.Panel({
            id: 'pnDireccionField',
            name:'pnDireccionField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[DireccionField]
    });

    TelefonoField = new Ext.form.TextField({
        id: 'TelefonoField',
        fieldLabel: 'Teléfono',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnTelefonoField = new Ext.Panel({
            id: 'pnTelefonoField',
            name:'pnTelefonoField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[TelefonoField]
    });

    EmailField = new Ext.form.TextField({
        id: 'EmailField',
        fieldLabel: 'Email',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });
    var pnEmailField = new Ext.Panel({
            id: 'pnEmailField',
            name:'pnEmailField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[EmailField]
    });

    TipoProfeField = new Ext.form.ComboBox({
        id:'TipoProfeField',
        fieldLabel: 'Tipo Porfesional',
        store: dsTipoProfe,
        mode: 'local',
        loadingText: 'Cargando Tipo Profesionales...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione un Tipo de Profesional',
        allowBlank: false,
        anchor:'95%',
        triggerAction: 'all'
    });
    var pnTipoProfeField = new Ext.Panel({
            id: 'pnTipoProfeField',
            name:'pnTipoProfeField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[TipoProfeField]
    });

    ProgramarAgendaField = new Ext.form.Checkbox({
        id: 'ProgramarAgendaField',
        boxLabel: 'Permite Programar Agenda',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnProgramarAgendaField = new Ext.Panel({
            id: 'pnProgramarAgendaField',
            name:'pnProgramarAgendaField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ProgramarAgendaField]
    });

    ModificarKardexField = new Ext.form.Checkbox({
        id: 'ModificarKardexField',
        boxLabel: 'Permite Modificar Kardex de los Programas',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnModificarKardexField = new Ext.Panel({
            id: 'pnModificarKardexField',
            name:'pnModificarKardexField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ModificarKardexField]
    });

    VlrMultaField = new Ext.form.TextField({
        id: 'VlrMultaField',
        fieldLabel: 'Valor Multa',
        anchor : '95%',
        vtype: 'exclusionNotZero',
        allowNegative: false,
        allowBlank: false
    });
    var pnVlrMultaField = new Ext.Panel({
            id: 'pnVlrMultaField',
            name:'pnVlrMultaField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[VlrMultaField]
    });

    ActivoField = new Ext.form.Checkbox({
        id: 'ActivoField',
        boxLabel: 'Profesional Activo',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnActivoField = new Ext.Panel({
            id: 'pnActivoField',
            name:'pnActivoField',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ActivoField]
    });

    var fs0 = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnIdRecordField, pnDescripcionField, pnEspecialidadField, pnRegistroField]
    });

    var fs1 = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnTipoProfeField, pnDireccionField, pnTelefonoField, pnEmailField]
    });
    
    var fs2 = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnVlrMultaField, pnProgramarAgendaField, pnModificarKardexField, pnActivoField]
    });

    var Tabulador0 = new Ext.Panel({
        title: 'Sedes',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador1 = new Ext.Panel({
        title: 'Agendar Procedimientos/Consultas',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador2 = new Ext.Panel({
        title: 'Plantilla Procedimientos',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador3 = new Ext.Panel({
        title: '% Honorarios',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var TabPanel = new Ext.TabPanel({
        activeTab: 0,
        width: 970,
        height: 205,
        autoScroll: true,
        deferredRender: false,
        items: [Tabulador0,Tabulador1,Tabulador2,Tabulador3]
    });
    
    //Set 1
    IdRecordField1 = new Ext.form.NumberField({
        id: 'IdRecordField1',
        fieldLabel: 'ID Profesional',
        maxLength: 200,
        anchor : '95%',
        vtype: 'exclusionNotZero',
        allowNegative: false,
        allowBlank: false
    });
    var pnIdRecordField1 = new Ext.Panel({
            id: 'pnIdRecordField1',
            name:'pnIdRecordField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[IdRecordField1]
    });

    DescripcionField1 = new Ext.form.TextField({
        id: 'DescripcionField1',
        fieldLabel: 'Nombre',
        maxLength: 200,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnDescripcionField1 = new Ext.Panel({
            id: 'pnDescripcionField1',
            name:'pnDescripcionField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[DescripcionField1]
    });

    EspecialidadField1 = new Ext.form.ComboBox({
        id:'EspecialidadField1',
        fieldLabel: 'Especialidad',
        store: dsEspecialidades,
        mode: 'local',
        loadingText: 'Cargando Especialidades...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione una Especialidad',
        allowBlank: false,
        listWidth : 500,
        anchor:'95%',
        triggerAction: 'all'
    });
    var pnEspecialidadField1 = new Ext.Panel({
            id: 'pnEspecialidadField1',
            name:'pnEspecialidadField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[EspecialidadField1]
    });

    RegistroField1 = new Ext.form.TextField({
        id: 'RegistroField1',
        fieldLabel: 'Registro Medico',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        blankText: 'NA',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnRegistroField1 = new Ext.Panel({
            id: 'pnRegistroField1',
            name:'pnRegistroField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[RegistroField1]
    });

    DireccionField1 = new Ext.form.TextField({
        id: 'DireccionField1',
        fieldLabel: 'Dirección',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnDireccionField1 = new Ext.Panel({
            id: 'pnDireccionField1',
            name:'pnDireccionField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[DireccionField1]
    });

    TelefonoField1 = new Ext.form.TextField({
        id: 'TelefonoField1',
        fieldLabel: 'Teléfono',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnTelefonoField1 = new Ext.Panel({
            id: 'pnTelefonoField1',
            name:'pnTelefonoField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[TelefonoField1]
    });

    EmailField1 = new Ext.form.TextField({
        id: 'EmailField1',
        fieldLabel: 'Email',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });
    var pnEmailField1 = new Ext.Panel({
            id: 'pnEmailField1',
            name:'pnEmailField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[EmailField1]
    });

    TipoProfeField1 = new Ext.form.ComboBox({
        id:'TipoProfeField1',
        fieldLabel: 'Tipo Porfesional',
        store: dsTipoProfe,
        mode: 'local',
        loadingText: 'Cargando Tipo Profesionales...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione un Tipo de Profesional',
        allowBlank: false,
        anchor:'95%',
        triggerAction: 'all'
    });
    var pnTipoProfeField1 = new Ext.Panel({
            id: 'pnTipoProfeField1',
            name:'pnTipoProfeField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[TipoProfeField1]
    });

    ProgramarAgendaField1 = new Ext.form.Checkbox({
        id: 'ProgramarAgendaField1',
        boxLabel: 'Permite Programar Agenda',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnProgramarAgendaField1 = new Ext.Panel({
            id: 'pnProgramarAgendaField1',
            name:'pnProgramarAgendaField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ProgramarAgendaField1]
    });

    ModificarKardexField1 = new Ext.form.Checkbox({
        id: 'ModificarKardexField1',
        boxLabel: 'Permite Modificar Kardex de los Programas',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnModificarKardexField1 = new Ext.Panel({
            id: 'pnModificarKardexField1',
            name:'pnModificarKardexField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ModificarKardexField1]
    });

    VlrMultaField1 = new Ext.form.TextField({
        id: 'VlrMultaField1',
        fieldLabel: 'Valor Multa',
        anchor : '95%',
        vtype: 'exclusionNotZero',
        allowNegative: false,
        allowBlank: false
    });
    var pnVlrMultaField1 = new Ext.Panel({
            id: 'pnVlrMultaField1',
            name:'pnVlrMultaField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[VlrMultaField1]
    });

    ActivoField1 = new Ext.form.Checkbox({
        id: 'ActivoField1',
        boxLabel: 'Profesional Activo',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnActivoField1 = new Ext.Panel({
            id: 'pnActivoField1',
            name:'pnActivoField1',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ActivoField1]
    });

    var fs0a = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnIdRecordField1, pnDescripcionField1, pnEspecialidadField1, pnRegistroField1]
    });

    var fs1a = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnTipoProfeField1, pnDireccionField1, pnTelefonoField1, pnEmailField1]
    });

    var fs2a = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnVlrMultaField1, pnProgramarAgendaField1, pnModificarKardexField1, pnActivoField1]
    });

    var Tabulador0a = new Ext.Panel({
        title: 'Sedes',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador1a = new Ext.Panel({
        title: 'Agendar Procedimientos/Consultas',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador2a = new Ext.Panel({
        title: 'Plantilla Procedimientos',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador3a = new Ext.Panel({
        title: '% Honorarios',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var TabPanel1 = new Ext.TabPanel({
        activeTab: 0,
        width: 970,
        height: 205,
        autoScroll: true,
        deferredRender: false,
        items: [Tabulador0a,Tabulador1a,Tabulador2a,Tabulador3a]
    });

    // Set 2
    IdRecordField2 = new Ext.form.NumberField({
        id: 'IdRecordField2',
        fieldLabel: 'ID Profesional',
        maxLength: 200,
        anchor : '95%',
        vtype: 'exclusionNotZero',
        allowNegative: false,
        allowBlank: false
    });
    var pnIdRecordField2 = new Ext.Panel({
            id: 'pnIdRecordField2',
            name:'pnIdRecordField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[IdRecordField2]
    });

    DescripcionField2 = new Ext.form.TextField({
        id: 'DescripcionField2',
        fieldLabel: 'Nombre',
        maxLength: 200,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnDescripcionField2 = new Ext.Panel({
            id: 'pnDescripcionField2',
            name:'pnDescripcionField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[DescripcionField2]
    });

    EspecialidadField2 = new Ext.form.ComboBox({
        id:'EspecialidadField2',
        fieldLabel: 'Especialidad',
        store: dsEspecialidades,
        mode: 'local',
        loadingText: 'Cargando Especialidades...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione una Especialidad',
        allowBlank: false,
        listWidth : 500,
        anchor:'95%',
        triggerAction: 'all'
    });
    var pnEspecialidadField2 = new Ext.Panel({
            id: 'pnEspecialidadField2',
            name:'pnEspecialidadField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[EspecialidadField2]
    });

    RegistroField2 = new Ext.form.TextField({
        id: 'RegistroField2',
        fieldLabel: 'Registro Medico',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        blankText: 'NA',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnRegistroField2 = new Ext.Panel({
            id: 'pnRegistroField2',
            name:'pnRegistroField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[RegistroField2]
    });

    DireccionField2 = new Ext.form.TextField({
        id: 'DireccionField2',
        fieldLabel: 'Dirección',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnDireccionField2 = new Ext.Panel({
            id: 'pnDireccionField2',
            name:'pnDireccionField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[DireccionField2]
    });

    TelefonoField2 = new Ext.form.TextField({
        id: 'TelefonoField2',
        fieldLabel: 'Teléfono',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });
    var pnTelefonoField2 = new Ext.Panel({
            id: 'pnTelefonoField2',
            name:'pnTelefonoField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[TelefonoField2]
    });

    EmailField2 = new Ext.form.TextField({
        id: 'EmailField2',
        fieldLabel: 'Email',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });
    var pnEmailField2 = new Ext.Panel({
            id: 'pnEmailField2',
            name:'pnEmailField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[EmailField2]
    });

    TipoProfeField2 = new Ext.form.ComboBox({
        id:'TipoProfeField2',
        fieldLabel: 'Tipo Porfesional',
        store: dsTipoProfe,
        mode: 'local',
        loadingText: 'Cargando Tipo Profesionales...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione un Tipo de Profesional',
        allowBlank: false,
        anchor:'95%',
        triggerAction: 'all'
    });
    var pnTipoProfeField2 = new Ext.Panel({
            id: 'pnTipoProfeField2',
            name:'pnTipoProfeField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[TipoProfeField2]
    });

    ProgramarAgendaField2 = new Ext.form.Checkbox({
        id: 'ProgramarAgendaField2',
        boxLabel: 'Permite Programar Agenda',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnProgramarAgendaField2 = new Ext.Panel({
            id: 'pnProgramarAgendaField2',
            name:'pnProgramarAgendaField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ProgramarAgendaField2]
    });

    ModificarKardexField2 = new Ext.form.Checkbox({
        id: 'ModificarKardexField2',
        boxLabel: 'Permite Modificar Kardex de los Programas',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnModificarKardexField2 = new Ext.Panel({
            id: 'pnModificarKardexField2',
            name:'pnModificarKardexField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ModificarKardexField2]
    });

    VlrMultaField2 = new Ext.form.TextField({
        id: 'VlrMultaField2',
        fieldLabel: 'Valor Multa',
        anchor : '95%',
        vtype: 'exclusionNotZero',
        allowNegative: false,
        allowBlank: false
    });
    var pnVlrMultaField2 = new Ext.Panel({
            id: 'pnVlrMultaField2',
            name:'pnVlrMultaField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[VlrMultaField2]
    });

    ActivoField2 = new Ext.form.Checkbox({
        id: 'ActivoField2',
        boxLabel: 'Profesional Activo',
        inputValue: 'SI',
        anchor : '95%'
    });
    var pnActivoField2 = new Ext.Panel({
            id: 'pnActivoField2',
            name:'pnActivoField2',
            layout: 'form',
            border: false,
            width: 240,
            labelAlign: 'top',
            padding: 5,
            items:[ActivoField2]
    });

    var fs0b = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnIdRecordField2, pnDescripcionField2, pnEspecialidadField2, pnRegistroField2]
    });

    var fs1b = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnTipoProfeField2, pnDireccionField2, pnTelefonoField2, pnEmailField2]
    });

    var fs2b = new Ext.form.FieldSet({
        //title: 'Datos de Identificacion del Registro',
        layout: 'table',
        padding: 5,
        collapsible: false,
        border: false,
        layoutConfig: {
                columns: 4
        },
        items:[pnVlrMultaField2, pnProgramarAgendaField2, pnModificarKardexField2, pnActivoField2]
    });

    var Tabulador0b = new Ext.Panel({
        title: 'Sedes',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador1b = new Ext.Panel({
        title: 'Agendar Procedimientos/Consultas',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador2b = new Ext.Panel({
        title: 'Plantilla Procedimientos',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var Tabulador3b = new Ext.Panel({
        title: '% Honorarios',
        bodyStyle:'padding:5px 5px 5px 5px;',
        autoScroll: true,
        layout:'form',
        items: []
    });

    var TabPanel2 = new Ext.TabPanel({
        activeTab: 0,
        width: 970,
        height: 205,
        autoScroll: true,
        deferredRender: false,
        items: [Tabulador0b,Tabulador1b,Tabulador2b,Tabulador3b]
    });

    DGCreateForm = new Ext.FormPanel({
        labelAlign: 'top',
        bodyStyle:'padding:5px',
        width: 990,
        //layout:'form',
        items: [fs0, fs1, fs2, TabPanel],
        buttons: [{
            text: 'Guardar',
            handler: createRecord
        },{
            text: 'Cerrar',
            handler: function(){
                DGCreateWindow.hide();
        }
      }]
    });

    DGModifyForm = new Ext.FormPanel({
        labelAlign: 'top',
        bodyStyle:'padding:5px',
        width: 990,
        items: [fs0b, fs1b, fs2b, TabPanel2],
        buttons: [{
            text: 'Modificar y Cerrar',
            handler: modifyRecord
        },{
            text: 'Cancelar',
            handler: function(){
                DGModifyWindow.hide();
            }
        }]
    });

    DGViewForm = new Ext.FormPanel({
        labelAlign: 'top',
        bodyStyle:'padding:5px',
        width: 990,
        readOnly: true,
        items: [fs0a, fs1a, fs2a, TabPanel1],
        buttons: [{
            text: 'Cerrar',
            handler: function(){
                DGViewWindow.hide();
            }
        }]
    });

    DGCreateWindow= new Ext.Window({
        id: 'DGCreateWindow',
        title: 'Crear Profesional',
        closable: false,
        width: 1000,
        height: 600,
        modal: true,
        plain:true,
        layout: 'fit',
        items: DGCreateForm
    });

    DGModifyWindow= new Ext.Window({
        id: 'DGModifyWindow',
        title: 'Modificar Profesional',
        closable: false,
        width: 1000,
        height: 600,
        plain:true,
        layout: 'fit',
        items: DGModifyForm
    });

    DGViewWindow= new Ext.Window({
        id: 'DGViewWindow',
        title: 'Consultar Profesional',
        closable: false,
        width: 1000,
        height: 600,
        plain:true,
        layout: 'fit',
        items: DGViewForm
    });
});

