/*
* @category    Programacion Eventos Formulario Usuarios del Sistema
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmUsuariosSist = Ext.extend(winFrmUsuariosSistUi, {
    initComponent: function() {
        winFrmUsuariosSist.superclass.initComponent.call(this);
        
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        
        this.title = NOM_APLICACION + " .:: Usuarios del Sistema ::.";
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        if(NOM_APLICACION == "OfiClinic"){
            Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        }else{
            Ext.getCmp('fNomEmpresa').setValue("");
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("");
        }
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddTipoHorario = Ext.getCmp('btnAddTipoHorario').on("click",this.AddTipoHorario,this);
        var btnEditTipoHorario = Ext.getCmp('btnEditTipoHorario').on("click",this.EditTipoHorario,this);
        var btnAsociarUsuario = Ext.getCmp('btnAsociarUsuario').on("click",this.AsociarUsuarioIPS,this);
        var btnDesasociarUsuario = Ext.getCmp('btnDesasociarUsuario').on("click",this.DesasociarUsuarioIPS,this);
        var btnAsociarUsuarioBod = Ext.getCmp('btnAsociarUsuarioBod').on("click",this.AsociarUsuarioBOD,this);
        var btnDesasociarUsuarioBod = Ext.getCmp('btnDesasociarUsuarioBod').on("click",this.DesasociarUsuarioBOD,this);

        var sm_gridusuarios = Ext.getCmp('gridUsuarios').getSelectionModel();
        sm_gridusuarios.on("rowselect",this.UpdateIPSAsociadasUSR,this);
    },
    CerrarVentanaAsociarBOD: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winAsocUsuariosSistBod').close();
                }
            }
        });
    },
    AsociarUsuarioBOD: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AsocUsuarioSistema";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Usuarios del Sistema - Asociar BODEGAS:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridUsuarios').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridUsuarios').selModel.getSelections();
                var winAddTipoHorario = new winAsocUsuariosSistBodUi();
                winAddTipoHorario.title = NOM_APLICACION + ' .::Asociar Usuario del Sistema a Bodega::.';
                Ext.getCmp('intUsuarioBOD').setValue(selections[0].json.IdUsuario);
                Ext.getCmp('sysUsuarioBOD').setValue(selections[0].json.Descripcion);

                var btn_AsociarIPS = Ext.getCmp('btn_AsociarBOD').on("click",this.AsociarUsrBOD,this);
                var btn_SalirAsociarIPS = Ext.getCmp('btn_SalirAsociarBOD').on("click",this.CerrarVentanaAsociarBOD,this);
                winAddTipoHorario.show();
            }
        }
    },
    AsociarUsrBOD: function(){
        Ext.Msg.show({
            title: 'Asociar Usuario - Bodega',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("ASOCIAR_BODEGA","SI","winAsocUsuariosSistBod","frmAsocUsuarioBOD","../../controlador/usuariossit/controlador_usuariosist.php","gridUsuariosBodegas");
                }
            }
        })    
    },
    DesasociarUsuarioBOD: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DesasocUsuarioSistema";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Usuarios del Sistema - Eliminar Asociación a Bodegas:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridUsuariosBodegas').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridUsuariosBodegas').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Usuarios',
                    msg: 'Esta Seguro que Desea Eliminar la Asociación a la Bodega ' + selections[0].json.Descripcion + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/usuariossit/controlador_usuariosist.php",{task: "DESASOCIAR_BODEGAS", pUsuario: selections[0].json.IdUsuario, pBodega: selections[0].json.IdBodega}, 'gridUsuariosBodegas');
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }  
    },
    UpdateIPSAsociadasUSR: function(sm, rowIdx, r) {
        Ext.getCmp('gridUsuariosIPS').store.reload({
            params: {
                pUsuario: r.data.IdUsuario
            }
        });
        Ext.getCmp('gridUsuariosBodegas').store.reload({
            params: {
                pUsuario: r.data.IdUsuario
            }
        });
    },
    SalirOpcion: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    
    AddTipoHorario: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddUsuarioSistema";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Usuarios del Sistema - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            el = Ext.get('idaplicacion');
            var NOM_APLICACION = el.getValue();
            var winAddTipoHorario = new winUsuariosSistUi();
            winAddTipoHorario.title = NOM_APLICACION + ' .::Adicionar Usuarios del Sistema::.';
            Ext.getCmp('btn_AdicionarHorario').setVisible(true);
            Ext.getCmp('btn_ModificarHorario').setVisible(false);
            Ext.getCmp('intEmpresa').setValue(ID_EMPRESA);
            var btn_AdicionarHorario = Ext.getCmp('btn_AdicionarHorario').on("click",this.GuardarTipoHorario,this);
            var btn_SalirHorario = Ext.getCmp('btn_SalirHorario').on("click",this.CerrarVentana,this);
            winAddTipoHorario.show();
        }
    },
    AsociarUsuarioIPS: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AsocUsuarioSistema";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Usuarios del Sistema - Asociar IPS:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridUsuarios').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridUsuarios').selModel.getSelections();
                var winAddTipoHorario = new winAsocUsuariosSistUi();
                winAddTipoHorario.title = NOM_APLICACION + ' .::Asociar Usuario del Sistema a IPS::.';
                Ext.getCmp('intUsuario').setValue(selections[0].json.IdUsuario);
                Ext.getCmp('sysUsuario').setValue(selections[0].json.Descripcion);

                var btn_AsociarIPS = Ext.getCmp('btn_AsociarIPS').on("click",this.AsociarUsrIPS,this);
                var btn_SalirAsociarIPS = Ext.getCmp('btn_SalirAsociarIPS').on("click",this.CerrarVentanaAsociarIPS,this);
                winAddTipoHorario.show();
            }
        }
    },
    AsociarUsrIPS: function(){
        Ext.Msg.show({
            title: 'Asociar Usuario - IPS',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("ASOCIAR_IPS","SI","winAsocUsuariosSist","frmAsocUsuario","../../controlador/usuariossit/controlador_usuariosist.php","gridUsuariosIPS");
                }
            }
        })    
    },
    DesasociarUsuarioIPS: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DesasocUsuarioSistema";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Usuarios del Sistema - Eliminar Asociación a IPS:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridUsuariosIPS').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridUsuariosIPS').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Usuarios',
                    msg: 'Esta Seguro que Desea Eliminar la Asociación a la IPS ' + selections[0].json.Descripcion + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/usuariossit/controlador_usuariosist.php",{task: "DESASOCIAR_IPS", pUsuario: selections[0].json.IdUsuario, pIPS: selections[0].json.IdIps}, 'gridUsuariosIPS');
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }  
    },
    EditTipoHorario: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditUsuarioSistema";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Usuarios del Sistema - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridUsuarios').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridUsuarios').selModel.getSelections();
                var winAddTipoHorario = new winUsuariosSistUi();
                winAddTipoHorario.title = NOM_APLICACION + ' .::Modificar Usuario del Sistema::.';
                Ext.getCmp('btn_AdicionarHorario').setVisible(false);
                Ext.getCmp('btn_ModificarHorario').setVisible(true);
                Ext.getCmp('intEmpresa').setValue(selections[0].json.IdEmpresa);
                Ext.getCmp('intUsuario').setValue(selections[0].json.IdUsuario);
                Ext.getCmp('strCodUsuario').setValue(selections[0].json.CodUsuario);
                Ext.getCmp('strClaveUsuario').setValue(selections[0].json.ClaveUsuario);
                Ext.getCmp('strDescripcion').setValue(selections[0].json.Descripcion);
                Ext.getCmp('intPerfilUsuario').setValue(selections[0].json.IdPerfil);
                Ext.getCmp('intProfesionalUsuario').setValue(selections[0].json.IdProfesionalHC);
                if(selections[0].json.Activo == '1')
                    Ext.getCmp('bolActivo').setValue(true);
                else
                    Ext.getCmp('bolActivo').setValue(false);
                
                var btn_ModificarHorario = Ext.getCmp('btn_ModificarHorario').on("click",this.ModificarTipoHorario,this);
                var btn_SalirHorario = Ext.getCmp('btn_SalirHorario').on("click",this.CerrarVentana,this);
                winAddTipoHorario.show();
            }
        }
    },
    GuardarTipoHorario: function(){
        Ext.Msg.show({
            title: 'Guardar usuario del sistema',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR","SI","winUsuariosSistUi","frmUsuario","../../controlador/usuariossit/controlador_usuariosist.php","gridUsuarios");
                }
            }
        });
    },
    ModificarTipoHorario: function(){
        Ext.Msg.show({
            title: 'Guardar Usuario del Ssistema',
            msg: 'Esta Seguro que Desea Modificar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR","SI","winUsuariosSistUi","frmUsuario","../../controlador/usuariossit/controlador_usuariosist.php","gridUsuarios");
                }
            }
        });
    },
    CerrarVentanaAsociarIPS: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winAsocUsuariosSist').close();
                }
            }
        });
    },
    CerrarVentana: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winUsuariosSistUi').close();
                }
            }
        });
    }
});


function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
