/*
* @category    Programacion Eventos Formulario Cambiar Contraseña
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winCambiarContraseña = Ext.extend(winCambiarContraseñaUi, {
    initComponent: function() {
        winCambiarContraseña.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        
        this.title = NOM_APLICACION + " .:: Cambiar Contraseña ::.";
        
        if(NOM_APLICACION == "OfiClinic"){
            Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        }else{
            Ext.getCmp('fNomEmpresa').setValue("");
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("");
        }
        
        Ext.getCmp('intUsuario').setValue(ID_USUARIO);
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnUnificar = Ext.getCmp('btnUnificar').on("click",this.Unificar,this);
        
    },
    BuscarPacienteMalo: function(){
        buscarpaciente("UnificaPacienteMalo");
    },
    BuscarPacienteBueno: function(){
        buscarpaciente("UnificaPacienteBueno");
    },
    Unificar: function(){
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cambiar su contraseña?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmUnificarPaciente').getForm();
                    if (frm.isValid())
                    {
                        if(Ext.getCmp('fPassNew').getValue() == Ext.getCmp('fREPassNew').getValue()){
                            frm.submit({
                                url: '../../controlador/usuariossit/controlador_usuariosist.php',
                                params: {
                                    task: 'CAMBIARPASS',
                                    pUsuario: ID_USUARIO,
                                    pPassNew: Ext.getCmp('fPassNew').getValue()
                                },
                                success: function(res,req)
                                {
                                    switch(req.result.requestedId){
                                        case "1":
                                            Ext.MessageBox.show({
                                                title: NOM_APLICACION,
                                                msg: 'Se cambio la contraseña con exitos.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.INFO
                                            });
                                            window.close();
                                            break;

                                        default:
                                            Ext.MessageBox.show({
                                                title: NOM_APLICACION,
                                                msg: 'Ocurrio un error al cambiar la contraseña o no se pudo establecer conexión con el servidor.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                            break;
                                    }
                                },
                                failure: function(response,options)
                                {
                                    Ext.MessageBox.show({
                                        title: 'Error Base Datos',
                                        msg: 'No podemos cambiar la contraseña en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: NOM_APLICACION,
                                msg: 'Las contraseñas ingresadas no coinciden',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Debe verificar los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

