/*
* @category    Formulario Asociar Usuarios del Sistema a Bodega
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAsocUsuariosSistBodUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Asociar Usuarios del Sistema a Bodega (Punto de Venta) ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAsocUsuariosSistBod',
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();

        st = new StoreBodegas();
        st.load({
            params: {
                pIPS: ID_IPS
            }
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAsocUsuarioBOD',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/users.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioBOD',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripción',
                                allowBlank: false,
                                emptyText: 'Descripción del Usuario',
                                id: 'sysUsuarioBOD'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Bodega',
                                anchor: '100%',
                                allowBlank: false,
                                store: st,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdBodega',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intBodegaAsocUsr'
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Asociar Usuario',
                            iconCls: 'btnGuardar',
                            id: 'btn_AsociarBOD'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirAsociarBOD'
                        }
                    ]
                }
            }
        ];
        winAsocUsuariosSistBodUi.superclass.initComponent.call(this);
    }
});
