/*
* @category    Formulario Turnero Basico
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winTurneroBasicoUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©      .:: TURNERO TOMA MUESTRAS ::.',
    width: 990,
    autoHeight: true,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winTurneroBasico',
    initComponent: function() {
        
        //Store Locales
        var dataModulos = [
            ['FICHA ROJA']
        ];
        var stModulos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stModulos.loadData(dataModulos);
        
        var dataModulosAzul = [
            ['FICHA AZUL']
        ];
        var stModulosAzul = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stModulosAzul.loadData(dataModulosAzul);
        
        var dataModulosCosmitet = [
            ['COSMITET']
        ];
        var stModulosCosmitet = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stModulosCosmitet.loadData(dataModulosCosmitet);
        
        this.items = [
            {
                xtype: 'panel',
                layout: "form",
                autoHeight: true,
                width: 951,
                frame: true,
                border: false,
                autoScroll: true, 
                items: [
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        items: [
                            {
                                xtype: 'combo',
                                //fieldLabel: 'Turno Rojo',
                                width: 200,
                                allowBlank: false,
                                store: stModulos,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                value: 'FICHA ROJA',
                                style: 'color: red; font-weight: bold;',
                                id: 'sysModuloNro'
                            },
                            {
                                html: ' | '
                            },
                            {
                                xtype: 'textfield',
                                width: 50,
                                value: 0,
                                style: 'color: red; font-weight: bold; text-align:center',
                                id: 'sysNroTurno'
                            },
                            {
                                html: ' | '
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnAdd',
                                text: 'Siguiente',
                                listeners: {
                                    click: function(){
                                        if(Ext.getCmp('sysModuloNro').getValue() !== "" && Ext.getCmp('sysModuloNro').getValue() !== null){
                                            Ext.getCmp('sysNroTurno').setValue(parseInt(Ext.getCmp('sysNroTurno').getValue()) + 1);
                                            xPaciente = Ext.getCmp('sysModuloNro').getValue() + " - NUMERO " + Ext.getCmp('sysNroTurno').getValue() + " TOMA MUESTRAS";
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/pacientes/controlador_pacientes1801.php",
                                                params: {
                                                    task: "LLAMAR_PACIENTE",
                                                    pCAS: Ext.getCmp('sysNroTurno').getValue(),
                                                    pInfoLlamada: xPaciente,
                                                    pHora: "FICHA ROJA NRO. " + Ext.getCmp('sysNroTurno').getValue()
                                                },
                                                success: function(response){
                                                    var result = response.responseText;
                                                },
                                                failure: function(response){
                                                    var result = response.responseText;
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'compositefield',
                        items: [
                            {
                                xtype: 'combo',
                                //fieldLabel: 'Turno Azul',
                                width: 200,
                                allowBlank: false,
                                store: stModulosAzul,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                value: 'FICHA AZUL',
                                style: 'color: blue; font-weight: bold;',
                                id: 'sysModuloNroAzul'
                            },
                            {
                                html: ' | '
                            },
                            {
                                xtype: 'textfield',
                                width: 50,
                                value: 0,
                                style: 'color: blue; font-weight: bold; text-align:center;',
                                id: 'sysNroTurnoAzul'
                            },
                            {
                                html: ' | '
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnAdd',
                                text: 'Siguiente',
                                listeners: {
                                    click: function(){
                                        if(Ext.getCmp('sysModuloNroAzul').getValue() !== "" && Ext.getCmp('sysModuloNroAzul').getValue() !== null){
                                            Ext.getCmp('sysNroTurnoAzul').setValue(parseInt(Ext.getCmp('sysNroTurnoAzul').getValue()) + 1);
                                            xPaciente = Ext.getCmp('sysModuloNroAzul').getValue() + " - NUMERO " + Ext.getCmp('sysNroTurnoAzul').getValue() + " TOMA MUESTRAS";
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/pacientes/controlador_pacientes1801.php",
                                                params: {
                                                    task: "LLAMAR_PACIENTE",
                                                    pCAS: Ext.getCmp('sysNroTurnoAzul').getValue(),
                                                    pInfoLlamada: xPaciente,
                                                    pHora: "FICHA AZUL NRO. " + Ext.getCmp('sysNroTurnoAzul').getValue()
                                                },
                                                success: function(response){
                                                    var result = response.responseText;
                                                },
                                                failure: function(response){
                                                    var result = response.responseText;
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'compositefield',
                        items: [
                            {
                                xtype: 'combo',
                                //fieldLabel: 'Turno Azul',
                                width: 200,
                                allowBlank: false,
                                store: stModulosCosmitet,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                value: 'COSMITET',
                                style: 'color: black; font-weight: bold;',
                                id: 'sysModuloNroCosmitet'
                            },
                            {
                                html: ' | '
                            },
                            {
                                xtype: 'textfield',
                                width: 50,
                                value: 0,
                                style: 'color: black; font-weight: bold; text-align:center;',
                                id: 'sysNroTurnoCosmitet'
                            },
                            {
                                html: ' | '
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnAdd',
                                text: 'Siguiente',
                                listeners: {
                                    click: function(){
                                        if(Ext.getCmp('sysModuloNroCosmitet').getValue() !== "" && Ext.getCmp('sysModuloNroCosmitet').getValue() !== null){
                                            Ext.getCmp('sysNroTurnoCosmitet').setValue(parseInt(Ext.getCmp('sysNroTurnoCosmitet').getValue()) + 1);
                                            xPaciente = Ext.getCmp('sysModuloNroCosmitet').getValue() + " - NUMERO " + Ext.getCmp('sysNroTurnoCosmitet').getValue() + " TOMA MUESTRAS";
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/pacientes/controlador_pacientes1801.php",
                                                params: {
                                                    task: "LLAMAR_PACIENTE",
                                                    pCAS: Ext.getCmp('sysNroTurnoCosmitet').getValue(),
                                                    pInfoLlamada: xPaciente,
                                                    pHora: "COSMITET NRO. " + Ext.getCmp('sysNroTurnoCosmitet').getValue()
                                                },
                                                success: function(response){
                                                    var result = response.responseText;
                                                },
                                                failure: function(response){
                                                    var result = response.responseText;
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    //value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winTurneroBasicoUi.superclass.initComponent.call(this);
    }
});
