/*
* @category    Formulario Turnero Basico
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winTurneroBasicoUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©      .:: TURNERO BASICO ::.',
    width: 990,
    autoHeight: true,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winTurneroBasico',
    initComponent: function() {
        
        //Store Locales
        var dataModulos = [
            ['PROGRAMAS ESPECIALES']
        ];
        var stModulos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stModulos.loadData(dataModulos);
        
        this.items = [
            {
                xtype: 'panel',
                layout: "form",
                autoHeight: true,
                width: 951,
                frame: true,
                border: false,
                autoScroll: true, 
                items: [
                    {
                        xtype: 'compositefield',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Modulo:',
                                width: 200,
                                allowBlank: false,
                                store: stModulos,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysModuloNro'
                            },
                            {
                                html: ' | '
                            },
                            {
                                xtype: 'textfield',
                                width: 50,
                                value: 0,
                                id: 'sysNroTurno'
                            },
                            {
                                html: ' | '
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnAdd',
                                text: 'Siguiente',
                                listeners: {
                                    click: function(){
                                        if(Ext.getCmp('sysModuloNro').getValue() !== "" && Ext.getCmp('sysModuloNro').getValue() !== null){
                                            Ext.getCmp('sysNroTurno').setValue(parseInt(Ext.getCmp('sysNroTurno').getValue()) + 1);
                                            xPaciente = Ext.getCmp('sysModuloNro').getValue() + " - TURNO " + Ext.getCmp('sysNroTurno').getValue();
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/pacientes/controlador_pacientes1801.php",
                                                params: {
                                                    task: "LLAMAR_PACIENTE",
                                                    pCAS: Ext.getCmp('sysNroTurno').getValue(),
                                                    pInfoLlamada: xPaciente,
                                                    pHora: "TURNO " + Ext.getCmp('sysNroTurno').getValue()
                                                },
                                                success: function(response){
                                                    var result = response.responseText;
                                                },
                                                failure: function(response){
                                                    var result = response.responseText;
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    //value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winTurneroBasicoUi.superclass.initComponent.call(this);
    }
});
