/*
* @category    Formulario Grid TomaMuestras
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmTomaMuestrasUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: TomaMuestras ::.',
    id: 'winFrmTomaMuestras',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    initComponent: function() {
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };

        Ext.apply(Ext.form.VTypes,{
            exclusionNotZero: function(val, field){
                try{
                    if (val < 1){
                        return false;
                    } else {
                        field.clearInvalid();
                        return true;
                    }
                }catch(e){
                    return false;
                }
            },
            exclusionNotZeroText: 'No puede tener valor cero!'
        });
        function renderExamen(value, p, record){
            return String.format(
                '<table border="0"><tr><td><b>{0}</b></td></tr><tr><td><span style="color:darkred;">Obs: {1}</span></td></tr></table>',
                value, record.data.NAP_obs);
        }
        var mybbar = new utilBbarUi();
        var stGrid = new StoreGridTomaMuestras();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'grid',
                id: 'gridFormulario',
                store: stGrid,
                anchor: "100%",
                height: 390,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'CAS',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'CAS',
                        width: 100,
                        hideable: false
                    },{
                        header: 'Paciente',
                        dataIndex: 'nomPaciente',
                        sortable: true,
                        //locked: true,
                        width: 300
                    },{
                        header: 'Examenes',
                        dataIndex: 'itemsExamen',
                        sortable: true,
                        //locked: true,
                        renderer: renderExamen,
                        width: 370
                    },{
                        header: 'Turno',
                        dataIndex: 'Turno',
                        sortable: true,
                        //locked: true,
                        width: 60
                    },{
                        header: 'Consecutivo',
                        dataIndex: 'NADEF',
                        sortable: true,
                        //locked: true,
                        width: 100
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView({
                view: new Ext.ux.grid.LockingGridView({
                    //groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.Estrategia;
                        switch (estado)
                        {
                            case "1":
                                return 'Apto';
                                break;
                            default:
                                break;
                        }
                    }
                }),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Actualizar Lista',
                                iconCls: 'btnActualizarGrid',
                                listeners: {
                                    click: function(){
                                        Ext.getCmp('gridFormulario').store.load();
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Registrar Toma',
                                iconCls: 'btnFiltro',
                                id: 'btnRegistrarToma'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnImprimir',
                                text: 'Imprimir Stiker',
                                id: 'btnImprimirStiker'
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        winFrmTomaMuestrasUi.superclass.initComponent.call(this);
    }
});