/*
* @category    Formulario Adicionar Solicitud Remisiones
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolRemIPS001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Remisiones ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolRemIPS001Ui',
    initComponent: function() {
        var selMx = "0";
        StoreEspecialidadesRemisiones = Ext.extend(Ext.data.JsonStore, {
            constructor: function(cfg) {
                cfg = cfg || {};
                StoreEspecialidadesRemisiones.superclass.constructor.call(this, Ext.apply({
                    url: '../../controlador/combobox/cbespecialidades.php',
                    root: 'rows',
                    baseParams: '',
                    autoLoad: true,
                    storeId: 'StoreEspecialidadesRemisiones',
                    fields: [
                        {
                            name: 'Codigo'
                        },
                        {
                            name: 'Descripcion'
                        }
                    ]
                }, cfg));
            }
        });
        stEspecialidadesRemisiones = new StoreEspecialidadesRemisiones();
       
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddRemisiones',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysYaGuardoRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strTipoRem',
                                value: "R",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Descripción',
                                anchor: '100%',
                                allowBlank: false,
                                store: stEspecialidadesRemisiones,
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'strConceptoOfiMedicalRem'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Remisión',
                                anchor: '100%',
                                height: 350,
                                allowBlank: false,
                                id: 'memRemision'
                            },
                            {
                                xtype: 'hidden',
                                id: 'strSelectConceptoRem',
                                allowBlank: true
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddRem',
                            listeners:{
                                click : function(){
                                    if(parseInt(Ext.getCmp('sysYaGuardoRem').getValue())===0){
                                        Ext.getCmp('sysYaGuardoRem').setValue(1);
                                        fnGuardarRegItemRemIPS001("GUARDAR_OFICLINIC","SI","winSolRemIPS001Ui","frmAddRemisiones","../../controlador/solrem/controlador_solrem.php","gridRemisionesHC");
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winSolRemIPS001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemRemIPS001(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        Ext.getCmp('strSelectConceptoRem').setValue(parseInt(Ext.getCmp('strConceptoOfiMedicalRem').getValue()));
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        /*Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });*/
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        Ext.getCmp('sysYaGuardoRem').setValue(0);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        Ext.getCmp('sysYaGuardoRem').setValue(0);
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
                Ext.getCmp('sysYaGuardoRem').setValue(0);
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
