/*
* @category    Formulario Adicionar Registro - NO POS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winRegistroItemNOPOSUi = Ext.extend(Ext.Window, {
    title: '.:: Servicio NO POS ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winRegistroItemNOPOSUi',
    initComponent: function() {
        //Ext.QuickTips.init();
        //Ext.form.Field.prototype.msgTarget = 'side';
        var stServicioNOPOS = new StoreServiciosNOPOS();
        var dataCaracterServicioItemNOPOS = [
            ['UNICO'],
            ['SUCESIVO']
        ];
        var stCaracterServicioItemNOPOS = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCaracterServicioItemNOPOS.loadData(dataCaracterServicioItemNOPOS);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmRegistroItemNOPOS',
                padding: 10,
                labelWidth: 200,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdItemNOPOS',
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Servicio',
                                        name: 'Tipo Servicio',
                                        width: 220,
                                        allowBlank: false,
                                        store: 'StoreTipoNOPOS',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strTipoServicioItemNOPOS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() !== "" || cmb.getValue() !== null){
                                                    Ext.getCmp('strDescripcionItemNOPOS').store.removeAll();
                                                    Ext.getCmp('strDescripcionItemNOPOS').setValue(null);
                                                    Ext.getCmp('strDescripcionItemNOPOS').store.load({
                                                        params: {
                                                            pTipoServicio: Ext.getCmp('strTipoServicioItemNOPOS').getValue()
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Descripcion:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 445,
                                        allowBlank: false,
                                        store: stServicioNOPOS,
                                        typeAhead: true,
                                        typeAheadDelay: 450,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: false,
                                        id: 'strDescripcionItemNOPOS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() !== "" || cmb.getValue() !== null){
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').setReadOnly(true);
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(1);
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = true;
                                                    Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = true;
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').setReadOnly(true);
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').setValue(null);
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = true;
                                                    if(rec.data.Caracter !== "" && rec.data.Caracter !== null){
                                                        Ext.getCmp('strCaracterItemNOPOS').setValue(rec.data.Caracter);
                                                    }
                                                    if(rec.data.CaracterCantidad !== "" && rec.data.CaracterCantidad !== null){
                                                        Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(rec.data.CaracterCantidad);
                                                        if(rec.data.Caracter === "SUCESIVO"){
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').setReadOnly(false);
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = false;
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = false;
                                                        }else{
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').setReadOnly(true);
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(1);
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = true;
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = true;
                                                        }
                                                    }
                                                    if(rec.data.CaracterDias !== "" && rec.data.CaracterDias !== null){
                                                        Ext.getCmp('strCaracterDiasItemNOPOS').setValue(rec.data.CaracterDias);
                                                        if(rec.data.Caracter === "SUCESIVO"){
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').setReadOnly(false);
                                                        }else{
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').setReadOnly(true);
                                                        }
                                                    }
                                                    if(rec.data.Homologo !== "" && rec.data.Homologo !== null){
                                                        Ext.getCmp('strHomologoItemNOPOS').setValue(rec.data.Homologo);
                                                    }
                                                    if(rec.data.HomologoSustituto !== "" && rec.data.HomologoSustituto !== null){
                                                        Ext.getCmp('strHomologoSustitutoItemNOPOS').setValue(rec.data.HomologoSustituto);
                                                        if(rec.data.Homologo === "SI"){
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').setReadOnly(false);
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = false;
                                                        }else{
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').setReadOnly(true);
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = true;
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').setValue(null);
                                                        }
                                                    }
                                                    if(rec.data.Justificacion !== "" && rec.data.Justificacion !== null){
                                                        Ext.getCmp('memJustificacionItemNOPOS').setValue(rec.data.Justificacion);
                                                    }
                                                    if(rec.data.Evidencia !== "" && rec.data.Evidencia !== null){
                                                        Ext.getCmp('memEvidenciaItemNOPOS').setValue(rec.data.Evidencia);
                                                    }
                                                    if(rec.data.Casuistica !== "" && rec.data.Casuistica !== null){
                                                        Ext.getCmp('memCasuisticaItemNOPOS').setValue(rec.data.Casuistica);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Uso',
                                        name: 'Uso',
                                        width: 100,
                                        allowBlank: false,
                                        store: stCaracterServicioItemNOPOS,
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strCaracterItemNOPOS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() === "SUCESIVO"){
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').setReadOnly(false);
                                                    Ext.getCmp('strCaracterDiasItemNOPOS').setReadOnly(false);
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = false;
                                                    Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = false;
                                                }else{
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').clearInvalid();
                                                    Ext.getCmp('strCaracterDiasItemNOPOS').clearInvalid();
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').setReadOnly(true);
                                                    Ext.getCmp('strCaracterDiasItemNOPOS').setReadOnly(true);
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(1);
                                                    Ext.getCmp('strCaracterDiasItemNOPOS').setValue(null);
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = true;
                                                    Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Cantidad:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        name: 'Cantidad',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strCaracterCantidadItemNOPOS'
                                    },
                                    {
                                        html: 'Dias:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 393,
                                        name: 'Dias',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strCaracterDiasItemNOPOS'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Homologo',
                                        name: 'Homologo',
                                        width: 70,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strHomologoItemNOPOS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() === "SI"){
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').setReadOnly(false);
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = false;
                                                }else{
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').clearInvalid();
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').setReadOnly(true);
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').setValue(null);
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Sustituto:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 605,
                                        name: 'Sustituto',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strHomologoSustitutoItemNOPOS'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Justificacion',
                                name: 'Justificacion',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memJustificacionItemNOPOS'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Evidencia',
                                name: 'Evidencia',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memEvidenciaItemNOPOS'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Casuistica',
                                name: 'Casuistica',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memCasuisticaItemNOPOS'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddItemNOPOS',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Guardar Tipo Servicio NO POS',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn === "yes"){
                                                fnGuardarRegItemNOPOS("GUARDAR_ITEM_NOPOS","SI","winRegistroItemNOPOSUi","frmRegistroItemNOPOS","../../controlador/nopos/controlador_nopos.php","gridDetalleSolicitudNOPOS");
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winRegistroItemNOPOSUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemNOPOS(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.reload();
                            }
                        }
                        if(pCerrar === "SI"){
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
