/*
* @category    Solicitud Medicamentos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

SolNOPOS001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    //autoHeight: true,
    height: 325,
    initComponent: function() {
        function renderSolicitudNOPOS(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<span style="color: blue;">' + value + '</span></br>Fecha:' + record.get('FecSolicitud') + '</br>Profesional:' + record.get('nomProfesional');
        }
        
        this.items = [
            {
                xtype: 'container',
                width: 915,
                height: 320,
                layout: 'border',
                items: [
                    {
                        xtype: 'panel',
                        region: 'center',
                        anchor: '100%',
                        height: 317,
                        border: true,
                        autoLoad:{
                            url:'../../../app/controlador/nopos/viewsolicitudnopos001.php?pPaciente=' + wPaciente + '&pSolicitud=0',
                            scripts: true,
                            scope: this
                        },
                        autoScroll: true,
                        closable: false,
                        id: 'DetalleNOPOSxPaciente',
                        tbar:{
                            xtype: 'toolbar',
                            items: [
                                '->',
                                {
                                    xtype: 'button',
                                    text: 'Imprimir',
                                    iconCls: 'btnImprimir',
                                    id: 'btnProntItemGridPlantillaProcedaaa',
                                    listeners: {
                                        click: function(){
                                            if(Ext.getCmp('gridSolicitudesNOPOSxPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridSolicitudesNOPOSxPaciente').selModel.getSelections();
                                                window.open ("../../controlador/nopos/printnopos.php?pPaciente=" + selections[0].json.Paciente + "&pSolicitud=" + selections[0].json.idConsecutivoSolicitud,"SOLICITUD");
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        }
                    },
                    {
                        xtype: 'grid',
                        id: 'gridSolicitudesNOPOSxPaciente',
                        region: 'west',
                        frame: true,
                        loadMask: true,
                        flex: 1,
                        width: 340,
                        height: 315,
                        store: 'StoreGridSolicitudNOPOS',
                        tbar:{
                            xtype: 'toolbar',
                            items: [
                                {
                                    xtype: 'button',
                                    text: 'Adicionar',
                                    iconCls: 'btnAddRow',
                                    id: 'btnAddMxNOPOSItem',
                                    listeners: {
                                        click: function(){
                                            var winSolNOPOS001 = new winSolNOPOS001Ui();
                                            Ext.getCmp('intPrestadorNOPOS').setValue(ID_EMPRESA);
                                            Ext.getCmp('intIPSNOPOS').setValue(ID_IPS);
                                            Ext.getCmp('intCASNOPOS').setValue(Ext.getCmp('sysCASHC').getValue());
                                            Ext.getCmp('intProfesionalNOPOS').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                            Ext.getCmp('intUsuarioNOPOS').setValue(ID_USUARIO);
                                            Ext.getCmp('intPacienteNOPOS').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                            Ext.getCmp('fecFechaSolicitudNOPOS').setValue(Ext.getCmp('sysFechaHC').getValue());
                                            Ext.getCmp('sysPacienteNOPOS').setValue(Ext.getCmp('sysPacienteHC').getValue());
                                            Ext.getCmp('intClienteNOPOS').setValue(Ext.getCmp('sysIdClienteHC').getValue());
                                            Ext.getCmp('btnBuscarPacienteNOPOS').setDisabled(true); 
                                            Ext.getCmp('btnLimpiarPacienteNOPOS').setDisabled(true); 
                                            Ext.getCmp('intClienteNOPOS').setReadOnly(true);
                                            winSolNOPOS001.show();
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Duplicar',
                                    iconCls: 'btnAsociarConceptoMT',
                                    id: 'btnDuplicarMxNOPOSItem',
                                    listeners: {
                                        click: function(){
                                            if(Ext.getCmp('gridSolicitudesNOPOSxPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridSolicitudesNOPOSxPaciente').selModel.getSelections();
                                                Ext.Msg.show({
                                                    title: 'Servicios NO POS',
                                                    msg: 'Esta Seguro que Desea Duplicar el Registro ' + selections[0].json.Descripcion + '?',
                                                    buttons: Ext.Msg.YESNO,
                                                    icon: Ext.Msg.QUESTION,
                                                    fn: function(btn){
                                                        if(btn === "yes"){
                                                            Ext.Ajax.request({
                                                                waitMsg: 'Por favor Espere...',
                                                                url: '../../controlador/nopos/controlador_nopos.php',
                                                                params:{
                                                                    task: 'DUPLICAR_NOPOS',
                                                                    pEmpresa: selections[0].json.Empresa,
                                                                    pIPS: selections[0].json.IPS,
                                                                    pProfesional: selections[0].json.Profesional,
                                                                    pUsuario: ID_USUARIO,
                                                                    pPaciente: selections[0].json.Paciente,
                                                                    pSolicitud: selections[0].json.idConsecutivoSolicitud
                                                                },
                                                                success: function(response){
                                                                    var result=eval(response.responseText);
                                                                    Ext.MessageBox.show({
                                                                        title: 'OfiClinic',
                                                                        msg: 'Se duplico el registro con exito',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.INFO
                                                                    });
                                                                    Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.reload();
                                                                },
                                                                failure: function(response){
                                                                    var result = response.responseText;
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error Base Datos',
                                                                        msg: 'No podemos duplicar los registros en estos momentos',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            });
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Modificar',
                                    iconCls: 'btnEditRow',
                                    id: 'btnEditMxNOPOSItem',
                                    listeners: {
                                        click: function(){
                                            if(Ext.getCmp('gridSolicitudesNOPOSxPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridSolicitudesNOPOSxPaciente').selModel.getSelections();
                                                var winSolNOPOS001 = new winSolNOPOS001Ui();
                                                Ext.getCmp('sysIdSolicitudNOPOS').setValue(selections[0].json.idConsecutivoSolicitud);
                                                Ext.getCmp('sysYaGuardoNOPOS').setValue(1);
                                                Ext.getCmp('intPrestadorNOPOS').setValue(selections[0].json.Empresa);
                                                Ext.getCmp('intIPSNOPOS').setValue(selections[0].json.IPS);
                                                Ext.getCmp('intCASNOPOS').setValue(selections[0].json.CAS);
                                                Ext.getCmp('intProfesionalNOPOS').setValue(selections[0].json.Profesional);
                                                Ext.getCmp('intUsuarioNOPOS').setValue(ID_USUARIO);
                                                Ext.getCmp('intPacienteNOPOS').setValue(selections[0].json.Paciente);
                                                Ext.getCmp('sysPacienteNOPOS').setValue(Ext.getCmp('sysPacienteHC').getValue());
                                                Ext.getCmp('intClienteNOPOS').setValue(selections[0].json.Cliente);
                                                Ext.getCmp('strAmbitoNOPOS').setValue(selections[0].json.Ambito);
                                                Ext.getCmp('strDescripcionNOPOS').setValue(selections[0].json.Descripcion);
                                                Ext.getCmp('fecFechaSolicitudNOPOS').setValue(selections[0].json.FecSolicitud);
                                                Ext.getCmp('memResumenDXNOPOS').setValue(selections[0].json.ResumenDx);
                                                Ext.getCmp('strDiagnosticoNOPOS').setValue(selections[0].json.CodDiagnostico);
                                                Ext.getCmp('memCasoClinicoNOPOS').setValue(selections[0].json.DescripcionCasoClinico);
                                                Ext.getCmp('memTratamientosRealizadosNOPOS').setValue(selections[0].json.TratamientosRealizados);
                                                Ext.getCmp('memAyudasDxNOPOS').setValue(selections[0].json.AyudasDiagnosticas);
                                                Ext.getCmp('memOtrosNOPOS').setValue(selections[0].json.Otros);
                                                Ext.getCmp('btnBuscarPacienteNOPOS').setDisabled(true); 
                                                Ext.getCmp('btnLimpiarPacienteNOPOS').setDisabled(true); 
                                                Ext.getCmp('intClienteNOPOS').setReadOnly(true);
                                                winSolNOPOS001.show();
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Eliminar',
                                    iconCls: 'btnDelRow',
                                    id: 'btnDelMxNOPOSItem',
                                    listeners: {
                                       click: function(){
                                           if(Ext.getCmp('gridSolicitudesNOPOSxPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridSolicitudesNOPOSxPaciente').selModel.getSelections();
                                                Ext.Msg.show({
                                                    title: 'Servicios NO POS',
                                                    msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.Descripcion + '?',
                                                    buttons: Ext.Msg.YESNO,
                                                    icon: Ext.Msg.QUESTION,
                                                    fn: function(btn){
                                                        if(btn === "yes"){
                                                            fnEliminarRegistrosSolNOPOS("../../controlador/nopos/controlador_nopos.php",{task: "ELIMINAR_NOPOS", pIdServicioNOPOS: selections[0].json.idConsecutivoSolicitud}, 'gridSolicitudesNOPOSxPaciente');
                                                        }
                                                    }
                                                });
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                       }
                                    }
                                }
                            ]
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        listeners:{
                            rowclick : function(grid, fila, e){
                                var selections = grid.selModel.getSelections();
                                var updater = Ext.getCmp('DetalleNOPOSxPaciente').getUpdater();
                                url:'../../../app/controlador/nopos/viewsolicitudnopos001.php?pPaciente=' + wPaciente + '&pSolicitud=0',
                                updater.setDefaultUrl('../../../app/controlador/nopos/viewsolicitudnopos001.php?pPaciente=' + wPaciente + '&pSolicitud=' + selections[0].json.idConsecutivoSolicitud);
                                updater.refresh();
                            }
                        },
                        columns: [
                            {
                                header: 'Solicitud',
                                readOnly: true,
                                sortable: true,
                                dataIndex: 'Descripcion',
                                renderer: renderSolicitudNOPOS,
                                width: 270
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        columnLines: true
                    }
                ]
            }
        ];
        SolNOPOS001Ui.superclass.initComponent.call(this);
    }
});

function fnEliminarRegistrosNOPOS(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnEliminarRegistrosSolNOPOS(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}