/*
* @category    Formulario Adicionar Medicamentos - NO POS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolMxIPS003Ui = Ext.extend(Ext.Window, {
    title: '.:: Medicamentos ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolMx003Ui',
    initComponent: function() {
        var selMx = "0";
        var stPosologia = new StorePosologiaConceptosOfimedical();
               
        var searchStoreMx = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_solmx.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ])
        });

        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddMedicamentos',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'strTipoMx',
                                value: "M",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoHCMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreMx,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del Medicamento -- p.e: ACETA',
                                id: 'sysSearchMx',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    Ext.getCmp('intConceptoOfiMedicalMx').setValue(null);
                                    Ext.getCmp('strNomConceptoOfiMedicalMx').setValue(null);
                                    Ext.getCmp('intConceptoOfiMedicalMx').setValue(record.data.Codigo);
                                    Ext.getCmp('strNomConceptoOfiMedicalMx').setValue(record.data.Descripcion);
                                    Ext.getCmp('sysSearchMx').clearValue();
                                    Ext.getCmp('sysSearchMx').collapse();
                                    stPosologia.removeAll();
                                    stPosologia.load({
                                        params: {
                                            task: 'BUSCAR_POSOLOGIA_OFICLINIC',
                                            pConceptoOfimedical: Ext.getCmp('intConceptoOfiMedicalMx').getValue()
                                        }
                                    });
                                    Ext.getCmp('strPosologiaMx').setValue(null);
                                    Ext.getCmp('intCantidadMx').setValue(null);
                                }
                            },
                            {
                                html: '<hr>'
                            },        
                            {
                                xtype: 'hidden',
                                id: 'intConceptoOfiMedicalMx'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Medicamento',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: false,
                                id: 'strNomConceptoOfiMedicalMx'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                id: 'intCantidadMx',
                                width: 80,
                                allowBlank: false,
                                minValue: 1,
                                maxValue: 360,
                                value: 1
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Posología',
                                anchor: '100%',
                                allowBlank: false,
                                store: stPosologia,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: false,
                                id: 'strPosologiaMx'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemMxIPS002("GUARDAR_SOLMX","SI","winSolMxIPS003Ui","frmAddMedicamentos","../../controlador/asistencial/controlador_observahospitaliza.php","gridMedicamentosHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winSolMxIPS003Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemMxIPS002(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.load({
                                    params:{
                                        pCAS: Ext.getCmp('intCASMx').getValue(),
                                        pConsecutivoHC: Ext.getCmp('intConsecutivoHCMx').getValue(),
                                        pEmpresa: Ext.getCmp('intPrestadorMx').getValue(),
                                        pIPS: Ext.getCmp('intIPSMx').getValue(),
                                        pPaciente: Ext.getCmp('intPacienteMx').getValue(),
                                        task: "VerMxSolicitadosxHC"
                                    }
                                });
                            }
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
