/*
* @category    Formulario Adicionar Medicamentos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolMx002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiMedical .:: Medicamentos ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolMx002Ui',
    initComponent: function() {
        var selMx = "0";
        var stConceptosOfimedical = new StoreConceptosOfimedical();
        stConceptosOfimedical.load({
            params: {
                pTipo: "M"
            }
        });
        var stPosologia = new StorePosologiaConceptosOfimedical();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddMedicamentos',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'strTipoMx',
                                value: "M",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Descripción',
                                anchor: '100%',
                                allowBlank: false,
                                store: stConceptosOfimedical,
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: false,
                                id: 'strConceptoOfiMedicalMx',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        //alert("Selecciono " + cmb.getValue());
                                        stPosologia.load({
                                            params: {
                                                pConceptoOfimedical: cmb.getValue()
                                            }
                                        });
                                        Ext.getCmp('strPosologiaMx').setValue(null);
                                        Ext.getCmp('intCantidadMx').setValue(null);
                                        selMx = "1";
                                    },
                                    change : function(f,pNew, pOld){
                                        if(selMx == "0"){
                                            stPosologia.load({
                                                params: {
                                                    pConceptoOfimedical: pNew
                                                }
                                            });
                                            Ext.getCmp('strPosologiaMx').setValue(null);
                                            Ext.getCmp('intCantidadMx').setValue(null);
                                        }
                                           
                                    }
                                }
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                id: 'intCantidadMx',
                                width: 80,
                                allowBlank: false,
                                minValue: 1,
                                maxValue: 360,
                                value: 1
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Posología',
                                anchor: '100%',
                                allowBlank: false,
                                store: stPosologia,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: false,
                                id: 'strPosologiaMx'
                            },
                            {
                                xtype: 'hidden',
                                id: 'strSelectConceptoMx',
                                allowBlank: true
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    /*Ext.Msg.show({
                                        title: 'Guardar Medicamento',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                fnGuardarRegItemMx("GUARDAR_OFIMEDICAL","SI","winSolMx002Ui","frmAddMedicamentos","../../controlador/solmx/controlador_solmx.php","gridMedicamentosHC");
                                            }
                                        }
                                    });*/
                                    fnGuardarRegItemMx("GUARDAR_OFIMEDICAL","SI","winSolMx002Ui","frmAddMedicamentos","../../controlador/solmx/controlador_solmx.php","gridMedicamentosHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winSolMx002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemMx(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        Ext.getCmp('strSelectConceptoMx').setValue(parseInt(Ext.getCmp('strConceptoOfiMedicalMx').getValue()));
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        /*Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });*/
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
