/*
* @category    Solicitud Medicamentos Salud Ocupacional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

SolMx003SOUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {

        this.items = [
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridMedicamentosHC',
                store: 'StoreGridMxSolicitadosHC',
                anchor: "100%",
                height: 335,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'idConsecutivoSolicitud',
                        id: 'idConsecutivoSolicitud'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 450,
                        dataIndex: 'descConcepto',
                        id: 'descConcepto'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cantidad',
                        sortable: false,
                        width: 80,
                        dataIndex: 'Cantidad',
                        id: 'Cantidad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Posologia',
                        sortable: false,
                        width: 330,
                        dataIndex: 'Posologia',
                        id: 'Posologia'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView(),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Medicamento',
                                iconCls: 'btnAddRow',
                                id: 'btnAddMxEvolucion',
                                listeners: {
                                    click : function() {
                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                            if (objMXADD != "NA"){
                                                var xSolMXADD = eval(objMXADD);
                                                Ext.getCmp('intPrestadorMx').setValue(ID_EMPRESA);
                                                Ext.getCmp('intIPSMx').setValue(ID_SEDE);
                                                Ext.getCmp('intPacienteMx').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                Ext.getCmp('intCASMx').setValue(Ext.getCmp('sysCASHC').getValue());
                                                Ext.getCmp('intProfesionalMx').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                Ext.getCmp('intUsuarioMx').setValue(ID_USUARIO);
                                                xSolMXADD.show();
                                            }
                                        }else{
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Usted No ha Guardado la Evolución',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Medicamento',
                                iconCls: 'btnDelRow',
                                id: 'btnDelMxEvolucion',
                                listeners: {
                                    click : function() {
                                         if(Ext.getCmp('gridMedicamentosHC').selModel.getCount() == 1)
                                        {
                                            var selections = Ext.getCmp('gridMedicamentosHC').selModel.getSelections();
                                            Ext.Msg.show({
                                                title: 'Medicamentos',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descConcepto + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn)
                                                {
                                                    if(btn=="yes")
                                                    {
                                                        fnEliminarRegistros("../../controlador/solmx/controlador_solmx.php",{task: "ELIMINAR_OFIMEDICAL", pIdMx: selections[0].json.idConsecutivoSolicitud}, 'gridMedicamentosHC')
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->',
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir Formula',
                                iconCls: 'btnImprimir',
                                id: 'btnPrintMxEvolucionAll',
                                listeners: {
                                    click : function() {
                                        window.open ("../../controlador/asistencial/printformula0so.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue(),"Formula Medica");
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir Medicamentos Seleccionados',
                                iconCls: 'btnImprimir',
                                id: 'btnPrintMxSeleccion',
                                listeners: {
                                    click : function() {
                                        var Registros;
                                        Registros = Ext.getCmp('gridMedicamentosHC').selModel.getCount();
                                        if(Registros > 0){
                                            var selections = Ext.getCmp('gridMedicamentosHC').selModel.getSelections();
                                            var prez = [];
                                            for(i = 0; i < Registros; i++){
                                                prez.push(selections[i].json.idConsecutivoSolicitud);
                                            }
                                            var encoded_array = Ext.encode(prez);
                                            window.open ("../../controlador/asistencial/printformula0_1so.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() +  "&pItems=" + encoded_array,"Formula Medica");
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Debe seleccionar los medicamentos a imprimir',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        SolMx003SOUi.superclass.initComponent.call(this);
    }
});
