/*
* @category    Formulario Adicionar Examenes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolExaIPS001Ui = Ext.extend(Ext.Window, {
    title: '.:: Examenes / Procedimientos ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolExa002Ui',
    initComponent: function() {
        
        //var stConceptosGrupos = new StoreGrupoConceptosOfimedical();
        //stConceptosGrupos.load();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddExamenes',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysYaGuardoExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysClienteExa',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPlanExa',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysSubPlanExa',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strTipoExa',
                                value: "E",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoHCExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreExaIPS001,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del servicio -- p.e: COLESTEROL',
                                id: 'sysSearchExa',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    Ext.getCmp('intConceptoOfiMedicalExa').setValue(null);
                                    Ext.getCmp('strNomConceptoOfiMedicalExa').setValue(null);
                                    Ext.getCmp('intConceptoOfiMedicalExa').setValue(record.data.Codigo);
                                    Ext.getCmp('strNomConceptoOfiMedicalExa').setValue(record.data.Descripcion);
                                    Ext.getCmp('strGrupoConceptoOfiMedicalExa').setValue(record.data.TipoEstudio);
                                    Ext.getCmp('intTrifaOfiMedicalExa').setValue(record.data.Tarifa);
                                    Ext.getCmp('sysSearchExa').clearValue();
                                    Ext.getCmp('sysSearchExa').collapse();
                                }
                            },
                            {
                                html: '<hr>'
                            },        
                            {
                                xtype: 'hidden',
                                id: 'intConceptoOfiMedicalExa'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intTrifaOfiMedicalExa'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Concepto',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: false,
                                id: 'strNomConceptoOfiMedicalExa'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Grupo',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                id: 'strGrupoConceptoOfiMedicalExa'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                id: 'intCantidadExa',
                                width: 80,
                                allowBlank: false,
                                minValue: 1,
                                maxValue: 360,
                                value: 1
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Notas a Proveedor',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'memNotasExa'
                            },
                            {
                                xtype: 'hidden',
                                id: 'strFechaExa',
                                allowBlank: true
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    if(parseInt(Ext.getCmp('sysYaGuardoExa').getValue())===0){
                                        Ext.getCmp('sysYaGuardoExa').setValue(1);
                                        fnGuardarRegItemExaIPS001("GUARDAR_SOLEXA_OFICLINIC001","SI","winSolExaIPS002Ui","frmAddExamenes","../../controlador/solexa/controlador_solexa.php","gridExamenesHC");
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winSolExaIPS001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemExaIPS001(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.load({
                                    params:{
                                        pCAS: Ext.getCmp('intCASExa').getValue(),
                                        pConsecutivoHC: Ext.getCmp('intConsecutivoHCExa').getValue(),
                                        pEmpresa: Ext.getCmp('intPrestadorExa').getValue(),
                                        pIPS: Ext.getCmp('intIPSExa').getValue(),
                                        pPaciente: Ext.getCmp('intPacienteExa').getValue(),
                                        task: "VerExaSolicitadosxHC"
                                    }
                                });
                            }
                        }
                        Ext.getCmp('sysYaGuardoExa').setValue(0);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        Ext.getCmp('sysYaGuardoExa').setValue(0);
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
                Ext.getCmp('sysYaGuardoExa').setValue(0);
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
