/*
* @category    Solicitud Medicamentos IPS 002
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

SolExaIPS002Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        this.items = [
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridExamenesHC',
                store: 'StoreGridExaSolicitadosObservaHospitalizaHC',
                anchor: "100%",
                height: 335,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'idConsecutivoSolicitud',
                        id: 'idConsecutivoSolicitud'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 450,
                        dataIndex: 'descConcepto',
                        id: 'descConcepto'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cantidad',
                        sortable: false,
                        width: 80,
                        dataIndex: 'Cantidad',
                        id: 'Cantidad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Notas a Proveedor',
                        sortable: false,
                        width: 330,
                        dataIndex: 'notasProveedor',
                        id: 'notasProveedor'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView(),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Examen',
                                iconCls: 'btnAddRow',
                                id: 'btnAddExaEvolucion',
                                listeners: {
                                    click : function() {
                                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                            if (objEXAADD !== "NA"){
                                                var xSolEXAADD = eval(objEXAADD);
                                                Ext.getCmp('intPrestadorExa').setValue(ID_EMPRESA);
                                                Ext.getCmp('intIPSExa').setValue(ID_SEDE);
                                                Ext.getCmp('intPacienteExa').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                Ext.getCmp('intCASExa').setValue(Ext.getCmp('sysCASHC').getValue());
                                                Ext.getCmp('intConsecutivoHCExa').setValue(Ext.getCmp('sysConsecutivoDetalleHC').getValue());
                                                Ext.getCmp('intProfesionalExa').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                Ext.getCmp('intUsuarioExa').setValue(ID_USUARIO);
                                                Ext.getCmp('sysClienteExa').setValue(Ext.getCmp('sysIdClienteHC').getValue());
                                                Ext.getCmp('sysPlanExa').setValue(Ext.getCmp('sysIdPlanHC').getValue());
                                                Ext.getCmp('sysSubPlanExa').setValue(Ext.getCmp('sysIdSubPlanHC').getValue());
                                                Ext.getCmp('strFechaExa').setValue(Ext.getCmp('sysFechaHC').getValue());
                                                
                                                searchStoreExa.setBaseParam('pCliente', Ext.getCmp('sysIdClienteHC').getValue());
                                                searchStoreExa.setBaseParam('pPlan', Ext.getCmp('sysIdPlanHC').getValue());
                                                searchStoreExa.setBaseParam('pSubPlan', Ext.getCmp('sysIdSubPlanHC').getValue());
                                                xSolEXAADD.show();
                                            }
                                        }else{
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Usted No ha Guardado la Evolución',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Examen',
                                iconCls: 'btnDelRow',
                                id: 'btnDelExaEvolucion',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridExamenesHC').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridExamenesHC').selModel.getSelections();
                                            Ext.Msg.show({
                                                title: 'Medicamentos',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descConcepto + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        fnEliminarRegistrosExaIPS002("../../controlador/asistencial/controlador_observahospitaliza.php",{task: "ELIMINAR_SOLMX", pIdMx: selections[0].json.idConsecutivoSolicitud}, 'gridExamenesHC');
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->',
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir Orden',
                                iconCls: 'btnImprimir',
                                id: 'btnPrintExaEvolucionAll',
                                listeners: {
                                    click : function() {
                                        window.open ("../../controlador/asistencial/printordenexa0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue(),"Ordenamientos");
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir Examenes Seleccionados',
                                iconCls: 'btnImprimir',
                                id: 'btnPrintExaSeleccion',
                                listeners: {
                                    click : function() {
                                        var Registros;
                                        Registros = Ext.getCmp('gridExamenesHC').selModel.getCount();
                                        if(Registros > 0){
                                            var selections = Ext.getCmp('gridExamenesHC').selModel.getSelections();
                                            var prez = [];
                                            for(i = 0; i < Registros; i++){
                                                prez.push(selections[i].json.idConsecutivoSolicitud);
                                            }
                                            var encoded_array = Ext.encode(prez);
                                            window.open ("../../controlador/asistencial/printordenexa0_1.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() +  "&pItems=" + encoded_array,"Formula Medica");
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Debe seleccionar los Examenes a imprimir',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        SolExaIPS002Ui.superclass.initComponent.call(this);
    }
});

function fnEliminarRegistrosExaIPS002(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}