/*
* @category    Formulario Adicionar Examenes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolMedicare201802Ui = Ext.extend(Ext.Window, {
    title: '.:: Examenes / Procedimientos IPS ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolExaMedicare1801Ui',
    initComponent: function() {
        
        // Template para Combo de Servicio
        var TemplateComboExaIPS = '<tpl for=".">';
        TemplateComboExaIPS += '<tpl if="UsaAuditoria==\'1\'">';
        TemplateComboExaIPS += '<tpl if="TipoAutoriza==\'A\'">';
        TemplateComboExaIPS += '<div class="cbSearchExa">';
        TemplateComboExaIPS += '<table border="0" width="720"><tr><td style="background-color:#F2F5A9;">';
        TemplateComboExaIPS += '<span style="background-color:#F2F5A9; font-size:14px">{Descripcion}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#F2F5A9; font-size:13px">Grupo: {TipoEstudio}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#F2F5A9; font-size:13px"><b><u>REQUIERE AUDITORIA MEDICA</u></b></span><br><br>';
        TemplateComboExaIPS += '<span style="background-color:#F2F5A9; font-size:13px; text-align:right;">Vlr Unitario: <b>$ {infoTarifa}</b></span><hr>';
        TemplateComboExaIPS += '</td></tr></table>';
        TemplateComboExaIPS += '</div>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '<tpl if="UsaAuditoria==\'1\'">';
        TemplateComboExaIPS += '<tpl if="TipoAutoriza==\'S\'">';
        TemplateComboExaIPS += '<div class="cbSearchExa">';
        TemplateComboExaIPS += '<table border="0" width="720"><tr><td style="background-color:#F5A9A9;">';
        TemplateComboExaIPS += '<span style="background-color:#F5A9A9; font-size:14px">{Descripcion}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#F5A9A9; font-size:13px">Grupo: {TipoEstudio}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#F5A9A9; font-size:13px"><b><u>DEBE SER AUTORIZADO EN LA EPS</u></b></span><br><br>';
        TemplateComboExaIPS += '<span style="background-color:#F5A9A9; font-size:13px; text-align:right;">Vlr Unitario: <b>$ {infoTarifa}</b></span><hr>';
        TemplateComboExaIPS += '</td></tr></table>';
        TemplateComboExaIPS += '</div>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '<tpl if="UsaAuditoria==\'1\'">';
        TemplateComboExaIPS += '<tpl if="TipoAutoriza==\'P\'">';
        TemplateComboExaIPS += '<div class="cbSearchExa">';
        TemplateComboExaIPS += '<table border="0" width="720"><tr><td style="background-color:#A9F5A9;">';
        TemplateComboExaIPS += '<span style="background-color:#A9F5A9; font-size:14px">{Descripcion}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#A9F5A9; font-size:13px">Grupo: {TipoEstudio}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#A9F5A9; font-size:13px"><b><u>SERVICIO AUTORIZADO</u></b></span><br><br>';
        TemplateComboExaIPS += '<span style="background-color:#A9F5A9; font-size:13px; text-align:right;">Vlr Unitario: <b>$ {infoTarifa}</b></span><hr>';
        TemplateComboExaIPS += '</td></tr></table>';
        TemplateComboExaIPS += '</div>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '<tpl if="UsaAuditoria==\'0\'">';
        TemplateComboExaIPS += '<tpl if="TipoAutoriza==\'S\'">';
        TemplateComboExaIPS += '<div class="cbSearchExa">';
        TemplateComboExaIPS += '<table border="0" width="720"><tr><td style="background-color:#F5A9A9;">';
        TemplateComboExaIPS += '<span style="background-color:#F5A9A9; font-size:14px">{Descripcion}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#F5A9A9; font-size:13px">Grupo: {TipoEstudio}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#F5A9A9; font-size:13px"><b><u>DEBE SER AUTORIZADO EN LA EPS</u></b></span><br><br>';
        TemplateComboExaIPS += '<span style="background-color:#F5A9A9; font-size:13px; text-align:right;">Vlr Unitario: <b>$ {infoTarifa}</b></span><hr>';
        TemplateComboExaIPS += '</td></tr></table>';
        TemplateComboExaIPS += '</div>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '<tpl if="UsaAuditoria==\'0\'">';
        TemplateComboExaIPS += '<tpl if="TipoAutoriza==\'P\'">';
        TemplateComboExaIPS += '<div class="cbSearchExa">';
        TemplateComboExaIPS += '<table border="0" width="720"><tr><td style="background-color:#A9F5A9;">';
        TemplateComboExaIPS += '<span style="background-color:#A9F5A9; font-size:14px">{Descripcion}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#A9F5A9; font-size:13px">Grupo: {TipoEstudio}</span><br>';
        TemplateComboExaIPS += '<span style="background-color:#A9F5A9; font-size:13px"><b><u>SERVICIO AUTORIZADO</u></b></span><br><br>';
        TemplateComboExaIPS += '<span style="background-color:#A9F5A9; font-size:13px; text-align:right;">Vlr Unitario: <b>$ {infoTarifa}</b></span><hr>';
        TemplateComboExaIPS += '</td></tr></table>';
        TemplateComboExaIPS += '</div>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '</tpl>';
        TemplateComboExaIPS += '</tpl>';
        
        function getIcon(value, p, record){
            var pEjecutado = parseFloat(record.data.Ejecutado);
            if(pEjecutado <= 80){
                pImg = '<img src="../../../resources/varios/caraverde.png" height="28" width="28">';
            }else if(pEjecutado <= 95){
                pImg = '<img src="../../../resources/varios/carayelow.png" height="28" width="28"">';
            }else if(pEjecutado <= 100){
                pImg = '<img src="../../../resources/varios/cararojo.png" height="28" width="28">';
            }else{
                pImg = '<img src="../../../resources/varios/caraalerta.png" height="28" width="28">';
            }
            return String.format('<table border="0"><tr><td style="background-color: white;">{0}</td></tr></table>', pImg);
        }
        
        DGDataStoreSOLEXA = new Ext.data.Store({
            id: 'DGDataStoreSOLEXA',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/medicare/gridauditoria_solexa.php',
                method: 'POST'
            }),
            loadMask: {msg:"Cargando Registros, por favor espere..."},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
              },[
                {name: 'Grupo'},
                {name: 'MaximoHoy'},
                {name: 'Solicitados'},
                {name: 'DisponibleHoy'},
                {name: 'Ejecutado'},
                {name: 'MaximoProyectado'},
                {name: 'DisponibleProyectado'},
                {name: 'EjecucionProyectado'}
             ])
        });

        DGColumnModelSOLEXA = new Ext.grid.ColumnModel(
            [
                {
                    header: '-',
                    dataIndex: 'Grupo',
                    sortable: false,
                    renderer: getIcon,
                    width: 45
                },
                {
                    header: 'Grupo',
                    dataIndex: 'Grupo',
                    sortable: false,
                    style: 'text-align:center;',
                    width: 150
                },
                {
                    header: 'Max Hoy',
                    dataIndex: 'MaximoHoy',
                    sortable: false,
                    align: 'center',
                    width: 80
                },
                {
                    header: 'Solicitados',
                    dataIndex: 'Solicitados',
                    sortable: false,
                    align: 'center',
                    width: 80
                },
                {
                    header: 'Disp Hoy',
                    dataIndex: 'DisponibleHoy',
                    sortable: false,
                    align: 'center',
                    width: 80
                },
                {
                    header: '% Ejecutado',
                    dataIndex: 'Ejecutado',
                    sortable: false,
                    align: 'center',
                    width: 90
                },
                {
                    header: 'Max Proyec.',
                    dataIndex: 'MaximoProyectado',
                    sortable: false,
                    align: 'center',
                    width: 100
                },
                {
                    header: 'Disp Proyec.',
                    dataIndex: 'DisponibleProyectado',
                    sortable: false,
                    align: 'center',
                    width: 100
                },
                {
                    header: '% Ejec. Proyec.',
                    dataIndex: 'EjecucionProyectado',
                    sortable: false,
                    align: 'center',
                    width: 95
                }
            ]
        );
        
        DGListingEditorGridSOLEXA =  new Ext.grid.GridPanel({
            id: 'DGListingEditorGridSOLEXA',
            title: '<span style="color: darkblue;"><b>COMO VAMOS....!</b></span>',
            anchor: '100%',
            height: 172,
            border: true,
            store: DGDataStoreSOLEXA,
            cm: DGColumnModelSOLEXA,
            selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
            iconCls:'icon-grid',
            loadMask:{msg:"Cargando Registros, por favor espere..."},
            viewConfig: {
                forceFit:true, 
                getRowClass: function(record, index) {
                    var pEjecutado = parseFloat(record.get('Ejecutado'));
                    var pEjecutadoG = parseFloat(record.get('EjecucionProyectado'));
                    if(pEjecutado <= 80){
                        return 'Apto';
                    }else if(pEjecutado <= 95){
                        return 'Amarillo';
                    }else if(pEjecutado <= 100){
                        return 'Rojo';
                    }else{
                        return 'Alerta';
                    }
                }
            }
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddExamenes',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysClienteExa',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPlanExa',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysSubPlanExa',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strTipoExa',
                                value: "E",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoHCExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysNotificaCorreoExa',
                                value: "NO",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysDocPacienteExa',
                                value: "",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysNomPacienteExa',
                                value: "",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysNomClienteExa',
                                value: "",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysNomProfeExa',
                                value: "",
                                allowBlank: true
                            },
                            DGListingEditorGridSOLEXA,
                            {
                                html: '<br>'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreExaMedicare2018,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del servicio -- p.e: COLESTEROL',
                                tpl: new Ext.XTemplate(TemplateComboExaIPS),
                                itemSelector: 'div.cbSearchExa',
                                name: 'cbSearchExa',
                                id: 'sysSearchExa',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    var frm = Ext.getCmp('frmAddExamenes').getForm();
                                    if(record.data.TipoEstudio === "LABORATORIO CLINICO"){
                                        //alert("Dias: " + record.data.DiasSolicitados);
                                        if(parseInt(record.data.DiasSolicitados) > 90){
                                            Ext.getCmp('intConceptoOfiMedicalExa').setValue(null);
                                            Ext.getCmp('strNomConceptoOfiMedicalExa').setValue(null);
                                            Ext.getCmp('intConceptoOfiMedicalExa').setValue(record.data.Codigo);
                                            Ext.getCmp('strNomConceptoOfiMedicalExa').setValue(record.data.Descripcion);
                                            Ext.getCmp('strGrupoConceptoOfiMedicalExa').setValue(record.data.TipoEstudio);
                                            Ext.getCmp('intTrifaOfiMedicalExa').setValue(record.data.Tarifa);
                                            Ext.getCmp('strAuditoria').setValue(record.data.TipoAutoriza);
                                            Ext.getCmp('sysNotificaCorreoExa').setValue(record.data.NotificaCorreo);
                                            switch(record.data.TipoAutoriza){
                                                case "A":
                                                    Ext.getCmp('sysObservaServicio').setValue('REQUIERE AUDITORIA MEDICA');
                                                    break;
                                                case "S":
                                                    Ext.getCmp('sysObservaServicio').setValue('DEBE SER AUTORIZADO EN LA EPS');
                                                    break;
                                                default:
                                                    Ext.getCmp('sysObservaServicio').setValue('SERVICIO AUTORIZAZO');
                                                    break;
                                            }
                                            Ext.getCmp('sysSearchExa').clearValue();
                                            Ext.getCmp('sysSearchExa').collapse();
                                            if(record.data.TipoAutoriza === "A"){
                                                fnActivarCamposJustificaExaIPS201802("SI");
                                            }else{
                                                fnActivarCamposJustificaExaIPS201802("NO");
                                            }
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'OfiClinic',
                                                msg: 'El Examen solicitado ya tiene un reporte resiente y/o una solicitud generada pendiente de toma de muestra por favor consultar el reporte o las solicitudes.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                            Ext.getCmp('intConceptoOfiMedicalExa').setValue(null);
                                            Ext.getCmp('strNomConceptoOfiMedicalExa').setValue(null);
                                            frm.reset();
                                        }
                                    }else{
                                        Ext.getCmp('intConceptoOfiMedicalExa').setValue(null);
                                        Ext.getCmp('strNomConceptoOfiMedicalExa').setValue(null);
                                        Ext.getCmp('intConceptoOfiMedicalExa').setValue(record.data.Codigo);
                                        Ext.getCmp('strNomConceptoOfiMedicalExa').setValue(record.data.Descripcion);
                                        Ext.getCmp('strGrupoConceptoOfiMedicalExa').setValue(record.data.TipoEstudio);
                                        Ext.getCmp('intTrifaOfiMedicalExa').setValue(record.data.Tarifa);
                                        Ext.getCmp('strAuditoria').setValue(record.data.TipoAutoriza);
                                        Ext.getCmp('sysNotificaCorreoExa').setValue(record.data.NotificaCorreo);
                                        switch(record.data.TipoAutoriza){
                                            case "A":
                                                Ext.getCmp('sysObservaServicio').setValue('REQUIERE AUDITORIA MEDICA');
                                                break;
                                            case "S":
                                                Ext.getCmp('sysObservaServicio').setValue('DEBE SER AUTORIZADO EN LA EPS');
                                                break;
                                            default:
                                                Ext.getCmp('sysObservaServicio').setValue('SERVICIO AUTORIZAZO');
                                                break;
                                        }
                                        Ext.getCmp('sysSearchExa').clearValue();
                                        Ext.getCmp('sysSearchExa').collapse();
                                        if(record.data.TipoAutoriza === "A"){
                                            fnActivarCamposJustificaExaIPS201802("SI");
                                        }else{
                                            fnActivarCamposJustificaExaIPS201802("NO");
                                        }
                                    }
                                }
                            },
                            {
                                html: '<hr>'
                            },        
                            {
                                xtype: 'hidden',
                                id: 'intConceptoOfiMedicalExa'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intTrifaOfiMedicalExa'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Concepto',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: false,
                                id: 'strNomConceptoOfiMedicalExa'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Grupo',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                id: 'strGrupoConceptoOfiMedicalExa'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'Cantidad',
                                        id: 'intCantidadExa',
                                        width: 80,
                                        allowBlank: false,
                                        minValue: 1,
                                        maxValue: 60,
                                        value: 1
                                    },
                                    {
                                        html: 'Realizar el examen en la la fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'fecFecSolicitudExa',
                                        allowBlank: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFecSolicitudExa'
                                    },
                                    {
                                        html: 'Observaciones:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        readOnly: true,
                                        allowBlank: true,
                                        style: {
                                            color: 'darkblue'
                                        },
                                        id: 'sysObservaServicio'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Notas a Proveedor',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'memNotasExa'
                            },
                            {
                                xtype: 'fieldset',
                                anchor: '100%',
                                layout: 'form',
                                title: 'Justificacion Solicitud del Servicio',
                                style: 'background:transparent;',
                                visible: false,
                                id: 'fsJustificacionServicio',
                                items: [
                                    {
                                        html: '<br>'
                                    },
                                    {
                                        xtype: 'textarea',
                                        fieldLabel: 'Justificacion',
                                        anchor: '100%',
                                        allowBlank: true,
                                        id: 'memJustificacionExa'
                                    }
                                ]
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'strAuditoria'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    Ext.getCmp('sysNomPacienteExa').setValue(Ext.getCmp('sysPacienteHC').getValue());
                                    Ext.getCmp('sysNomProfeExa').setValue(Ext.getCmp('sysProfesionalAgendaHC').getValue());
                                    fnGuardarRegItemExaIPS201802("GUARDAR_SOLEXA_OFICLINIC001","SI","winSolMedicare201802Ui","frmAddExamenes","../../controlador/asistencial/controlador_solexa_medicare2018.php","gridExamenesHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                Ext.getCmp('DGListingEditorGridSOLEXA').store.load({
                    params: {
                        pProfesional: Ext.getCmp('intProfesionalExa').getValue()
                    }
                });
            }}
        });
        winSolMedicare201802Ui.superclass.initComponent.call(this);
    }
});

function fnActivarCamposJustificaExaIPS201802(wActivar){
    if(wActivar === "NO"){
        Ext.getCmp('memJustificacionExa').allowBlank = true;
        Ext.getCmp('memJustificacionExa').clearInvalid();
        Ext.getCmp('fsJustificacionServicio').setVisible(false);
    }else{
        Ext.getCmp('memJustificacionExa').allowBlank = false;
        Ext.getCmp('memJustificacionExa').clearInvalid();
        Ext.getCmp('fsJustificacionServicio').setVisible(true);
    }
}

function fnGuardarRegItemExaIPS201802(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.load({
                                    params:{
                                        pCAS: Ext.getCmp('intCASExa').getValue(),
                                        pConsecutivoHC: Ext.getCmp('intConsecutivoHCExa').getValue(),
                                        pEmpresa: Ext.getCmp('intPrestadorExa').getValue(),
                                        pIPS: Ext.getCmp('intIPSExa').getValue(),
                                        pPaciente: Ext.getCmp('intPacienteExa').getValue(),
                                        task: "VerExaSolicitadosxHC"
                                    }
                                });
                                Ext.getCmp("gridReporteParaclinicos").store.reload();
                            }
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}