/*
* @category    Solicitud Matriz Examenes Ofimedical
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

MatrizExaOfiMedicalUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    height: 580,
    initComponent: function() {
        var el = Ext.get('idusuario');
        var ID_USUARIO = el.getValue();
        el = Ext.get('nomusuario');
        var NOM_USUARIO = el.getValue();
        el = Ext.get('codusuario');
        var COD_USUARIO = el.getValue();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        el = Ext.get('nomempresa');
        var NOM_EMPRESA = el.getValue();
        el = Ext.get('idcliente');
        var ID_CLIENTE = el.getValue();
        el = Ext.get('nomcliente');
        var NOM_CLIENTE = el.getValue();
        el = Ext.get('idsede');
        var ID_SEDE = el.getValue();
        el = Ext.get('nomsede');
        var NOM_SEDE = el.getValue();
        el = Ext.get('idperfil');
        var ID_PERFIL = el.getValue();
        
        var btnSalir = new Ext.Button({
            id: 'btnSalir',
            text: 'Salir',
            iconCls: 'btnSalir',
            minWidth: 80,
            handler:function(){
                DGListingWindow.close();
            }
        });
        
        DGDataStore = new Ext.data.GroupingStore({
            id: 'DGDataStore',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/conceptos/controlador_conceptos_ofimedical.php',
                method: 'POST'
            }),
            loadMask: {msg:"Cargando Registros, por favor espere..."},
            autoload: false,
            groupField: 'GrupoConcepto',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
              },[
                { name: 'CAS' },
                { name: 'PrefijoNroEstudio' },
                { name: 'SubNroEstudioINT' },
                { name: 'NroAutorizacion' },
                { name: 'FechaEstudio' },
                { name: 'ConsecutivoDetalle' },
                { name: 'CodProcedimiento' },
                { name: 'DescProcedimiento' },
                { name: 'YaCerrado' },
                { name: 'FechaCerrado' },
                { name: 'Paciente' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'FecNac' },
                { name: 'Genero' },
                { name: 'Direccion' },
                { name: 'Zona' },
                { name: 'Telefono' },
                { name: 'Telefono1' },
                { name: 'Email' },
                { name: 'NroServicio' },
                { name: 'NroCAS_Origen' },
                { name: 'Origen' },
                { name: 'Prestador' },
                { name: 'Sede' },
                { name: 'IPS' },
                { name: 'Consultorio' },
                { name: 'Cliente' },
                { name: 'Plan' },
                { name: 'Subplan' },
                { name: 'Contrato' },
                { name: 'Examen' },
                { name: 'Lote' },
                { name: 'FechaToma' },
                { name: 'ProfesionalSolicitante' },
                { name: 'TipoAfiliacion' },
                { name: 'TipoAfiliado' },
                { name: 'Parentesco' },
                { name: 'RangoSalarial' },
                { name: 'EstadoListado' },
                { name: 'EdadPaciente' },
                { name: 'DeptoMuniciPaciente' },
                { name: 'PorCopagos' },
                { name: 'VlrEstudios' },
                { name: 'VlrInsumos' },
                { name: 'VlrMedicamentos' },
                { name: 'VlrIVA' },
                { name: 'VlrICA' },
                { name: 'VlrCuotaModeradoraEstudios' },
                { name: 'VlrCopagosEstudios' },
                { name: 'VlrCopagosInsumos' },
                { name: 'VlrCopagosMedicamentos' },
                { name: 'VlrDescuentos' },
                { name: 'VlrNeto' },
                { name: 'VlrRetencion' },
                { name: 'MarcaExenta' },
                { name: 'YaLegalizado' },
                { name: 'FechaLegaliza' },
                { name: 'TipoLegalizacion' },
                { name: 'UsuarioLegaliza' },
                { name: 'YaEntregado' },
                { name: 'FechaEntregado' },
                { name: 'UsrEntregado' },
                { name: 'YaFacturadoEnt' },
                { name: 'Capitacion' },
                { name: 'CodEstadoReg' },
                { name: 'EstadoRegistro' },
                { name: 'Programa' },
                { name: 'Finalidad' },
                { name: 'TipoAtencion' },
                { name: 'FacturarParticular' },
                { name: 'FacturarCopagos' },
                { name: 'CopagoDigitado' },
                { name: 'vlrCuotaModeradoraIndicada' },
                { name: 'MaxCopago' },
                { name: 'Exento' },
                { name: 'Tutela' },
                { name: 'ResumenHC' },
                { name: 'DiagPpal' },
                { name: 'DiagRel1' },
                { name: 'DiagRel2' },
                { name: 'DiagRel3' },
                { name: 'nomCliente' },
                { name: 'nomPaciente' },
                { name: 'YaLiquidado' },
                { name: 'YaRealizado' }
             ])
        });

        DGDataStore.on('beforeload', function(store){
            store.baseParams = {
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS,
                pCAS: Ext.getCmp('searchpCAS').getValue(),
                pDocumento: Ext.getCmp('searchpDocumento').getValue(),
                pNom1: Ext.getCmp('searchpNom1').getValue(),
                pNom2: Ext.getCmp('searchpNom2').getValue(),
                pApe1: Ext.getCmp('searchpApe1').getValue(),
                pApe2: Ext.getCmp('searchpApe2').getValue(),
                pExamen: Ext.getCmp('searchpExamen').getValue()
            };
        });

        DGColumnModel = new Ext.grid.ColumnModel(
            [{
                header: 'CAS',
                dataIndex: 'CAS',
                width: 120,
                sortable: true,
                hideable: false
            },{
                header: 'Fecha',
                dataIndex: 'FechaEstudio',
                width: 120,
                sortable: true,
                hideable: false
            },{
                header: 'Nro Autorización',
                dataIndex: 'NroAutorizacion',
                sortable: true,
                width: 150
            },{ 
                header: 'Actividad Programada',
                dataIndex: 'DescProcedimiento',
                sortable: true,
                width: 250
            },{
                header: 'Prefijo',
                dataIndex: 'PrefijoNroEstudio',
                sortable: true,
                width: 40
            },{
                header: 'Examen',
                dataIndex: 'SubNroEstudioINT',
                sortable: true,
                width: 130
            },{
                header: 'Paciente',
                dataIndex: 'nomPaciente',
                sortable: false,
                width: 1,
                hidden: true,
                hideable: false
            }]
        );
        DGColumnModel.defaultSortable= true;
    
        this.items = [
        ];
        MatrizExaOfiMedicalUi.superclass.initComponent.call(this);
    }
});

function buscarestudios(wPantalla)
{
    var DGDataStore;
    var DGColumnModel;
    var DGListingEditorGrid;
    var DGListingWindow;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;

    
    var ID_ORIGEN = wPantalla;
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    

    

    doMsgBoxAlert = function(record) {
        switch(wPantalla)
        {
            case "CambiarFechaRadicacion":
                Ext.getCmp('fPacienteCambiarFechaRadica').setValue("CAS: " + record.get('CAS') + " Fecha: " + record.get('FechaEstudio') + " Pac: " + record.get('TipDoc') + '-' + record.get('Documento') + " " + record.get('PrimerNombre') + " "  + record.get('SegundoNombre') + " " + record.get('PrimerApellido') + " " + record.get('SegundoApellido'));
                Ext.getCmp('sysCASCambiarFechaRadica').setValue(record.get('CAS'));
                break;
            case "CambiarFechaAtencion":
                Ext.getCmp('fPacienteCambiarFechaAtencion').setValue("CAS: " + record.get('CAS') + " Fecha: " + record.get('FechaEstudio') + " Pac: " + record.get('TipDoc') + '-' + record.get('Documento') + " " + record.get('PrimerNombre') + " "  + record.get('SegundoNombre') + " " + record.get('PrimerApellido') + " " + record.get('SegundoApellido'));
                Ext.getCmp('sysCASCambiarFechaAtencion').setValue(record.get('CAS'));
                break;
            case "Radicacion":
                EstblecerCamposDisabled();
                var frm = Ext.getCmp('frmRadica').getForm();
                frm.reset();
                frm.clearInvalid();
                Ext.getCmp('fCliente').clearValue();
                Ext.getCmp('fPlan').clearValue();
                Ext.getCmp('fSubPlan').clearValue();
                Ext.getCmp('fContrato').clearValue();
                Ext.getCmp('fCliente').setValue(null);
                Ext.getCmp('fPlan').setValue(null);
                Ext.getCmp('fSubPlan').setValue(null);
                Ext.getCmp('fContrato').setValue(null);
                Ext.getCmp('fIdPaciente').setValue(0);
                frm = Ext.getCmp('frmResumenHC').getForm();
                frm.reset();
                frm.clearInvalid();
                frm = Ext.getCmp('frmLegalizar').getForm();
                frm.reset();
                frm.clearInvalid();
                Ext.getCmp('fIdPaciente').setValue(0);
                Ext.getCmp('gridServicios').store.load({
                    params: {
                        pCAS: 0
                    }
                });
                Ext.getCmp('gridFacturacionOrden').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA,
                        pCAS: 0
                    }
                });
                Ext.getCmp('gridServicios').store.removeAll();
                Ext.getCmp('gridFacturacionOrden').store.removeAll();
                Ext.getCmp('fClienteLA').setValue(0);
                Ext.getCmp('fPlanLA').setValue(0);
                Ext.getCmp('fSubPlanLA').setValue(0);
                Ext.getCmp('fCliente').store.load({
                    params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}
                });
                Ext.getCmp('fPlan').disable();
                Ext.getCmp('fSubPlan').disable();
                Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                Ext.getCmp('fEstadoCAS').setValue("");
                Ext.getCmp('fFecRadicado').setValue("");
                Ext.getCmp('fPacienteValido').setValue(0);
                paso1 = false;
                paso2 = false;
                paso3 = false;
                paso4 = false;
                paso5 = false;
                Ext.getCmp('fYaLegalizado').setValue(0);
                Ext.getCmp('fYaLiquidado').setValue(0);
                Ext.getCmp('fCas').setValue(0);
                Ext.getCmp('fModificaCAS').setValue(1);
                Ext.getCmp('sysTipoLegalizacion_estudios').setValue("");
                Ext.getCmp('sysResponsableLegalizacion_estudios').setValue("");
                
                Ext.getCmp('fTdoc').setValue(record.get('TipDoc'));
                Ext.getCmp('fDocID').setValue(record.get('Documento'));
                Ext.getCmp('fGenero').setValue(record.get('Genero'));
                Ext.getCmp('fApe1').setValue(PonerAcentosMayusculas(record.get('PrimerApellido')));
                Ext.getCmp('fApe2').setValue(PonerAcentosMayusculas(record.get('SegundoApellido')));
                Ext.getCmp('fNom1').setValue(PonerAcentosMayusculas(record.get('PrimerNombre')));
                Ext.getCmp('fNom2').setValue(PonerAcentosMayusculas(record.get('SegundoNombre')));
                Ext.getCmp('fFecNac').setValue(record.get('FecNac'));
                Ext.getCmp('fDeptoMuni').setValue(record.get('DeptoMuniciPaciente'));
                Ext.getCmp('fDireccion').setValue(PonerAcentosMayusculas(record.get('Direccion')));
                Ext.getCmp('fTel1').setValue(PonerAcentosMayusculas(record.get('Telefono')));
                Ext.getCmp('fTel2').setValue(PonerAcentosMayusculas(record.get('Telefono1')));
                Ext.getCmp('fZona').setValue(record.get('Zona'));
                Ext.getCmp('fEmail').setValue(PonerAcentosMayusculas(record.get('Email')));
                Ext.getCmp('fTafiliado').setValue(record.get('TipoAfiliado')); 
                Ext.getCmp('fRegimen').setValue(record.get('TipoAfiliacion'));
                Ext.getCmp('fParentesco').setValue(record.get('Parentesco'));
                Ext.getCmp('fRango').setValue(record.get('RangoSalarial'));
                Ext.getCmp('fCliente').setValue(record.get('Cliente'));
                Ext.getCmp('fPlan').store.load({
                    params: { 'pCliente': record.get('Cliente') },
                    callback: function()
                    {
                        Ext.getCmp('fPlan').setValue(record.get('Plan'));
                    }
                });
                Ext.getCmp('fSubPlan').store.load({
                    params: { 'pPlan': record.get('Plan') },
                    callback: function(){
                        Ext.getCmp('fSubPlan').setValue(record.get('Subplan'));
                    }
                });
                Ext.getCmp('fContrato').store.load({
                    params: { 'pCliente': record.get('Cliente') },
                    callback: function()
                    {
                        Ext.getCmp('fContrato').setValue(record.get('Contrato'));
                    }
                });
                Ext.getCmp('fFecSol').setValue(record.get('FechaToma'));
                Ext.getCmp('fPrograma').setValue(record.get('Programa'));
                Ext.getCmp('fProfeSol').setValue(record.get('ProfesionalSolicitante'));
                if(Ext.getCmp('fFecNac').getValue() != null && Ext.getCmp('fFecNac').getValue() != "")
                    Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(record.get('FechaEstudio'),Ext.getCmp('fFecNac').getValue().format('Y/m/d')));
                Ext.getCmp('fEstado').setValue(record.get('EstadoListado'));
                Ext.getCmp('fIdEmpresa').setValue(record.get('Prestador'));
                Ext.getCmp('fIdSede').setValue(record.get('Sede'));
                Ext.getCmp('fIdIPS').setValue(record.get('IPS'));
                Ext.getCmp('fIdPaciente').setValue(record.get('Paciente'));
                Ext.getCmp('fExento').setValue(record.get('Exento'));
                Ext.getCmp('fTutela').setValue(record.get('Tutela'));
                Ext.getCmp('fClienteLA').setValue(record.get('Cliente'));
                Ext.getCmp('fPlanLA').setValue(record.get('Plan'));
                Ext.getCmp('fSubPlanLA').setValue(record.get('Subplan'));
                Ext.getCmp('fPacienteValido').setValue(1);
                //Ext.getCmp('fUsaListado').setValue(record.get(''));
                //Ext.getCmp('fAtenderFueraListado').setValue(record.get(''));
                //Ext.getCmp('fRequiereAutorizacion').setValue(record.get(''));
                Ext.getCmp('fFacturarParticular').setValue(record.get('FacturarParticular'));
                Ext.getCmp('fFacturarCopagos').setValue(record.get('FacturarCopagos'));
                Ext.getCmp('fCopagoDigitado').setValue(record.get('CopagoDigitado'));
                Ext.getCmp('fvlrCuotaModeradoraIndicada').setValue(record.get('vlrCuotaModeradoraIndicada'));
                Ext.getCmp('fPorCopagos').setValue(record.get('PorCopagos'));
                //Ext.getCmp('fUsaAuditoria').setValue(record.get(''));
                Ext.getCmp('fAutorizacion').setValue(record.get('NroAutorizacion'));
                Ext.getCmp('fFinalidad').setValue(record.get('Finalidad'));
                //Ext.getCmp('fExentoPrograma').setValue(record.get(''));
                Ext.getCmp('fCas').setValue(record.get('CAS'));
                Ext.getCmp('fMaxCopago').setValue(record.get('MaxCopago'));
                Ext.getCmp('fYaLiquidado').setValue(record.get('YaLiquidado'));
                Ext.getCmp('fYaLegalizado').setValue(record.get('YaLegalizado'));
                Ext.getCmp('fNroCAS').setValue("CAS Nro: " + Ext.getCmp('fCas').getValue());
                Ext.getCmp('fFecRadicado').setValue(record.get('FechaEstudio'));
                if (record.get('ResumenHC') != null && record.get('ResumenHC') != "")
                    Ext.getCmp('fResumenHC').setValue(record.get('ResumenHC'));
                if (record.get('DiagPpal') != null && record.get('DiagPpal') != "")
                    Ext.getCmp('fDiagPpal').setValue(record.get('DiagPpal'));
                if (record.get('DiagRel1') != null && record.get('DiagRel1') != "")
                    Ext.getCmp('fDiagRel1').setValue(record.get('DiagRel1'));
                if (record.get('DiagRel2') != null && record.get('DiagRel2') != "")
                    Ext.getCmp('fDiagRel2').setValue(record.get('DiagRel2'));
                Ext.getCmp('sysVlrTotal_estudios').setValue(record.get('VlrEstudios'));
                Ext.getCmp('sysVlrIVA_estudios').setValue(record.get('VlrIVA'));
                Ext.getCmp('sysVlrCM_estudios').setValue(record.get('VlrCuotaModeradoraEstudios'));
                Ext.getCmp('sysVlrCopago_estudios').setValue(record.get('VlrCopagosEstudios'));
                Ext.getCmp('sysVlrDescuentos_estudios').setValue(record.get('VlrDescuentos'));
                Ext.getCmp('sysVlrNeto_estudios').setValue(record.get('VlrNeto'));
                Ext.getCmp('sysTipoLegalizacion_estudios').setValue(record.get('TipoLegalizacion'));
                var stUsrLegaliza = new StoreUsuarioSist();
                stUsrLegaliza.load({
                    params: { 'pUsuario': record.get('UsuarioLegaliza') },
                    callback: function()
                    {
                        Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(stUsrLegaliza.getAt(0).get('Descripcion') + ' - ' + record.get('FechaLegaliza'));
                    }
                });
                Ext.getCmp('gridServicios').store.load({
                    params: {
                        pCAS: Ext.getCmp('fCas').getValue()
                    }
                });
                Ext.getCmp('gridFacturacionOrden').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA,
                        pCAS: Ext.getCmp('fCas').getValue()
                    }
                });
                Ext.getCmp('fPacienteValido').setValue(1);
                paso1 = true;
                if (Ext.getCmp('fYaLegalizado').getValue() == 0)
                {
                    Ext.getCmp('fAutorizacion').enable();
                    Ext.getCmp('fModificaCAS').setValue(1);
                    Ext.Ajax.request({
                    url: '../../controlador/conceptos/matrizconceptosxcliente.php',
                        params:{
                            pIdTabla: "USR_" + ID_USUARIO,
                            pCliente: Ext.getCmp('fCliente').getValue(),
                            pIPS: ID_IPS,
                            pEsParticular: Ext.getCmp('fFacturarParticular').getValue(),
                            pUsaAuditoria: 0
                        },
                        scope:this 
                    });
                    EstblecerCamposEnabled();
                }else{
                    Ext.getCmp('fModificaCAS').setValue(0);
                }
                break;
                
            case "Modificacion":
                EstblecerCamposDisabled();
                var frm = Ext.getCmp('frmRadica').getForm();
                frm.reset();
                frm.clearInvalid();
                Ext.getCmp('fCliente').clearValue();
                Ext.getCmp('fPlan').clearValue();
                Ext.getCmp('fSubPlan').clearValue();
                Ext.getCmp('fContrato').clearValue();
                Ext.getCmp('fCliente').setValue(null);
                Ext.getCmp('fPlan').setValue(null);
                Ext.getCmp('fSubPlan').setValue(null);
                Ext.getCmp('fContrato').setValue(null);
                Ext.getCmp('fIdPaciente').setValue(0);
                frm = Ext.getCmp('frmResumenHC').getForm();
                frm.reset();
                frm.clearInvalid();
                frm = Ext.getCmp('frmLegalizar').getForm();
                frm.reset();
                frm.clearInvalid();
                Ext.getCmp('fIdPaciente').setValue(0);
                Ext.getCmp('gridServicios').store.load({
                    params: {
                        pCAS: 0
                    }
                });
                Ext.getCmp('gridFacturacionOrden').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA,
                        pCAS: 0
                    }
                });
                Ext.getCmp('gridServicios').store.removeAll();
                Ext.getCmp('gridFacturacionOrden').store.removeAll();
                Ext.getCmp('fClienteLA').setValue(0);
                Ext.getCmp('fPlanLA').setValue(0);
                Ext.getCmp('fSubPlanLA').setValue(0);
                Ext.getCmp('fCliente').store.load({
                    params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}
                });
                Ext.getCmp('fPlan').disable();
                Ext.getCmp('fSubPlan').disable();
                Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                Ext.getCmp('fEstadoCAS').setValue("");
                Ext.getCmp('fFecRadicado').setValue("");
                Ext.getCmp('fPacienteValido').setValue(0);
                Ext.getCmp('fYaFacturadoEnt').setValue(0);
                Ext.getCmp('fYaRealizado').setValue(0);
                paso1 = false;
                paso2 = false;
                paso3 = false;
                paso4 = false;
                paso5 = false;
                Ext.getCmp('fYaLegalizado').setValue(0);
                Ext.getCmp('fYaLiquidado').setValue(0);
                Ext.getCmp('fCas').setValue(0);
                Ext.getCmp('fModificaCAS').setValue(1);
                Ext.getCmp('sysTipoLegalizacion_estudios').setValue("");
                Ext.getCmp('sysResponsableLegalizacion_estudios').setValue("");
                
                Ext.getCmp('fYaFacturadoEnt').setValue(record.get('YaFacturadoEnt'));
                Ext.getCmp('fYaRealizado').setValue(record.get('YaRealizado'));
                
                Ext.getCmp('fTdoc').setValue(record.get('TipDoc'));
                Ext.getCmp('fDocID').setValue(record.get('Documento'));
                Ext.getCmp('fGenero').setValue(record.get('Genero'));
                Ext.getCmp('fApe1').setValue(PonerAcentosMayusculas(record.get('PrimerApellido')));
                Ext.getCmp('fApe2').setValue(PonerAcentosMayusculas(record.get('SegundoApellido')));
                Ext.getCmp('fNom1').setValue(PonerAcentosMayusculas(record.get('PrimerNombre')));
                Ext.getCmp('fNom2').setValue(PonerAcentosMayusculas(record.get('SegundoNombre')));
                Ext.getCmp('fFecNac').setValue(record.get('FecNac'));
                Ext.getCmp('fDeptoMuni').setValue(record.get('DeptoMuniciPaciente'));
                Ext.getCmp('fDireccion').setValue(PonerAcentosMayusculas(record.get('Direccion')));
                Ext.getCmp('fTel1').setValue(PonerAcentosMayusculas(record.get('Telefono')));
                Ext.getCmp('fTel2').setValue(PonerAcentosMayusculas(record.get('Telefono1')));
                Ext.getCmp('fZona').setValue(record.get('Zona'));
                Ext.getCmp('fEmail').setValue(PonerAcentosMayusculas(record.get('Email')));
                Ext.getCmp('fTafiliado').setValue(record.get('TipoAfiliado')); 
                Ext.getCmp('fRegimen').setValue(record.get('TipoAfiliacion'));
                Ext.getCmp('fParentesco').setValue(record.get('Parentesco'));
                Ext.getCmp('fRango').setValue(record.get('RangoSalarial'));
                Ext.getCmp('fCliente').setValue(record.get('Cliente'));
                Ext.getCmp('fPlan').store.load({
                    params: { 'pCliente': record.get('Cliente') },
                    callback: function()
                    {
                        Ext.getCmp('fPlan').setValue(record.get('Plan'));
                    }
                });
                Ext.getCmp('fSubPlan').store.load({
                    params: { 'pPlan': record.get('Plan') },
                    callback: function(){
                        Ext.getCmp('fSubPlan').setValue(record.get('Subplan'));
                    }
                });
                Ext.getCmp('fContrato').store.load({
                    params: { 'pCliente': record.get('Cliente') },
                    callback: function()
                    {
                        Ext.getCmp('fContrato').setValue(record.get('Contrato'));
                    }
                });
                Ext.getCmp('fFecSol').setValue(record.get('FechaToma'));
                Ext.getCmp('fPrograma').setValue(record.get('Programa'));
                Ext.getCmp('fProfeSol').setValue(record.get('ProfesionalSolicitante'));
                if(Ext.getCmp('fFecNac').getValue() != null && Ext.getCmp('fFecNac').getValue() != "")
                    Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(record.get('FechaEstudio'),Ext.getCmp('fFecNac').getValue().format('Y/m/d')));
                Ext.getCmp('fEstado').setValue(record.get('EstadoListado'));
                Ext.getCmp('fIdEmpresa').setValue(record.get('Prestador'));
                Ext.getCmp('fIdSede').setValue(record.get('Sede'));
                Ext.getCmp('fIdIPS').setValue(record.get('IPS'));
                Ext.getCmp('fIdPaciente').setValue(record.get('Paciente'));
                Ext.getCmp('fExento').setValue(record.get('Exento'));
                Ext.getCmp('fTutela').setValue(record.get('Tutela'));
                Ext.getCmp('fClienteLA').setValue(record.get('Cliente'));
                Ext.getCmp('fPlanLA').setValue(record.get('Plan'));
                Ext.getCmp('fSubPlanLA').setValue(record.get('Subplan'));
                Ext.getCmp('fPacienteValido').setValue(1);
                //Ext.getCmp('fUsaListado').setValue(record.get(''));
                //Ext.getCmp('fAtenderFueraListado').setValue(record.get(''));
                //Ext.getCmp('fRequiereAutorizacion').setValue(record.get(''));
                Ext.getCmp('fFacturarParticular').setValue(record.get('FacturarParticular'));
                Ext.getCmp('fFacturarCopagos').setValue(record.get('FacturarCopagos'));
                Ext.getCmp('fCopagoDigitado').setValue(record.get('CopagoDigitado'));
                Ext.getCmp('fvlrCuotaModeradoraIndicada').setValue(record.get('vlrCuotaModeradoraIndicada'));
                Ext.getCmp('fPorCopagos').setValue(record.get('PorCopagos'));
                //Ext.getCmp('fUsaAuditoria').setValue(record.get(''));
                Ext.getCmp('fAutorizacion').setValue(record.get('NroAutorizacion'));
                Ext.getCmp('fFinalidad').setValue(record.get('Finalidad'));
                //Ext.getCmp('fExentoPrograma').setValue(record.get(''));
                Ext.getCmp('fCas').setValue(record.get('CAS'));
                Ext.getCmp('fMaxCopago').setValue(record.get('MaxCopago'));
                Ext.getCmp('fYaLiquidado').setValue(record.get('YaLiquidado'));
                Ext.getCmp('fYaLegalizado').setValue(record.get('YaLegalizado'));
                Ext.getCmp('fNroCAS').setValue("CAS Nro: " + Ext.getCmp('fCas').getValue());
                Ext.getCmp('fFecRadicado').setValue(record.get('FechaEstudio'));
                if (record.get('ResumenHC') != null && record.get('ResumenHC') != "")
                    Ext.getCmp('fResumenHC').setValue(record.get('ResumenHC'));
                if (record.get('DiagPpal') != null && record.get('DiagPpal') != "")
                    Ext.getCmp('fDiagPpal').setValue(record.get('DiagPpal'));
                if (record.get('DiagRel1') != null && record.get('DiagRel1') != "")
                    Ext.getCmp('fDiagRel1').setValue(record.get('DiagRel1'));
                if (record.get('DiagRel2') != null && record.get('DiagRel2') != "")
                    Ext.getCmp('fDiagRel2').setValue(record.get('DiagRel2'));
                Ext.getCmp('sysVlrTotal_estudios').setValue(record.get('VlrEstudios'));
                Ext.getCmp('sysVlrIVA_estudios').setValue(record.get('VlrIVA'));
                Ext.getCmp('sysVlrCM_estudios').setValue(record.get('VlrCuotaModeradoraEstudios'));
                Ext.getCmp('sysVlrCopago_estudios').setValue(record.get('VlrCopagosEstudios'));
                Ext.getCmp('sysVlrDescuentos_estudios').setValue(record.get('VlrDescuentos'));
                Ext.getCmp('sysVlrNeto_estudios').setValue(record.get('VlrNeto'));
                Ext.getCmp('sysTipoLegalizacion_estudios').setValue(record.get('TipoLegalizacion'));
                var stUsrLegaliza = new StoreUsuarioSist();
                stUsrLegaliza.load({
                    params: { 'pUsuario': record.get('UsuarioLegaliza') },
                    callback: function()
                    {
                        Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(stUsrLegaliza.getAt(0).get('Descripcion') + ' - ' + record.get('FechaLegaliza'));
                    }
                });
                Ext.getCmp('gridServicios').store.load({
                    params: {
                        pCAS: Ext.getCmp('fCas').getValue()
                    }
                });
                Ext.getCmp('gridFacturacionOrden').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA,
                        pCAS: Ext.getCmp('fCas').getValue()
                    }
                });
                Ext.getCmp('fPacienteValido').setValue(1);
                paso1 = true;
                if (Ext.getCmp('fYaFacturadoEnt').getValue() == 0)
                {
                    Ext.getCmp('fAutorizacion').enable();
                    Ext.getCmp('fModificaCAS').setValue(1);
                    Ext.Ajax.request({
                    url: '../../controlador/conceptos/matrizconceptosxcliente.php',
                        params:{
                            pIdTabla: "USR_" + ID_USUARIO,
                            pCliente: Ext.getCmp('fCliente').getValue(),
                            pIPS: ID_IPS,
                            pEsParticular: Ext.getCmp('fFacturarParticular').getValue(),
                            pUsaAuditoria: 0
                        },
                        scope:this 
                    });
                    EstblecerCamposEnabled();
                }else{
                    Ext.getCmp('fModificaCAS').setValue(0);
                }
                break;
                
                
            default:
                break;
        }
        DGListingWindow.close();
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Estudio',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        view: new Ext.grid.GroupingView({
            groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
        }),
        columnLines: true,
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar:[
            {
                xtype: 'numberfield',
                minValue: 0,
                style: 'text-align:center;',
                emptyText: 'CAS...!',
                id: 'searchpCAS',
                width: 100
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: 'Nro Documento...!',
                id: 'searchpDocumento',
                width: 100
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '1er Nombre...!',
                id: 'searchpNom1',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '2do Nombre...!',
                id: 'searchpNom2',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '1er Apellido...!',
                id: 'searchpApe1',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '2do Apellido...!',
                id: 'searchpApe2',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: 'Nro Examen...!',
                id: 'searchpExamen',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                tooltip: 'Buscar Paciente',
                iconCls: 'btnBuscar',
                id: 'btnEjecutarSearchPac',
                listeners:{
                    click: function(){
                        DGDataStore.load({
                            params: {
                                pCAS: Ext.getCmp('searchpCAS').getValue(),
                                pDocumento: Ext.getCmp('searchpDocumento').getValue(),
                                pNom1: Ext.getCmp('searchpNom1').getValue(),
                                pNom2: Ext.getCmp('searchpNom2').getValue(),
                                pApe1: Ext.getCmp('searchpApe1').getValue(),
                                pApe2: Ext.getCmp('searchpApe2').getValue(),
                                pExamen: Ext.getCmp('searchpExamen').getValue(),
                                start: 0, 
                                limit: 15
                            }
                        });
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                tooltip: 'Limpiar Datos del Paciente',
                iconCls: 'btnLimpiar',
                id: 'btnLimpiarSearchPac',
                listeners:{
                    click: function(){
                        Ext.getCmp('searchpCAS').setValue(null);
                        Ext.getCmp('searchpDocumento').setValue(null);
                        Ext.getCmp('searchpNom1').setValue(null);
                        Ext.getCmp('searchpNom2').setValue(null);
                        Ext.getCmp('searchpApe1').setValue(null);
                        Ext.getCmp('searchpApe2').setValue(null);
                        Ext.getCmp('searchpExamen').setValue(null);
                        DGDataStore.load({
                            params: {
                                pCAS: 0,
                                pDocumento: 'NA',
                                pApe1: 'NA',
                                pApe2: 'NA',
                                pNom1: 'NA',
                                pNom2: 'NA',
                                pExamen: 'NA',
                                start: 0, 
                                limit: 15
                            }
                        });
                    }
                }
            },
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearch',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGrid').selModel.getCount() == 1){
                            doMsgBoxAlert(Ext.getCmp('DGListingEditorGrid').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'Pacientes',
                                msg: 'Debe Seleccionar un Registro.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: 'Busqueda de Estudios',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindow.show();
   
}