/*
* @category    Funcion Seguimientos Signos Vitales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function viewSeguimientoTomaSignos(wPaciente, wSigno, wField){
    var DGDataStoreSeguimientoTomaSignos;
    var DGColumnModelSeguimientoTomaSignos;
    var DGListingEditorGridSeguimientoTomaSignos;
    var DGListingWindowSeguimientoTomaSignos;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;
    var xg = Ext.grid;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idips');
    var ID_IPS = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla){
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }
    
    var btnSalir = new Ext.Button({
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            DGListingWindowSeguimientoTomaSignos.close();
        }
    });

    DGDataStoreSeguimientoTomaSignos = new Ext.data.Store({
        id: 'DGDataStoreSeguimientoTomaSignos',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/asistencial/controlador_tomasignos.php',
            method: 'POST'
        }),
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoLoad: false,
        params: {
            task: wSigno,
            pPaciente: wPaciente,
            pIPS: ID_IPS
        },
        reader: new Ext.data.JsonReader({
            root: 'data',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'NomVariable'},
            {name: 'Fecha'},
            {name: 'Variable'},
            {name: 'Variable1'},
            {name: 'Variable2'},
            {name: 'Variable3'},
            {name: 'Variable4'},
            {name: 'Variable5'},
            {name: 'Variable6'},
            {name: 'VariableN'}
         ])
    });
    
    doMsgBoxAlert = function(record) {
        //alert(pCampo);
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj){
        //
    };
    
    var chartSignos = new Ext.chart.LineChart({
        store: DGDataStoreSeguimientoTomaSignos,
        anchor: '100%',
        height: 330,
        id: 'sysChartSeguimiento',
        xField: wField,
        series:[{yField:'VariableN',displayName:''}],
        //yField: 'comedy'
        //series:[
            //{yField:'Variable',displayName:'Seguimiento'}
        //],
        /*yAxis: new Ext.chart.NumericAxis({
            labelRenderer: Ext.util.Format.usMoney
        }),
        xAxis: new Ext.chart.CategoryAxis({
            labelRenderer: this.customFormat
        }),*/
        extraStyle:{
            legend:{
                display: 'bottom'
            }
        }
    });
    
    switch(wSigno){
        case "VerHistoricoPesoxPac":
            DGColumnModelSeguimientoTomaSignos = new Ext.grid.ColumnModel([
                {
                    header: 'Fecha',
                    dataIndex: 'Fecha',
                    sortable: true,
                    width: 120
                },
                {
                    header: 'Peso',
                    dataIndex: 'Variable',
                    sortable: true,
                    width: 200
                },
                {
                    header: 'IMC',
                    dataIndex: 'Variable1',
                    sortable: true,
                    width: 200
                }
            ]);
            break;
        case "VerHistoricoTAxPac":
            DGColumnModelSeguimientoTomaSignos = new Ext.grid.ColumnModel([
                {
                    header: 'Fecha',
                    dataIndex: 'Fecha',
                    sortable: true,
                    width: 120
                },
                {
                    header: 'Sistolica',
                    dataIndex: 'Variable',
                    sortable: true,
                    width: 100
                },
                {
                    header: 'Diastolica',
                    dataIndex: 'Variable1',
                    sortable: true,
                    width: 100
                }
            ]);
            break;
        default:
            break;
    }
    
    
        
    DGListingEditorGridSeguimientoTomaSignos =  new Ext.grid.EditorGridPanel({
        id: 'DGListingEditorGridSeguimientoTomaSignos',
        store: DGDataStoreSeguimientoTomaSignos,
        clicksToEdit: 1,
        anchor: '100%',
        height: 200,
        cm: DGColumnModelSeguimientoTomaSignos,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        viewConfig: {
            forceFit:true
        },
        columnLines: true,
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        }
    });

   DGListingWindowSeguimientoTomaSignos = new Ext.Window({
        id: 'DGListingWindowSeguimientoTomaSignos',
        title: 'Seguimiento Toma de Signos',
        closable:false,
        width:980,
        height:600,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        //layout: 'fit',
        loadMask: true,
        autoScroll: true,
        items: [
            chartSignos,
            DGListingEditorGridSeguimientoTomaSignos
        ],
        bbar:[
            {
                text  : 'Empresa: ' + NOM_EMPRESA,
                xtype : 'tbtext'
            },
            '->',
            '-',
            btnSalir
        ]
    });
    DGListingWindowSeguimientoTomaSignos.show();
    DGListingEditorGridSeguimientoTomaSignos.store.setBaseParam("task", wSigno);
    DGListingEditorGridSeguimientoTomaSignos.store.setBaseParam("pPaciente", wPaciente);
    DGListingEditorGridSeguimientoTomaSignos.store.setBaseParam("pIPS", ID_IPS);
    DGListingEditorGridSeguimientoTomaSignos.store.load();
    switch(wSigno){
        case "VerHistoricoPesoxPac":
            var series = [];
            series.push({yField:'Variable',displayName:'Peso'});
            Ext.getCmp('sysChartSeguimiento').series = series;
            Ext.getCmp('sysChartSeguimiento').refresh();
            break;
        case "VerHistoricoTAxPac":
            var series = [];
            series.push({yField:'Variable',displayName:'Sistolica'});
            series.push({yField:'Variable1',displayName:'Diastolica'});
            Ext.getCmp('sysChartSeguimiento').series = series;
            Ext.getCmp('sysChartSeguimiento').refresh();
            break;
        default:
            break;
    }
}