/*
* @category    Funcion Buscar Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function buscarpacienteagendamanual()
{
    var DGDataStore;
    var DGColumnModel;
    var DGListingEditorGrid;
    var DGListingWindow;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    anchoPantalla = screen.width;
    el = Ext.get('idxac');
    var xID_CONSULTORIO = el.getValue();
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        iconCls: 'btnSalir',
        minWidth: 80,
        handler:function(){
            DGListingWindow.close();
        }
    });
    
    DGDataStore = new Ext.data.Store({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/pacientes/controlador_pacientes.php',
            method: 'POST'
        }),
        baseParams: {
            task: "LISTAR"
        },
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'Paciente'},
            {name: 'TipDoc'},
            {name: 'Documento'},
            {name: 'PrimerApellido'},
            {name: 'SegundoApellido'},
            {name: 'PrimerNombre'},
            {name: 'SegundoNombre'},
            {name: 'FecNac'},
            {name: 'Edad'},
            {name: 'Genero'},
            {name: 'TipoAfiliacion'},
            {name: 'Direccion'},
            {name: 'Zona'},
            {name: 'Telefono'},
            {name: 'Telefono1'},
            {name: 'Email'},
            {name: 'Empresa'},
            {name: 'Municipio'},
            {name: 'DeptoMunici'},
            {name: 'EstadoCivil'},
            {name: 'Escolaridad'},
            {name: 'Ocupacion'},
            {name: 'Seleccione'}
         ])
    });

    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: 'Paciente',
            dataIndex: 'Paciente',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        },{
            header: 'Tdoc',
            dataIndex: 'TipDoc',
            sortable: true,
            width: 40
        },{
            header: 'Documento',
            dataIndex: 'Documento',
            sortable: true,
            width: 130
        },{
            header: '1er Nombre',
            dataIndex: 'PrimerNombre',
            sortable: true,
            width: 150
        },{
            header: '2do Nombre',
            dataIndex: 'SegundoNombre',
            sortable: true,
            width: 150
        },{
            header: '1er Apellido',
            dataIndex: 'PrimerApellido',
            sortable: true,
            width: 150
        },{
            header: '2do Apellido',
            dataIndex: 'SegundoApellido',
            sortable: true,
            width: 150
        },{
            header: 'Telefono',
            dataIndex: 'Telefono',
            sortable: true,
            width: 150
        },{
            header: 'Otro Telefono1',
            dataIndex: 'Telefono1',
            sortable: true,
            width: 150
        }]
    );
    DGColumnModel.defaultSortable= true;
    
    doMsgBoxAlert = function(record) {
        Ext.getCmp('intIdPaciente').setValue(0);
        Ext.getCmp('sysPacienteValido').setValue(0);
        Ext.getCmp('strTdoc').setValue("");
        Ext.getCmp('strDocID').setValue("");
        Ext.getCmp('strGenero').setValue("");
        Ext.getCmp('strApe1').setValue("");
        Ext.getCmp('strApe2').setValue("");
        Ext.getCmp('strNom1').setValue("");
        Ext.getCmp('strNom2').setValue("");
        Ext.getCmp('fecFecNac').setValue("");
        Ext.getCmp('strEdad').setValue("");
        Ext.getCmp('strDireccion').setValue("");
        Ext.getCmp('strTel1').setValue("");
        Ext.getCmp('strTel2').setValue("");
        Ext.getCmp('strZona').setValue("");
        Ext.getCmp('strEmail').setValue(1);
        Ext.getCmp('intIdPaciente').setValue(record.get('Paciente'));
        Ext.getCmp('sysPacienteValido').setValue(1);
        Ext.getCmp('strTdoc').setValue(record.get('TipDoc'));
        Ext.getCmp('strDocID').setValue(record.get('Documento'));
        Ext.getCmp('strGenero').setValue(record.get('Genero'));
        Ext.getCmp('strApe1').setValue(PonerAcentosMayusculas(record.get('PrimerApellido')));
        Ext.getCmp('strApe2').setValue(PonerAcentosMayusculas(record.get('SegundoApellido')));
        Ext.getCmp('strNom1').setValue(PonerAcentosMayusculas(record.get('PrimerNombre')));
        Ext.getCmp('strNom2').setValue(PonerAcentosMayusculas(record.get('SegundoNombre')));
        Ext.getCmp('strDireccion').setValue(PonerAcentosMayusculas(record.get('Direccion')));
        Ext.getCmp('strZona').setValue(record.get('Zona'));
        Ext.getCmp('strTel1').setValue(PonerAcentosMayusculas(record.get('Telefono')));
        Ext.getCmp('strTel2').setValue(PonerAcentosMayusculas(record.get('Telefono1')));
        Ext.getCmp('strEmail').setValue(PonerAcentosMayusculas(record.get('Email')));
        if (record.get('FecNac') != null && record.get('FecNac') != "")
        {
            var xfecnac = Array();
            xfecnac = record.get('FecNac').split('-');
            var dianac = xfecnac[0];
            var mesnac = (xfecnac[1].length < 2)?'0':'';
            mesnac += xfecnac[1];
            var anonac = xfecnac[2];
            Ext.getCmp('fecFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
            Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac').getValue().format('Y/m/d')));
        }
        Ext.getCmp('strDeptoMuni').setValue(record.get('DeptoMunici'));
        
        try {
            var campo = Ext.getCmp('btn_ModificarItemAgendaManual');
            if ( campo != null ) {
                Ext.getCmp('btn_AdicionarItemAgendaManual').setVisible(false);
                Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(true);
            }
        }catch(ex){
        }
        
        
        try {
            var campo = Ext.getCmp('sysCitaTramite');
            if ( campo != null ) {
                Ext.getCmp('sysCitaTramite').setValue(1);
            }
        }catch(ex){
        }
        
        try {
            var campo1 = Ext.getCmp('strEspecialidadAsignaCita');
            if ( campo1 != null ) {
                Ext.getCmp('strEspecialidadAsignaCita').setValue(null);
            }
        }catch(ex){
        }
        
        DGListingWindow.close();
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Paciente',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar:[
            new Ext.app.SearchField({
                store: DGDataStore,
                params: {start: 0, limit: 15},
                emptyText: 'Escriba su criterio de búsqueda...!',
                width: 420
            }),
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearchPaciente',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGrid').selModel.getCount() == 1){
                            doMsgBoxAlert(Ext.getCmp('DGListingEditorGrid').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'Pacientes',
                                msg: 'Debe Seleccionar un Paciente.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: 'Busqueda de Pacientes',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        bbar:[
            '->',
            {
                text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
                xtype : 'tbtext'
            },
            '-',btnSalir
        ]
    });
    DGListingWindow.show();
   
}