/*
* @category    Funcion Buscar General en cualquier Tabla
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function buscargeneral(pCampo1, pCampo2, pCampo3, pOpcion){
    var DGDataStoreGeneral;
    var DGColumnModelGeneral;
    var DGListingEditorGridGeneral;
    var DGListingWindowGeneral;
    var DGListingSelectedRowGeneral;
    var DGListingContextMenuGeneral;
    var anchoPantallaGeneral;
    var MargenIzquierdoGeneral;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdoGeneral = 15;
            break;
        case 1280:
            MargenIzquierdoGeneral = 150;
            break;
    }

    var btnSalirGeneral = new Ext.Button({
        id: 'btnSalirGeneral',
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            DGListingWindowGeneral.close();
        }
    });

    DGDataStoreGeneral = new Ext.data.Store({
        id: 'DGDataStoreGeneral',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/searchgeneral/controlador_busquedageneral.php',
            method: 'POST'
        }),
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'Campo1'},
            {name: 'Campo2'},
            {name: 'Campo3'}
         ]),
      sortInfo:{field: 'Campo1', direction: "ASC"}
    });
    
    DGColumnModelGeneral = new Ext.grid.ColumnModel(
        [{
            header: 'Codigo',
            dataIndex: 'Campo1',
            sortable: true,
            width: 120
        },{
            header: 'Descripcion',
            dataIndex: 'Campo2',
            sortable: true,
            width: 780
        }]
    );
    DGColumnModelGeneral.defaultSortable= true;
    DGDataStoreGeneral.setBaseParam("task", pOpcion);
    
    doMsgBoxAlertGeneral = function(record) {
        //alert(pCampo);
        switch(pOpcion){
            case "SEARCH_CLIENTES_BARRA001":
                if(typeof pCampo1 !== 'undefined'){
                    Ext.getCmp(pCampo1).setValue(record.get('Campo1'));
                }
                if(typeof pCampo2 !== 'undefined'){
                    Ext.getCmp(pCampo2).setValue(record.get('Campo2'));
                }
                if(typeof pCampo3 !== 'undefined'){
                    Ext.getCmp(pCampo3).setValue(record.get('Campo3'));
                    Ext.getCmp(pCampo3).focus();
                }
                break;
            default:
                break;
        }
        DGListingWindowGeneral.close();
    };

    doRowDblClickGeneral = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlertGeneral(record);
    };

    doRowCtxMenuGeneral = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar',
                    handler : function() {
                        doMsgBoxAlertGeneral(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGridGeneral =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGridGeneral',
        store: DGDataStoreGeneral,
        cm: DGColumnModelGeneral,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClickGeneral,
           rowcontextmenu: doRowCtxMenuGeneral,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        tbar:[
            new Ext.app.SearchField({
                store: DGDataStoreGeneral,
                width: 120
            }),
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearchGeneral',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGridGeneral').selModel.getCount() === 1){
                            doMsgBoxAlertGeneral(Ext.getCmp('DGListingEditorGridGeneral').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'OfiClinic',
                                msg: 'Debe Seleccionar un Registro.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindowGeneral = new Ext.Window({
        id: 'DGListingWindowGeneral',
        title: 'Busqueda General',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdoGeneral,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGridGeneral,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3005703911',
            xtype : 'tbtext'
        },'-',btnSalirGeneral]
    });
    DGListingWindowGeneral.show();
   
}