/*
* @category    Funcion Buscar Concepto (Procedimientos - Medicamentos - Insumos - Otros)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function buscarconceptoBasico(wPantalla)
{
    var DGDataStore;
    var DGColumnModel;
    var DGListingEditorGrid;
    var DGListingWindow;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    var ID_ORIGEN = wPantalla;
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        iconCls: 'btnSalir',
        minWidth: 80,
        handler:function(){
            DGListingWindow.close();
        }
    });

    DGDataStore = new Ext.data.GroupingStore({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/conceptos/gridsearchconceptosbasico.php',
            method: 'POST'
        }),
        groupField: 'TipoEstudio',
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'IDConcepto', type: 'int', mapping: 'IDConcepto'},
            {name: 'Codigo', type: 'string', mapping: 'Codigo'},
            {name: 'Descripcion', type: 'string', mapping: 'Descripcion'},
            {name: 'TipoEstudio', type: 'string', mapping: 'TipoEstudio'},
            {name: 'EsMX', type: 'string', mapping: 'EsMX'},
            {name: 'EsAnatomo', type: 'string', mapping: 'EsAnatomo'},
            {name: 'CUPSCodigo', type: 'string', mapping: 'CUPSCodigo'},
            {name: 'CodMxMinisterio', type: 'string', mapping: 'CodMxMinisterio'},
            {name: 'POS', type: 'string', mapping: 'POS'},
            {name: 'NivelProced', type: 'int', mapping: 'NivelProced'},
            {name: 'EsCX', type: 'string', mapping: 'EsCX'},
            {name: 'NivelProced', type: 'int', mapping: 'NivelProced'},
            {name: 'UVR', type: 'float', mapping: 'UVR'},
            {name: 'GrupoQx', type: 'int', mapping: 'GrupoQx'},
            {name: 'MinDiasSol', type: 'int', mapping: 'MinDiasSol'},
            {name: 'CantidadMaxSol', type: 'int', mapping: 'CantidadMaxSol'},
            {name: 'DosisMaxPac', type: 'int', mapping: 'DosisMaxPac'},
            {name: 'EsPyP', type: 'string', mapping: 'EsPyP'},
            {name: 'IdTipoEstudio', type: 'string', mapping: 'IdTipoEstudio'},
            {name: 'PreparacionEspecial', type: 'string', mapping: 'PreparacionEspecial'},
            {name: 'POS', type: 'string', mapping: 'POS'},
            {name: 'UsaLoteVencimiento', type: 'string', mapping: 'UsaLoteVencimiento'},
            {name: 'ManejaKardex', type: 'string', mapping: 'ManejaKardex'},
            {name: 'UsaIVA', type: 'int', mapping: 'UsaIVA'},
            {name: 'IVA', type: 'decimal', mapping: 'IVA'}
         ]),
        sortInfo:{field: 'TipoEstudio', field: 'Codigo', field: 'Descripcion', direction: "ASC"}
    });

    function CodConcepto(val, x, store){
      return '<b style="color: #5959be;font-size: 10px;">'+val+'</b>';
    }

    function DescripcionConcepto(val, x, store){
        var html = '<table><tr><td><b style="color: #5959be;font-size: 12px;">'+val+'</b></td></tr><tr><td><p style="color: #fc6262;">Tipo Estudio: ' + store.data.TipoEstudio + '</p></tr></td><tr><td><p style="color: #033803;font-weight: bold;">Nivel: ' + store.data.NivelProced + '</p></tr></td></table>';
        return html;
    }

    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: 'IDConcepto',
            dataIndex: 'IDConcepto',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        },{
            header: 'Codigo',
            dataIndex: 'Codigo',
            sortable: true,
            renderer: CodConcepto,
            width: 120
        },{
            header: 'Descripcion',
            dataIndex: 'Descripcion',
            renderer: DescripcionConcepto,
            sortable: true,
            width: 820
        },{
            header: 'TipoEstudio',
            dataIndex: 'TipoEstudio',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        }]
    );
    DGColumnModel.defaultSortable= true;

    doMsgBoxAlert = function(record) {
        switch (wPantalla)
        {
            case "Conceptos":
                Ext.getCmp('intIdConceptoRadicaInst').setValue(record.get('IDConcepto'));
                Ext.getCmp('sysCodConceptoRadicaInst').setValue(record.get('Codigo'));
                Ext.getCmp('sysDesConceptoRadicaInst').setValue(record.get('Descripcion'));
                break;
            case "POS OPTICA":
                Ext.getCmp('intidConceptoItem').setValue(record.get('IDConcepto'));
                Ext.getCmp('strCodConceptoItem').setValue(record.get('Codigo'));
                Ext.getCmp('strDesConceptoItem').setValue(record.get('Descripcion'));
                //Ext.getCmp('sysIVA').setValue(record.get('UsaIVA'));
                var wVlarIVA = 0;
                if(record.get('IVA') !== "" && record.get('IVA') !== null){
                    wVlarIVA = record.get('IVA');
                }
                Ext.getCmp('intPorIVAItem').setValue(wVlarIVA);
                Ext.getCmp('intKardexItem').setValue(record.get('ManejaKardex'));
                Ext.getCmp('intUsaLoteItem').setValue(record.get('UsaLoteVencimiento'));
                if(parseInt(Ext.getCmp('intUsaLoteItem').getValue()) === 1){
                    Ext.getCmp('intLoteConceptoItem').store.load({
                        params:{
                            pConcepto: Ext.getCmp('intidConceptoItem').getValue()
                        }
                    });
                    Ext.getCmp('intLoteConceptoItem').allowBlank = false;
                    Ext.getCmp('intLoteConceptoItem').setVisible(true);
                }else{
                    Ext.getCmp('intLoteConceptoItem').setValue(null);
                    Ext.getCmp('intLoteConceptoItem').clearInvalid();
                    Ext.getCmp('intLoteConceptoItem').allowBlank = true;
                    Ext.getCmp('intLoteConceptoItem').setVisible(false);
                }
                break;
            case "ItemConteo":
                Ext.getCmp('intUsaLoteItemConteo').setValue(record.get('UsaLoteVencimiento'));
                Ext.getCmp('intidConceptoItemConteo').setValue(record.get('IDConcepto'));
                Ext.getCmp('strCodConceptoItemConteo').setValue(record.get('Codigo'));
                Ext.getCmp('strDesConceptoItemConteo').setValue(record.get('Descripcion'));
                if(parseInt(Ext.getCmp('intUsaLoteItemConteo').getValue()) === 1){
                    Ext.getCmp('intLoteConceptoItemConteo').store.load({
                        params:{
                            pConcepto: Ext.getCmp('intidConceptoItemConteo').getValue()
                        }
                    });
                    Ext.getCmp('intLoteConceptoItemConteo').allowBlank = false;
                    Ext.getCmp('intLoteConceptoItemConteo').setVisible(true);
                }else{
                    Ext.getCmp('intLoteConceptoItemConteo').setValue(null);
                    Ext.getCmp('intLoteConceptoItemConteo').clearInvalid();
                    Ext.getCmp('intLoteConceptoItemConteo').allowBlank = true;
                    Ext.getCmp('intLoteConceptoItemConteo').setVisible(false);
                }
                break;
            default:
                Ext.getCmp('intIdProcedimiento').setValue(record.get('IDConcepto'));
                Ext.getCmp('sysCodConcepto').setValue(record.get('Codigo'));
                Ext.getCmp('sysDesConcepto').setValue(record.get('Descripcion'));
                break;
        }
        DGListingWindow.close();
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Concepto',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        view: new Ext.grid.GroupingView({
            groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
        }),
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar:[
            new Ext.app.SearchField({
                store: DGDataStore,
                params: {start: 0, limit: 15},
                emptyText: 'Escriba su criterio de búsqueda...!',
                width: 420
            }),
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearch',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGrid').selModel.getCount() == 1){
                            doMsgBoxAlert(Ext.getCmp('DGListingEditorGrid').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'Pacientes',
                                msg: 'Debe Seleccionar un Registro.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: 'Busqueda de Conceptos',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindow.show();
   
}