/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmSalidaConsulta = Ext.extend(winSalidaConsultaUi, {
    initComponent: function() {
        winFrmSalidaConsulta.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        var ID_CONSULTORIO = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        BD_MULTIPRESTADOR = "NA";
        wCAS = 0;
        var btnBuscarPaciente = Ext.getCmp('btnBuscarPaciente').on("click",this.BuscarPaciente,this);
        //var btnDelItemGridConsultorios = Ext.getCmp('btnDelItemGridConsultorios').on("click",this.DesasociarConsultorioxProfe,this);
    },
    BuscarPaciente: function(){
        buscarpaciente("BuscarPacienteBasico");
        wCAS = 0;
        //Ext.getCmp('gridSalidaConsultaCAS').store.removeAll();
        Ext.getCmp('sysTotCM').setValue(0);
        Ext.getCmp('sysTotCOP').setValue(0);
        Ext.getCmp('sysTotNETO').setValue(0);
        Ext.getCmp('gridMedicamentosHC').store.removeAll();
        Ext.getCmp('gridRemisionesHC').store.removeAll();
        Ext.getCmp('gridExamenesHC').store.removeAll();
    },
    DesasociarConsultorioxProfe: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelConsultorio_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Asociar Consultorios - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridConsultoriosIPSxProfe').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridConsultoriosIPSxProfe').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Plantilla de Citas',
                    msg: 'Esta Seguro que Desea Eliminar el Consultorio ' + selections[0].json.Consultorio + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "GRID_CONSULTORIOS_ELIMINAR", pProfesional: selections[0].json.idProfesional, pIPS: selections[0].json.idIPS, pConsultorio: selections[0].json.idConsultorio}, 'gridConsultoriosIPSxProfe')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    }
});