/*
* @category    Formulario Adicionar Consumo de Placas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winConsumoPlacasRxUi = Ext.extend(Ext.Window, {
    title: '.:: Consumo de Placas ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winConsumoPlacasRxUi',
    initComponent: function() {
        var selMx = "0";
        
        var dataTipoConsumo = [
            ["TOMADAS"],
            ["DAÑADAS"]
        ];
        var stTipoConsumo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stTipoConsumo.loadData(dataTipoConsumo);
        
        var dataPlacas = [
            ["PLACA N. 8"],
            ["PLACA N. 10"],
            ["PLACA N. 11"],
            ["PLACA N. 14"],
            ["PLACA N. 17"]
        ];
        var stPlacas = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stPlacas.loadData(dataPlacas);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddConsumoPlacasRx',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoHCConsumoRx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioConsumoRx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo Consumo',
                                anchor: '100%',
                                allowBlank: false,
                                store: stTipoConsumo,
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: false,
                                id: 'strTipoConsumoRx'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Descripcion',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: stTipoConsumo,
                                        typeAhead: true,
                                        typeAheadDelay: 450,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'strPlacaConsumoRx'
                                    },
                                    {
                                        xtype: 'textarea',
                                        fieldLabel: 'Remisión',
                                        anchor: '100%',
                                        allowBlank: true,
                                        id: 'strPlacaConsumoRx'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Observaciones',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'strObservacionesConsumoRx'
                            },
                            {
                                xtype: 'hidden',
                                id: 'strSelectConceptoRem',
                                allowBlank: true
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddRem',
                            listeners:{
                                click : function(){
                                    /*Ext.Msg.show({
                                        title: 'Guardar Remisiones',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                fnGuardarRegItemRem("GUARDAR_OFIMEDICAL","SI","winSolRem002Ui","frmAddRemisiones","../../controlador/solrem/controlador_solrem.php","gridRemisionesHC");
                                            }
                                        }
                                    });*/
                                    fnGuardarRegItemRem("GUARDAR_OFIMEDICAL","SI","winSolRem002Ui","frmAddRemisiones","../../controlador/solrem/controlador_solrem.php","gridRemisionesHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winConsumoPlacasRxUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemRem(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        Ext.getCmp('strSelectConceptoRem').setValue(parseInt(Ext.getCmp('strConceptoOfiMedicalRem').getValue()));
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        /*Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });*/
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
