/*
* @category    Cargar CargarHuellaPaciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

CargarHuellaPacienteUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    id: 'CargarHuellaPacienteUi',
    width: 560,
    autoHeight: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    draggable: false,
    resizable: false,
    title: 'Adjuntar Huella del Paciente',

    initComponent: function() {
        el = Ext.get('idxac');
        var xID_CONSULTORIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();

        var frmCargarHuella = new Ext.FormPanel({
            fileUpload: true,
            labelWidth: 80,
            frame: true,
            height: 49,
            url: '../../controlador/recursos/huellapaciente.php',
            bodyStyle: 'padding:0px 0px 30px',
            defaults: {
                allowBlank: false
            },
            items: [
                {
                    xtype: 'fileuploadfield',
                    anchor: '99%',
                    id: 'archivoHuella',
                    fieldLabel: 'Archivo',
                    name: 'huella-path',
                    buttonText: '...',
                    buttonCfg: {}
                }
            ]
        });
    
        this.items = [
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysPacienteHuella'
            },
            frmCargarHuella
        ];
        this.buttons = [
            {
                text: 'Adjuntar Huella',
                iconCls: 'btnCargarFile',
                handler: function(){
                    nomTarea = "GRABAR_OFIMEDICAL";
                    if(NOM_APLICACION === "OfiMedical"){
                        nomTarea = "GRABAR_OFIMEDICAL";
                    }else{
                        nomTarea = "GRABAR_OFICLINIC";
                    }
                    if (frmCargarHuella.getForm().isValid()) {					
                        frmCargarHuella.getForm().submit({
                            waitTitle: 'Estado',
                            waitMsg: 'Cargando Archivo ...',
                            params: {
                                task: nomTarea,
                                pPaciente: Ext.getCmp('sysPacienteHuella').getValue()
                            },
                            success: function(form, action){
                                var data = Ext.util.JSON.decode(action.response.responseText);
                                Ext.Msg.show({
                                    title: NOM_APLICACION,
                                    msg: data.message.reason,
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.INFO
                                });
                                if(NOM_APLICACION === "OfiMedical"){
                                    var updater = Ext.getCmp('showHuella').getUpdater();
                                    updater.setDefaultUrl('../../../app/controlador/pacientes/showhuella.php?pPaciente=' + Ext.getCmp('sysPacienteHuella').getValue());
                                    updater.refresh();
                                }else{
                                    var updater = Ext.getCmp('showHuella').getUpdater();
                                    updater.setDefaultUrl('../../../app/controlador/pacientes/showhuella.php?pPaciente=' + Ext.getCmp('sysPacienteHuella').getValue());
                                    updater.refresh();
                                }
                                Ext.getCmp('CargarHuellaPacienteUi').close();
                            },
                            failure: function(form, action){
                                if (action.failureType === 'server') {
                                    var data = Ext.util.JSON.decode(action.response.responseText);
                                    Ext.Msg.show({
                                        title: NOM_APLICACION,
                                        msg: data.errors.reason,
                                        buttons: Ext.Msg.OK,
                                        icon: Ext.Msg.ERROR
                                    });
                                }
                            }
                    });
                }
            }
        }];
        CargarHuellaPacienteUi.superclass.initComponent.call(this);
    }
});
