/*
* @category    Formulario Radicar Citas Especialistas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmRadicaCitaEspUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Radicar Citas y Cirugias para Programacion ::.',
    width: 1004,
    height: 636,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmRadicaCitaEsp',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        var dataEspecialidadRadicaCita = [
            ['CONSULTA OPTOMETRIA'],
            ['CONSULTA OFTALMOLOGIA'],
            ['PROGRAMACION CIRUGIA'],
            ['EXAMENES ESPECIALIZADOS'],
            ['PROCEDIMIENTOS ESPECIALIZADOS'],
            ['CONSULTAS ESPECIALIZADAS']
        ];
        var stEspecialidadRadicaCita = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEspecialidadRadicaCita.loadData(dataEspecialidadRadicaCita);
        
        var dataPrioridad = [
            ['NORMAL'],
            ['PRIORITARIO'],
            ['URGENTE']
        ];
        var stPrioridad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPrioridad.loadData(dataPrioridad);
        
        
        var dataMarcaServicio = [
            ['0 - SIN DEFINIR'],
            ['1 - CAPITADO NO REQUIERE AUTORIZACION'],
            ['2 - CAPITADO REQUIERE AUTORIZACION'],
            ['3 - EVENTO REQUIERE AUTORIZACION']
        ];
        var stMarcaServicio = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMarcaServicio.loadData(dataMarcaServicio);
        
        
        var dataTipoAtencionRadicaCita = [
            ['1 VEZ'],
            ['CONTROL']
        ];
        var stTipoAtencionRadicaCita = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoAtencionRadicaCita.loadData(dataTipoAtencionRadicaCita);
        
        var dataOpcionesControl = [
            ['DIAS'],
            ['MESES']
        ];
        var stOpcionesControl = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stOpcionesControl.loadData(dataOpcionesControl);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmPacientesCitaManual',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intIdPaciente',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPacienteValido',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysCitaTramite',
                        value: 0
                    },
                    {
                        xtype: 'panel',
                        title: 'Datos del Paciente',
                        layout: 'table',
                        collapseFirst: false,
                        border: true,
                        anchor: '100%',
                        autoHeight: true,
                        id: 'fsPaciente',
                        layoutConfig: {
                            columns: 4
                        },
                        items: [
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 221,
                                border: false,
                                id: 'pnTdoc',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Doc ID',
                                        anchor: '100%',
                                        name: 'cbTdoc',
                                        allowBlank: false,
                                        store: 'StoreTdocPac',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Tipo Documento....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'strTdoc'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 269,
                                border: false,
                                id: 'pnDocID',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Documento ID',
                                                name: 'txtDocID',
                                                allowBlank: false,
                                                width: 200,
                                                id: 'strDocID'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Paciente',
                                                id: 'btnBuscarPacienteAgendaManual'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnUsrVerifica',
                                                tooltip: 'Verificar Paciente en el Listado de Atención',
                                                id: 'btnVerificaPacienteListado'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 172,
                                border: false,
                                colspan: 2,
                                id: 'pnGenero',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Genero',
                                        anchor: '100%',
                                        name: 'cbGenero',
                                        allowBlank: false,
                                        store: 'StoreGenero',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        emptyText: 'Seleccione Genero....',
                                        forceSelection: true,
                                        id: 'strGenero'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 271,
                                border: false,
                                id: 'pnApe1',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '1er Apellido',
                                        anchor: '100%',
                                        name: 'txtApe1',
                                        style: 'text-transform:uppercase;',
                                        allowBlank: false,
                                        id: 'strApe1'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 271,
                                border: false,
                                id: 'pnApe2',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '2do Apellido',
                                        anchor: '100%',
                                        name: 'txtApe2',
                                        style: 'text-transform:uppercase;',
                                        id: 'strApe2'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 215,
                                border: false,
                                id: 'pnNom1',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '1er Nombre',
                                        anchor: '96%',
                                        name: 'txtNom1',
                                        allowBlank: false,
                                        style: 'text-transform:uppercase;',
                                        id: 'strNom1'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                border: false,
                                width: 230,
                                id: 'pnNom2',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '2do Nombre',
                                        anchor: '78%',
                                        name: 'txtNom2',
                                        style: 'text-transform:uppercase;',
                                        id: 'strNom2'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 146,
                                border: false,
                                id: 'pnFecNac',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Nacimiento',
                                        anchor: '100%',
                                        name: 'txtFecNac',
                                        allowBlank: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFecNac'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 271,
                                border: false,
                                id: 'pnEdad',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Edad Actual',
                                        anchor: '100%',
                                        name: 'txtEdad',
                                        readOnly: true,
                                        allowBlank: true,
                                        style: 'color: blue;text-align:center',
                                        id: 'strEdad'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 396,
                                border: false,
                                colspan: 2,
                                id: 'pnDeptoMuni',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Municipio - Departamento - Residencia',
                                        anchor: '99%',
                                        name: 'cbDeptoMuni',
                                        allowBlank: false,
                                        store: 'StoreDeptoMuni',
                                        valueField: 'IdDeptoMunicipio',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Municipio - Departamento....',
                                        mode: 'local',
                                        listWidth: 450,
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        id: 'strDeptoMuni'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                layout: 'form',
                                labelAlign: 'top',
                                padding: 5,
                                width: 958,
                                border: false,
                                colspan: 4,
                                height: 54,
                                id: 'pnDatDirTel',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                        anchor: '100%',
                                        id: 'composDatDirTel',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name: 'txtDireccion',
                                                allowBlank: false,
                                                emptyText: 'Dirección....',
                                                style: 'text-transform:uppercase;',
                                                width: 280,
                                                id: 'strDireccion'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'txtTel1',
                                                allowBlank: false,
                                                emptyText: 'Teléfono',
                                                width: 160,
                                                id: 'strTel1'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'txtTel2',
                                                emptyText: 'Teléfono (Otro - Cel.)',
                                                width: 160,
                                                id: 'strTel2'
                                            },
                                            {
                                                xtype: 'combo',
                                                flex: 1,
                                                fieldLabel: 'Zona',
                                                store: 'StoreZonaResidencia',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                name: 'cbZona',
                                                emptyText: 'Zona....',
                                                allowBlank: false,
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                width: 80,
                                                value: 'Urbana',
                                                triggerAction: 'all',
                                                id: 'strZona'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'txtEmail',
                                                vtype: 'email',
                                                emptyText: 'Email....',
                                                width: 220,
                                                id: 'strEmail'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ],
                        tbar:{
                            items: [
                                {
                                    xtype: 'button',
                                    text: 'Nuevo Paciente',
                                    iconCls: 'btnNuevo',
                                    id: 'btnNuevoAgendaManual'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Guardar',
                                    iconCls: 'btnGuardar',
                                    id: 'btn_AdicionarItemAgendaManual'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Modificar',
                                    iconCls: 'btnGuardar',
                                    id: 'btn_ModificarItemAgendaManual'
                                }
                            ]
                        }
                    }
                ]
            },
            {
                xtype: 'panel',
                title: 'Cliente y Concepto para Radicar',
                layout: 'form',
                padding: 10,
                anchor: '100%',
                autoHeight: true,
                frame: true,
                border: true,
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historial Citas Radicadas',
                            iconCls: 'btnAsignarCita',
                            id: 'btn_RadicarVerHistorialCitaItemAgendaManual'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Radicar',
                            iconCls: 'btnAsignarCita',
                            id: 'btn_RadicarCitaItemAgendaManual'
                        }
                    ]
                },
                items: [
					{
						xtype: 'hidden',
						value: 0,
						id: 'sysIdRadicaAgendaEspecialista'
					},
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Solicitante',
                                name: 'cbProfeSol',
                                allowBlank: false,
                                store: 'StoreProfeSol',
                                forceSelection: true,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                emptyText: 'Seleccione Profesional / IPS Solicitante....',
                                valueField: 'idProfeSolicitante',
                                displayField: 'Descripcion',
                                width: 827,
                                submitValue: true,
                                id: 'intProfeSol'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnDoctor',
                                tooltip: 'Adicionar Profesional / IPS Solicitante',
                                id: 'btnAddProfeSol'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        id: 'composDatClientex',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cliente',
                                width: 250,
                                allowBlank: false,
                                store: 'StoreCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Cliente....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClienteAsignaCita'
                            },
                            {
                                xtype: 'combo',
                                width: 200,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClientesPlan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClientePlanAsignaCita'
                            },
                            {
                                xtype: 'combo',
                                width: 200,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClienteSubplan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdSubPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione SubPlan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClienteSubPlanAsignaCita'
                            },
                            {
                                xtype: 'combo',
                                width: 190,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClienteContrato',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdContrato',
                                displayField: 'Contrato',
                                emptyText: 'Contrato....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClienteContratoAsignaCita'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Concepto',
                                width: 827,
                                allowBlank: false,
                                store: 'StoreConceptosCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><span style="font-size: 12; color: #AA0033">Codigo: {CUPSCodigo}</span><br/><span style="font-size: 12; color: #0000EE ">Tarifa: $ {Tarifa}</span><hr /></div></tpl>',
                                emptyText: 'Seleccione Concepto....',
                                itemSelector: 'div.cbRango',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intConceptoAsignaCita'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Concepto',
                                listeners: {
                                    click: function(){
                                        buscarconcepto(0, "NO", "NA", "RADICAR_CITA", Ext.getCmp('intClienteAsignaCita').getValue(), Ext.getCmp('intClientePlanAsignaCita').getValue(), Ext.getCmp('intClienteSubPlanAsignaCita').getValue());
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                width: 30,
                                allowBlank: false,
                                minValue: 1,
                                value: 1,
                                id: 'intCantidadAsignaCita'
                            },
                            {
                                html: 'Es Prioritario:'
                            },
                            {
                                xtype: 'combo',
                                width: 50,
                                name: 'Es Prioritario',
                                allowBlank: false,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                value: 'NO',
                                id: 'strServicioPrioritarioAsignaCita'
                            },
                            {
                                html: 'Diagnostico:'
                            },
                            {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: false,
                                id: 'sysDiagPpalHC',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                        {
                                            if (f.getValue() !== "" && f.getValue() !== null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                            }
                                        }
                                    },
                                    blur: function(t){
                                        if (Ext.getCmp('sysDiagPpalHC').getValue() !== "" && Ext.getCmp('sysDiagPpalHC').getValue() !== null){
                                            Ext.Ajax.request({
                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                params:{
                                                    task: 'BUSCAR',
                                                    pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] ==="" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                    } else {
                                                        Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                    }
                                                },
                                                failure: function(response,options){
                                                    var el = Ext.get('response');
                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                },
                                                scope:this //bind the callbacks
                                            });
                                        }else{
                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textfield',
                                readOnly: true,
                                width: 490,
                                id: 'sysDiagPpalHCNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                id: 'btnSearchDiagPpalHC',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo Registro',
                                width: 250,
                                allowBlank: false,
                                store: stEspecialidadRadicaCita,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Tipo....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'strEspecialidadAsignaCita'
                            },
                            {
                                html: 'Tipo Cita:'
                            },
                            {
                                xtype: 'combo',
                                width: 106,
                                allowBlank: true,
                                store: stTipoAtencionRadicaCita,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Tipo....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                disabled: true,
                                id: 'strTipoAtencionAsignaCita'
                            },
                            {
                                html: 'Marcacion:'
                            },
                            {
                                xtype: 'combo',
                                width: 290,
                                allowBlank: true,
                                store: stMarcaServicio,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                disabled: true,
                                id: 'strMarcacionAsignaCita'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: false,
                                fieldLabel: 'Fec. Solicitud',
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecFechaSolicitud'
                            },
                            {
                                html: 'Organo:'
                            },
                            {
                                xtype: 'combo',
                                width: 120,
                                store: 'StoreMiembroParte',
                                anchor: '100%',
                                validationDelay: 50,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                forceSelection: true,
                                disabled: true,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                id: 'intOrgano'
                            },
                            {
                                html: 'NroAutorizacion:'
                            },
                            {
                                xtype: 'textfield',
                                width: 150,
                                allowBlank: true,
                                disabledDates: '',
                                disabled: true,
                                id: 'strNroAutorizacion'
                            },
                            {
                                html: 'Fecha Recepcion Orden:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: false,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                disabled: true,
                                id: 'fecFechaRecepcionOrden'
                            }
                        ]
                    },
                    
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Observaciones',
                        allowBlank: true,
                        anchor: '100%',
                        style: 'text-transform:uppercase;',
                        id: 'memObservacionAsignaCita'
                    }
                ]
            }
        ];
        winFrmRadicaCitaEspUi.superclass.initComponent.call(this);
    }
});
