/*
* @category    Formulario Grid Historial de Citas Radicadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmHistorialCitaRadicadasUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Historial de Citas - CX Radicadas ::.',
    id: 'winFrmHistorialCitaRadicadas',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridHistorialCitasRadicadas();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        function VerInfoCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('NomCliente') + '</br>' + record.get('NomPlan') + '</br>' + record.get('NomSubPlan');  
        }
        
        function VerInfoCita(value, metaData, record, rowIndex, colIndex, store){  
            reshtml = '<table border="0"><tr><td>' + value + '</td></tr><tr><td>' + record.get('CodProced') + ' - ' + record.get('DesProced') + '</td></tr>';  
            if(record.get('CAS') !== "" && parseInt(record.get('CAS')) !== 0 && record.get('CAS') !== null){
                reshtml += '<tr><td><hr></td></tr><tr><td>CITA ASIGNADA - CAS: ' + record.get('CAS') + '</td></tr>'; 
                reshtml += '<tr><td>' + record.get('NomProfesional') + '</td></tr>'; 
                reshtml += '<tr><td>FECHA: ' + record.get('FecCita') + ' HORA: ' + record.get('HoraCita') + '</td></tr>'; 
            }
            reshtml += '</table>'; 
            return reshtml;
        }
        
        this.items = [
			{
				xtype: 'hidden',
				id: 'sysOrigenOpcion'
			},
            {
                xtype: 'grid',
                id: 'gridHistorialCitasRadicada',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
				height: 445,
                stripeRows: true,
                columns:[
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 80,
                        //hidden: true,
                        hideable: false,
                        dataIndex: 'IdRadicaAgendaEspecialista',
                        id: 'IdRadicaAgendaEspecialista'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Radicado',
                        sortable: true,
                        width: 90,
                        dataIndex: 'FechaRadicado',
                        id: 'FechaRadicado'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha Atencion',
                        sortable: true,
                        width: 90,
                        dataIndex: 'FechaAtendieron',
                        id: 'FechaAtendieron'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Especialidad',
                        sortable: false,
                        width: 200,
                        dataIndex: 'Especialidad',
                        renderer: VerInfoCita,
                        id: 'Especialidad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Tipo',
                        sortable: false,
                        width: 100,
                        dataIndex: 'TipoAtencion',
                        id: 'TipoAtencion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cliente',
                        sortable: false,
                        width: 150,
                        renderer: VerInfoCliente,
                        dataIndex: 'NomCliente',
                        id: 'NomCliente'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'CAS',
                        sortable: true,
                        width: 80,
                        dataIndex: 'CAS',
                        id: 'CAS'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Estado',
                        sortable: false,
                        width: 20,
                        dataIndex: 'EstadoReg',
                        id: 'EstadoReg'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario Quien Radico',
                        sortable: false,
                        width: 120,
                        dataIndex: 'UsuarioRadico',
                        id: 'UsuarioRadico'
                    }
                ],   
                columnLines: true,
                viewConfig: {
                    getRowClass: function(record, index) {
                        var estado = record.data.EstadoReg;
                        switch(estado){
                            case "A":
                                return "Apto";
                                break;
                            default:
                                return "NoActivo";
                                break;
                        }
                    }
                },
                tbar:{
                    items: [
						{
                            xtype: 'tbseparator'
                        },
						{
                            xtype: 'button',
                            text: 'Modificar Radicacion de Cita',
                            iconCls: 'btnEditRow',
                            listeners: {
                                click : function() {
									if(Ext.getCmp('sysOrigenOpcion').getValue() == "RADICARCX"){
										if(Ext.getCmp('gridHistorialCitasRadicada').selModel.getCount() === 1){
											var selections = Ext.getCmp('gridHistorialCitasRadicada').selModel.getSelections();
											if(selections[0].json.EstadoReg === "R"){
												Ext.Msg.show({
													title: 'Radicacion de Citas',
													msg: 'Esta Seguro que Desea Modificar el Registro Cita: ' + selections[0].json.Especialidad + ' - Fecha: ' + selections[0].json.FechaRadicado + '?',
													buttons: Ext.Msg.YESNO,
													icon: Ext.Msg.QUESTION,
													fn: function(btn){
														if(btn==="yes"){
															//fnEliminarRegistrosCitaRadicada("../../controlador/asignarcitasesp/controlador_radicarcitas.php",{task: "ELIMINAR_RADICAR_CITA", pIdCita: selections[0].json.IdRadicaAgendaEspecialista}, 'gridHistorialCitasRadicada');
															Ext.getCmp('intProfeSol').setValue(selections[0].json.Solicitante);
															Ext.getCmp('intClienteAsignaCita').setValue(selections[0].json.Cliente);
															Ext.getCmp('intClientePlanAsignaCita').store.load({
																params:{
																	pCliente: selections[0].json.Cliente
																},
																callback: function(){
																	Ext.getCmp('intClientePlanAsignaCita').enable();
																	Ext.getCmp('intClientePlanAsignaCita').setValue(selections[0].json.Plan);
																}
															});
															Ext.getCmp('intClienteContratoAsignaCita').store.load({
																params:{
																	pCliente: selections[0].json.Cliente
																},
																callback: function(){
																	Ext.getCmp('intClienteContratoAsignaCita').enable();
																	Ext.getCmp('intClienteContratoAsignaCita').setValue(selections[0].json.Contrato);
																}
															});
															Ext.getCmp('intConceptoAsignaCita').store.load({
																params:{
																	pCliente: selections[0].json.Cliente,
																	pIPS: ID_IPS
																},
																callback: function(){
																	Ext.getCmp('intConceptoAsignaCita').enable();
																	Ext.getCmp('intConceptoAsignaCita').setValue(selections[0].json.IdProced);
																}
															});
															
															Ext.getCmp('intClienteSubPlanAsignaCita').store.load({
																params:{
																	pPlan: selections[0].json.Plan
																},
																callback: function(){
																	Ext.getCmp('intClienteSubPlanAsignaCita').enable();
																	Ext.getCmp('intClienteSubPlanAsignaCita').setValue(selections[0].json.SubPlan);
																}
															});
															
															Ext.getCmp('intCantidadAsignaCita').setValue(selections[0].json.Cantidad);
															Ext.getCmp('strServicioPrioritarioAsignaCita').setValue(selections[0].json.Prioritario);
															Ext.getCmp('sysDiagPpalHC').setValue(selections[0].json.Diagnostico);
															Ext.getCmp('strEspecialidadAsignaCita').setValue(selections[0].json.Especialidad);
															Ext.getCmp('strTipoAtencionAsignaCita').setValue(selections[0].json.TipoAtencion);
															Ext.getCmp('strMarcacionAsignaCita').setValue(selections[0].json.MarcaServicio);
															Ext.getCmp('fecFechaSolicitud').setValue(selections[0].json.FechaRadicado);
															Ext.getCmp('intOrgano').setValue(selections[0].json.MiembroParteCuerpo);
															Ext.getCmp('strNroAutorizacion').setValue(selections[0].json.Autorizacion);
															//Ext.getCmp('fecFechaRecepcionOrden').setValue(null);
															Ext.getCmp('memObservacionAsignaCita').setValue(selections[0].json.Observaciones);
															Ext.getCmp('sysIdRadicaAgendaEspecialista').setValue(selections[0].json.IdRadicaAgendaEspecialista);
														}
													}
												});
											}else{
												Ext.MessageBox.show({
													title: 'Error',
													msg: 'Este registro no esta disponible para ser eliminado.',
													buttons: Ext.MessageBox.OK,
													icon: Ext.MessageBox.ERROR
												});
											}
										}else{
											Ext.MessageBox.show({
												title: 'Error',
												msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
												buttons: Ext.MessageBox.OK,
												icon: Ext.MessageBox.ERROR
											});
										}
									}else{
										Ext.MessageBox.show({
											title: 'Error',
											msg: 'Para modificar el regitro debe ser desde la opcion de radicacion de citas.',
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.ERROR
										});
									}
                                }
                            }
                                    
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Eliminar Radicacion de Cita',
                            iconCls: 'btnDelRow',
                            listeners: {
                                click : function() {
                                    if(Ext.getCmp('gridHistorialCitasRadicada').selModel.getCount() === 1){
                                        var selections = Ext.getCmp('gridHistorialCitasRadicada').selModel.getSelections();
                                        if(selections[0].json.EstadoReg === "R"){
                                            Ext.Msg.show({
                                                title: 'Radicacion de Citas',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro Cita: ' + selections[0].json.Especialidad + ' - Fecha: ' + selections[0].json.FechaRadicado + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn==="yes"){
                                                        fnEliminarRegistrosCitaRadicada("../../controlador/asignarcitasesp/controlador_radicarcitas.php",{task: "ELIMINAR_RADICAR_CITA", pIdCita: selections[0].json.IdRadicaAgendaEspecialista}, 'gridHistorialCitasRadicada');
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Este registro no esta disponible para ser eliminado.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                                    
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Bitacora',
                            iconCls: 'btnEditRow',
                            listeners: {
                                click : function() {
                                    if(Ext.getCmp('gridHistorialCitasRadicada').selModel.getCount() === 1){
                                        var selections = Ext.getCmp('gridHistorialCitasRadicada').selModel.getSelections();
                                        if(selections[0].json.EstadoReg === "R"){
                                            var BitacoraCitaRadicadas = new winFrmBitacoraCitaRadicadasUi();
                                            Ext.getCmp('sysIdAgendaEspecialistaBitacora').setValue(selections[0].json.IdRadicaAgendaEspecialista);
                                            Ext.getCmp('gridBitacoraCitasRadicada').store.load({
                                                params: {
                                                    pIdCita: selections[0].json.IdRadicaAgendaEspecialista
                                                }
                                            });
                                            BitacoraCitaRadicadas.show();
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Este registro no esta disponible.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos registrar la bitacora estos momentos, verifique que solo haya seleccionado un registro',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                                    
                        }
                    ]
                }
            }
        ];
        winFrmHistorialCitaRadicadasUi.superclass.initComponent.call(this);
    }
});

function fnEliminarRegistrosCitaRadicada(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}