/*
* @category    Formulario Grid Bitacora de Citas Radicadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmBitacoraCitaRadicadasUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Bitacora Seguimiento Citas - CX ::.',
    id: 'winFrmBitacoraCitaRadicadas',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridCitasCxBitacora();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        function VerInfoBitacora(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Observaciones');  
        }
        
        this.items = [
            {
                xtype: 'hidden',
                id: 'sysIdAgendaEspecialistaBitacora'
            },
            {
                xtype: 'grid',
                id: 'gridBitacoraCitasRadicada',
                store: stGrid,
                anchor: "100%",
                height: 460,
                border: false,
                frame: true,
                stripeRows: true,
                columns:[
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'ConsecutivoBitacora',
                        id: 'ConsecutivoBitacora'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdRadicaAgendaEspecialista',
                        id: 'IdRadicaAgendaEspecialista'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha',
                        sortable: true,
                        width: 90,
                        renderer: Ext.util.Format.dateRenderer('d/m/Y'),
                        dataIndex: 'FechaRegistro',
                        id: 'FechaRegistro'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Hora',
                        sortable: true,
                        width: 90,
                        dataIndex: 'HoraRegistro',
                        id: 'HoraRegistro'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Observaciones',
                        sortable: false,
                        width: 560,
                        renderer: VerInfoBitacora,
                        dataIndex: 'Observaciones',
                        id: 'Observaciones'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario',
                        sortable: false,
                        width: 180,
                        dataIndex: 'NomUsuario',
                        id: 'NomUsuario'
                    }
                ],   
                columnLines: true,
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Adicionar Seguimiento',
                            iconCls: 'btnAddRow',
                            listeners: {
                                click : function() {
                                    AddBitacora = new winAddBitacoraUi();
                                    Ext.getCmp('sysIdCitaCXBS').setValue(Ext.getCmp('sysIdAgendaEspecialistaBitacora').getValue());
                                    Ext.getCmp('sysUsuarioBS').setValue(ID_USUARIO);
                                    AddBitacora.show();
                                }
                            }
                                    
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                }
            }
        ];
        winFrmBitacoraCitaRadicadasUi.superclass.initComponent.call(this);
    }
});

function xxxfnEliminarRegistrosCitaRadicada(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}