/*
* @category    Programacion Eventos Formulario Radicacion de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
var CodFrm = "BS00001";
var ID_EMPRESA;
var ID_SEDE;
var ID_IPS;
var ID_USUARIO;
var gCAS;
var paso1 = false;
var paso2 = false;
var paso3 = false;
var paso4 = false;
var paso5 = false;
MaximizarVentana();
winRadicacionServicios = Ext.extend(winRadicacionServiciosUi, {
    initComponent: function() {
        
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        
        this.title = NOM_APLICACION + " ©  .:: Radicación de Servicios ::.";
        
        stCliente = new StoreCliente();
        stCliente.load({params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}});
        winRadicacionServicios.superclass.initComponent.call(this);
        Ext.getCmp('fClienteLA').setValue(0);
        Ext.getCmp('fPlanLA').setValue(0);
        Ext.getCmp('fSubPlanLA').setValue(0);
        Ext.getCmp('fPacienteValido').setValue(0);
        Ext.getCmp('fIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('fIdSede').setValue(ID_SEDE);
        Ext.getCmp('fIdIPS').setValue(ID_IPS);
        Ext.getCmp('bolCrearCASxServicio').setValue(true);
        Ext.getCmp('fsRIPSAC').setVisible(false);
        Ext.getCmp('fsRIPSAP').setVisible(false);
                
        this.setPagePosition((screen.width - 1004)/2, 5);
        this.fNomEmpresa.setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        this.fNomSede.setValue("SEDE: " + Ext.get('nomsede').getValue());
        this.fNomIPS.setValue("IPS: " + Ext.get('nomips').getValue());
        this.fNomUSR.setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        this.title = Ext.get('ofiversion').getValue() + " - [Radicación de Servicios]";
        el = Ext.get('FecSistema');
        //this.fFecNac.setMaxValue(el.getValue());
        //this.fFecSol.setMaxValue(el.getValue());
        el = Ext.get('FecControl');
        //this.fFecSol.setMinValue(el.getValue());
        var fCliente = this.fCliente.on("select",this.CargaCbPlan,this);
        var fCliente1 = this.fCliente.on("change",this.ChangeCargaCbPlan,this);
        var fPlan = this.fPlan.on("select",this.CargaCbSubPlan,this);
        var fPlan1 = this.fPlan.on("change",this.ChangeCargaCbSubPlan,this);
        var fRegimen = this.fRegimen.on("select",this.ValidarRegimen,this);
        var fTafiliado = this.fTafiliado.on("select",this.ValidarParentesco,this);
        var fFecNac = this.fFecNac.on("Blur",this.MostrarEdad,this);
        var fPrograma = this.fPrograma.on("select",this.ValidarPrograma,this);
        var btnAddProfeSol = Ext.getCmp('btnAddProfeSol').on("click",this.CrearProfesionalSolicitante,this);
        var btnActualizaPac  = Ext.getCmp('btnActualizaPac').on("click",this.ActualizaInfoPaciente,this);
        var btnAyuda = this.btnAyuda.on("click",this.LlamarAyuda,this);
        var btnNuevo = this.btnNuevo.on("click",this.NuevoServicio, this);
        var btnSalir = this.btnSalir.on("click",this.Salir, this);
        var btnVerificaPacienteListado = Ext.getCmp('btnVerificaPacienteListado').on("click",this.VerificaListado,this);
        var btnRadicar = this.btnRadicar.on("click",this.GuardarDatosBasicos, this);
        var strdocpac_citas_special = Ext.getCmp('fDocID').on("specialkey",this.ValidarNumeroDocumentoPacSK,this);
        var fRango =  Ext.getCmp('fRango').on("select",this.SelectRangoSalarial,this);
        var btnBuscarPacienteRadica = Ext.getCmp('btnBuscarPacienteRadica').on("click",this.BuscarPaciente,this);
        var btnAddRegistroConcepto  = Ext.getCmp('btnAddRegistroConcepto').on("click",this.AdicionarRegistroConcepto,this);
        var btnDelRegistroConcepto  = Ext.getCmp('btnDelRegistroConcepto').on("click",this.EliminarRegistroConcepto,this);
        var sysDiagPpalHC = Ext.getCmp('sysDiagPpalHC').on("specialkey",this.searchDiagPpalHC,this);
        var sysDiagRel1HC = Ext.getCmp('sysDiagRel1HC').on("specialkey",this.searchDiagRel1HC,this);
        var sysDiagRel2HC = Ext.getCmp('sysDiagRel2HC').on("specialkey",this.searchDiagRel2HC,this);
        var sysDiagRel3HC = Ext.getCmp('sysDiagRel3HC').on("specialkey",this.searchDiagRel3HC,this);
        
        var sysDiagPpalProc = Ext.getCmp('sysDiagPpalProc').on("specialkey",this.searchDiagPpalProc,this);
        var sysDiagRel1Proc = Ext.getCmp('sysDiagRel1Proc').on("specialkey",this.searchDiagRel1Proc,this);
        var sysDiagRel2Proc = Ext.getCmp('sysDiagRel2Proc').on("specialkey",this.searchDiagRel2Proc,this);
        
        stCIE10 = new StoreCIE10();
        
        var sm_gridservicios = Ext.getCmp('gridConceptosRadicacion').getSelectionModel();
        sm_gridservicios.on("rowselect",this.UpdateDetalleSolServicio,this);
        
        el = Ext.get('Legalizar');
        gCAS = el.getValue();
        
        EstblecerCamposEnabled();
        Ext.getCmp('sysTextoEliminado').setValue("");
        Ext.getCmp('btnReactivarCAS').setVisible(false);
        Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
        
    },
    ChangeCargaCbPlan:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fContrato').store.removeAll(true);
            Ext.getCmp('fPlan').setValue(null);
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fContrato').setValue(null);
            Ext.getCmp('fContrato').disable();
        }
    },
    ChangeCargaCbSubPlan:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fSubPlan').disable();
        }
    },
    searchDiagRel2Proc: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel2Proc').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel2Proc').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel2ProcNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel2Proc').setValue('');
                Ext.getCmp('sysDiagRel2ProcNom').setValue('');
            }
        }
    },
    searchDiagRel1Proc: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel1Proc').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel1Proc').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel1ProcNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel1Proc').setValue('');
                Ext.getCmp('sysDiagRel1ProcNom').setValue('');
            }
        }
    },
    searchDiagPpalProc: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase();
            Ext.getCmp('sysDiagPpalProc').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagPpalProc').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagPpalProcNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagPpalProc').setValue('');
                Ext.getCmp('sysDiagPpalProcNom').setValue('');
            }  
        }
    },
    searchDiagRel3HC: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel3HC').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel3HC').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel3HCNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel3HC').setValue('');
                Ext.getCmp('sysDiagRel3HCNom').setValue('');
            }  
        }
    },
    searchDiagRel2HC: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel2HC').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel2HC').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel2HCNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel2HC').setValue('');
                Ext.getCmp('sysDiagRel2HCNom').setValue('');
            }  
        }
    },
    searchDiagRel1HC: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel1HC').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel1HC').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel1HCNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel1HC').setValue('');
                Ext.getCmp('sysDiagRel1HCNom').setValue('');
            }  
        }
    },
    searchDiagPpalHC: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase();
            Ext.getCmp('sysDiagPpalHC').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagPpalHC').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagPpalHCNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagPpalHC').setValue('');
                Ext.getCmp('sysDiagPpalHCNom').setValue('');
            }
        }
    },
    EliminarRegistroConcepto: function(){
        if(Ext.getCmp('gridConceptosRadicacion').selModel.getCount() == 1){
            var idrec = Ext.getCmp('gridConceptosRadicacion').selModel.getSelected();
            Ext.Msg.show({
                title: 'Conceptos',
                msg: 'Esta seguro que desea eliminar el concepto ' + idrec.data.desConcepto,
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes"){
                        Ext.getCmp('gridConceptosRadicacion').store.remove( idrec );
                     }
                }
            });
        }
    },
    AdicionarRegistroConcepto: function(){
        if(Ext.getCmp('sysIdProcedimiento').getValue() != 0 && Ext.getCmp('sysIdProcedimiento').getValue() != null){
            el = Ext.get('idaplicacion');
            var NOM_APLICACION = el.getValue();

            var winAddRegistroConcepto = new winAddRegistroConceptoItemUi();
            winAddRegistroConcepto.title = NOM_APLICACION + ' .::Adicionar Concepto::.';
            var btn_AddConceptoItem = Ext.getCmp('btn_AddConceptoItem').on("click",this.GuardarConceptoItem,this);
            var btn_SalirConceptoItem = Ext.getCmp('btn_SalirConceptoItem').on("click",this.CerrarVentanaConceptoItem,this);
            Ext.getCmp('intIdProcedimientoItem').setValue(Ext.getCmp('sysIdProcedimiento').getValue());
            Ext.getCmp('intIVAItem').setValue(0);
            Ext.getCmp('intVlrIVAItem').setValue(0);
            Ext.getCmp('intidTipoRegItem').setValue(Ext.getCmp('sysidTipoReg').getValue());
            Ext.getCmp('strCodConceptoItem').setValue(Ext.getCmp('sysCodConcepto').getValue());
            Ext.getCmp('strDesConceptoItem').setValue(Ext.getCmp('sysDesConcepto').getValue());
            Ext.getCmp('intVlrTarifaItem').setValue(Ext.getCmp('sysVlrTarifa').getValue());
            Ext.getCmp('intVlrTotalItem').setValue(Ext.getCmp('sysVlrTarifa').getValue());
            
            Ext.getCmp('intVlrCuotaModeradoraItem').setValue(0);
            Ext.getCmp('intVlrCopagoItem').setValue(0);
            Ext.getCmp('intVlrDescuentosItem').setValue(0);
            Ext.getCmp('intVlrNetoItem').setValue(Ext.getCmp('sysVlrTarifa').getValue());

            
            winAddRegistroConcepto.show();
        }else{
            Ext.Msg.show({
                title: 'Conceptos',
                msg: 'Debe seleccionar un concepto a radicar..!',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    GuardarConceptoItem: function(){
        var frm = Ext.getCmp('frmAddConceptoItem').getForm();
        if ( frm.isValid() ){
            Ext.Msg.show({
                title: 'Conceptos',
                msg: 'Esta seguro que desea adicionar el concepto',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes")
                    {
                        var recId = Ext.getCmp('gridConceptosRadicacion').store.getCount() + 1;
                        var st = new DTSConceptosRadicacion();
                        var yarealizo = 0;
                        if(Ext.getCmp('sysProfesionalAtendio').getValue() != null && Ext.getCmp('sysProfesionalAtendio').getValue() != "")
                            yarealizo = 1;
                        Ext.getCmp('gridConceptosRadicacion').store.add(new st.recordType({
                                IDReg: recId,
                                Fecha: Ext.getCmp('fecFecAtencion').getValue().format('Y/m/d'),
                                idConcepto: Ext.getCmp('intIdProcedimientoItem').getValue(),
                                codConcepto: QuitarAcentosTxt(Ext.getCmp('strCodConceptoItem').getValue()),
                                desConcepto: QuitarAcentosTxt(Ext.getCmp('strDesConceptoItem').getValue()),
                                idTipoReg: Ext.getCmp('intidTipoRegItem').getValue(),
                                vlrTarifa: Ext.getCmp('intVlrTarifaItem').getValue(),
                                Cantidad: Ext.getCmp('intCantidadItem').getValue(),
                                vlrSubTotal: Ext.getCmp('intVlrTotalItem').getValue(),
                                IVA: Ext.getCmp('intIVAItem').getValue(),
                                vlrIVA: Ext.getCmp('intVlrIVAItem').getValue(),
                                vlrCuotaModeradora: Ext.getCmp('intVlrCuotaModeradoraItem').getValue(),
                                vlrCopago: Ext.getCmp('intVlrCopagoItem').getValue(),
                                vlrDescuentos: Ext.getCmp('intVlrDescuentosItem').getValue(),
                                vlrNeto: Ext.getCmp('intVlrNetoItem').getValue(),
                                finalidadConsulta: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                                nomfinalidadConsulta: QuitarAcentosTxt(Ext.getCmp('sysFinalidadConsultaHC').getRawValue()),
                                causaExterna: Ext.getCmp('sysCausaExternaHC').getValue(),
                                nomcausaExterna: QuitarAcentosTxt(Ext.getCmp('sysCausaExternaHC').getRawValue()),
                                tipDiagnostico: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                                nomtipDiagnostico: QuitarAcentosTxt(Ext.getCmp('sysTipoDiagosticoHC').getRawValue()),
                                Ambito: Ext.getCmp('sysAmbitoProc').getValue(),
                                nomAmbito: QuitarAcentosTxt(Ext.getCmp('sysAmbitoProc').getRawValue()),
                                finalidadProcedimiento: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                                nomfinalidadProcedimiento: QuitarAcentosTxt(Ext.getCmp('sysFinalidadProcedimientoProc').getRawValue()),
                                personalAtiende: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                                nompersonalAtiende: QuitarAcentosTxt(Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getRawValue()),
                                formaRealizacion: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                                nomformaRealizacion: QuitarAcentosTxt(Ext.getCmp('sysFormaRealizaProcedimientoProc').getRawValue()),
                                idProfesional: Ext.getCmp('sysProfesionalAtendio').getValue(),
                                yaRealizado: yarealizo,
                                diagPpal: Ext.getCmp('sysDiagPpalHC').getValue(),
                                nomdiagPpal: QuitarAcentosTxt(Ext.getCmp('sysDiagPpalHCNom').getValue()),
                                diagRel1: Ext.getCmp('sysDiagRel2HC').getValue(),
                                nomdiagRel1: QuitarAcentosTxt(Ext.getCmp('sysDiagRel1HCNom').getValue()),
                                diagRel2: Ext.getCmp('sysDiagRel3HC').getValue(),
                                nomdiagRel2: QuitarAcentosTxt(Ext.getCmp('sysDiagRel2HCNom').getValue()),
                                diagRel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                                nomdiagRel3: QuitarAcentosTxt(Ext.getCmp('sysDiagRel3HCNom').getValue()),
                                diagPpalProc: Ext.getCmp('sysDiagPpalProc').getValue(),
                                nomdiagPpalProc: QuitarAcentosTxt(Ext.getCmp('sysDiagPpalProcNom').getValue()),
                                diagRel1Proc: Ext.getCmp('sysDiagRel1Proc').getValue(),
                                nomdiagRel1Proc: QuitarAcentosTxt(Ext.getCmp('sysDiagRel1ProcNom').getValue()),
                                diagRel2Proc: Ext.getCmp('sysDiagRel2Proc').getValue(),
                                nomdiagRel2Proc: QuitarAcentosTxt(Ext.getCmp('sysDiagRel2ProcNom').getValue()),
                                nomProfesional: QuitarAcentosTxt(Ext.getCmp('sysProfesionalAtendio').getRawValue())
                            })
                        );
                        Ext.getCmp('winAddRegistroConceptoItemUi').close();
                    }
                }
            });
        }else{
            Ext.Msg.show({
                title: 'Conceptos',
                msg: 'Existen campos obligatorios que están vacios..!',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CerrarVentanaConceptoItem: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winAddRegistroConceptoItemUi').close();
                }
            }
        });
    },
    BuscarRadicacionEstudios: function(){
        buscarestudios("Radicacion");
    },
    BuscarPaciente: function(){
        buscarpaciente("Radicacion");
    },
    SelectRangoSalarial: function(cmb, rec, idx) {
        Ext.getCmp('fPorCopagos').setValue(rec.data.Porcentaje);
        Ext.getCmp('fMaxCopago').setValue(rec.data.TopeEvento);
        Ext.getCmp('fvlrCuotaModeradoraIndicada').setValue(rec.data.VlrCuotaModeradora);
    },
    ValidarNumeroDocumentoPacSK: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            Ext.getCmp('fPacienteValido').setValue(0);
            Ext.getCmp('fGenero').setValue("");
            Ext.getCmp('fApe1').setValue("");
            Ext.getCmp('fApe2').setValue("");
            Ext.getCmp('fNom1').setValue("");
            Ext.getCmp('fNom2').setValue("");
            Ext.getCmp('fEdad').setValue("");
            Ext.getCmp('fDeptoMuni').setValue("");
            Ext.getCmp('fDireccion').setValue("");
            Ext.getCmp('fZona').setValue("");
            Ext.getCmp('fTel1').setValue("");
            Ext.getCmp('fTel2').setValue("");
            Ext.getCmp('fEmail').setValue("");
            Ext.getCmp('fFecNac').setValue("");
            Ext.getCmp('fEdad').setValue("");
            Ext.getCmp('fRegimen').setValue(1);
            Ext.getCmp('fTafiliado').setValue("");
            Ext.getCmp('fParentesco').setValue("");
            Ext.getCmp('fRango').setValue("");
            Ext.getCmp('fEstado').setValue("");
            Ext.getCmp('fPacienteValido').setValue(0);
            Ext.Msg.wait('Cargando Información del Paciente... por favor espere!');
            Ext.Ajax.request(
            {
                url: '../../controlador/pacientes/pacientes_cargardatos.php',
                params:{
                    pTdoc: Ext.getCmp('fTdoc').getValue(),
                    pDocumento: Ext.getCmp('fDocID').getValue()
                },
                success: function(response,options)
                {
                    var el = Ext.get('response'); 
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                        Ext.Msg.hide();
                        Ext.getCmp('fIdPaciente').setValue(0);
                        verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(),Ext.getCmp('fDocID').getValue(),true,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
                        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                            Ext.getCmp('fPacienteValido').setValue(1);
                    } else {
                        Ext.getCmp('fIdPaciente').setValue(Contenido[0]);
                        Ext.getCmp('fTdoc').setValue(Contenido[1]);
                        Ext.getCmp('fGenero').setValue(Contenido[9]);
                        Ext.getCmp('fApe1').setValue(Contenido[3]);
                        Ext.getCmp('fApe2').setValue(Contenido[4]);
                        Ext.getCmp('fNom1').setValue(Contenido[5]);
                        Ext.getCmp('fNom2').setValue(Contenido[6]);
                        Ext.getCmp('fEdad').setValue(Contenido[8]);
                        Ext.getCmp('fDeptoMuni').setValue(Contenido[15]);
                        Ext.getCmp('fDireccion').setValue(Contenido[10]);
                        Ext.getCmp('fZona').setValue(Contenido[11]);
                        Ext.getCmp('fTel1').setValue(Contenido[12]);
                        Ext.getCmp('fTel2').setValue(Contenido[13]);
                        Ext.getCmp('fEmail').setValue(Contenido[14]);
                        if(Contenido[7] != null && Contenido[7] != ""){
                            var xfecnac = Contenido[7].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
                            Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fFecNac').getValue().format('Y/m/d')));
                        }
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/pacientes/pacientes_sedeips.php',
                            params:{
                                pPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                pIPS: Ext.getCmp('fIdIPS').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null)
                                    if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                                        Ext.getCmp('fPacienteValido').setValue(1);
                                else
                                    Ext.getCmp('fPacienteValido').setValue(1);
                            },
                            failure: function(response,options){
                                if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                                    Ext.getCmp('fPacienteValido').setValue(1);
                            },
                            scope:this 
                        });
                        Ext.Msg.hide();
                        verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(),Ext.getCmp('fDocID').getValue(),true,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
                    }
                },
                failure: function(response,options){
                    var el = Ext.get('response');
                    alert("error al comunicarse con el servidor.");
                },
                scope:this 
            });       
        }
    },
    ActualizaInfoPaciente: function(){
        if (Ext.getCmp('fIdPaciente').getValue() != 0 && Ext.getCmp('fApe1').isValid() && Ext.getCmp('fNom1').isValid() && Ext.getCmp('fRegimen').isValid() && Ext.getCmp('fGenero').isValid() && Ext.getCmp('fFecNac').isValid() && Ext.getCmp('fDeptoMuni').isValid() && Ext.getCmp('fDireccion').isValid() && Ext.getCmp('fTel1').isValid() && Ext.getCmp('fZona').isValid() && Ext.getCmp('fTafiliado').isValid() && Ext.getCmp('fRango').isValid())
        {
            Ext.Msg.show({
                title: 'Actualizar Paciente',
                msg: 'Esta seguro que desea actualizar la información del paciente',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/pacientes/controlador_pacientes.php',
                            params:{
                                task: 'ACTUALIZAR',
                                pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                pTDoc: Ext.getCmp('fTdoc').getValue(),
                                pDocID: Ext.getCmp('fDocID').getValue(),
                                pRegimen: Ext.getCmp('fRegimen').getValue(),
                                pGenero: Ext.getCmp('fGenero').getValue(),
                                pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                pFecNac: Ext.getCmp('fFecNac').getValue().format("Y-m-d"),
                                pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                pZona: Ext.getCmp('fZona').getValue(),
                                pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                pParentesco: Ext.getCmp('fParentesco').getValue(),
                                pRango: Ext.getCmp('fRango').getValue(),
                                pEstado: Ext.getCmp('fEstado').getValue(),
                                pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                pIdSede: Ext.getCmp('fIdSede').getValue(),
                                pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                pUsuario: Ext.get('idusuario').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                    Ext.MessageBox.show({
                                        title: 'Actualizando Paciente',
                                        msg: 'Ocurrio un error al actualizar la información del paciente o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                } else {
                                    Ext.MessageBox.show({
                                        title: 'Actualizando Paciente',
                                        msg: 'Se actualizo la información del paciente con exito...!',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                }
                            },
                            failure: function(response,options){
                                Ext.MessageBox.show({
                                    title: 'Actualizando Paciente',
                                    msg: 'Ocurrio un error al actualizar la información del paciente o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            },
                            scope:this
                        });
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Actualizando Paciente',
                msg: 'El Paciente no ha sido creado o por favor verifique los datos que son requeridos para actualizar el paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    GuardarDatosBasicos: function(){
        var frm = Ext.getCmp('frmRadica').getForm();
        if ( frm.isValid() ){
            if (Ext.getCmp('fPacienteValido').getValue() == 1)
            {
                Ext.Msg.show({
                    title: 'Radicar Servicios',
                    msg: 'Esta seguro que desea Radicar la información  con los conceptos registrados',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            var recId = Ext.getCmp('gridConceptosRadicacion').store.getCount();
                            if(recId < 1)
                            {
                                Ext.MessageBox.show({
                                    title: 'Radicar Servicios',
                                    msg: 'Debe registar al menos un concepto.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }else{
                                Ext.Msg.wait('Guardando Radicación de Servicios... por favor espere!');
                                var parametrosConceptos = "";
                                Ext.getCmp('gridConceptosRadicacion').store.each(function(record){
                                    parametrosConceptos = parametrosConceptos + record.get('idTipoReg') +  "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('Fecha') +  "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('idConcepto') +  "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('codConcepto') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('desConcepto') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('vlrTarifa') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('IVA') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('vlrIVA') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('vlrCuotaModeradora') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('vlrCopago') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('vlrDescuentos') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('vlrNeto') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('finalidadConsulta') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('causaExterna') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('tipDiagnostico') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('diagPpal') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('diagRel1') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('diagRel2') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('diagRel3') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('diagPpalProc') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('diagRel1Proc') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('diagRel2Proc') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('Ambito') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('finalidadProcedimiento') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('personalAtiende') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('formaRealizacion') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('idProfesional') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('yaRealizado') + "|^|";
                                    parametrosConceptos = parametrosConceptos + record.get('IDReg');
                                    parametrosConceptos = parametrosConceptos + "|¬|";
                                });
                                if (Ext.getCmp('fCas').getValue() == 0){
                                    Ext.Ajax.request(
                                    {
                                        
                                        url: '../../controlador/radicacionservicios/guardar_radicacion_rips.php',
                                        params:{
                                            pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                            pTDoc: Ext.getCmp('fTdoc').getValue(),
                                            pDocID: Ext.getCmp('fDocID').getValue(),
                                            pRegimen: Ext.getCmp('fRegimen').getValue(),
                                            pGenero: Ext.getCmp('fGenero').getValue(),
                                            pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                            pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                            pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                            pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                            pFecNac: Ext.getCmp('fFecNac').getValue().format("Y-m-d"),
                                            pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                            pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                            pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                            pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                            pZona: Ext.getCmp('fZona').getValue(),
                                            pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                            pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                            pParentesco: Ext.getCmp('fParentesco').getValue(),
                                            pRango: Ext.getCmp('fRango').getValue(),
                                            pEstado: Ext.getCmp('fEstado').getValue(),
                                            pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                            pIdSede: Ext.getCmp('fIdSede').getValue(),
                                            pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                            pUsuario: Ext.get('idusuario').getValue(),
                                            pEdad: Ext.getCmp('fEdad').getValue(),
                                            pExento: Ext.getCmp('fExento').getValue(),
                                            pTutela: Ext.getCmp('fTutela').getValue(),
                                            pCliente: Ext.getCmp('fCliente').getValue(),
                                            pPlan: Ext.getCmp('fPlan').getValue(),
                                            pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                            pContrato: Ext.getCmp('fContrato').getValue(),
                                            pUsaListado: Ext.getCmp('fUsaListado').getValue(),
                                            pAtenderFueraListado: Ext.getCmp('fAtenderFueraListado').getValue(),
                                            pRequiereAutorizacion: Ext.getCmp('fRequiereAutorizacion').getValue(),
                                            pFacturarParticular: Ext.getCmp('fFacturarParticular').getValue(),
                                            pFacturarCopagos: Ext.getCmp('fFacturarCopagos').getValue(),
                                            pCopagoDigitado: Ext.getCmp('fCopagoDigitado').getValue(),
                                            pPorCopagos: Ext.getCmp('fPorCopagos').getValue(),
                                            pMaxCopago: Ext.getCmp('fMaxCopago').getValue(),
                                            pvlrCuotaModeradoraIndicada: Ext.getCmp('fvlrCuotaModeradoraIndicada').getValue(),
                                            pFecSol: Ext.getCmp('fFecSol').getValue().format("Y-m-d"),
                                            pPrograma: Ext.getCmp('fPrograma').getValue(),
                                            pAutorizacion: Ext.getCmp('fAutorizacion').getValue().toUpperCase(),
                                            pProfeSol: Ext.getCmp('fProfeSol').getValue(),
                                            pFinalidad: Ext.getCmp('fFinalidad').getValue(),
                                            pExentoPrograma: Ext.getCmp('fExentoPrograma').getValue(),
                                            pCrearCASxServicio: Ext.getCmp('bolCrearCASxServicio').getValue(),
                                            pConceptos: parametrosConceptos
                                        },
                                        success: function(response,options)
                                        {
                                            var Respuesta = response.responseText;
                                            var Contenido = Respuesta.split('^');
                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                Ext.getCmp('fIdPaciente').setValue(0);
                                                Ext.Msg.hide();
                                                Ext.MessageBox.show({
                                                    title: 'Guardando Paciente',
                                                    msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            } else {
                                                Ext.Msg.hide();
                                                Ext.Msg.show({
                                                    title: 'Generar Radicación de Servicios',
                                                    msg: 'Se Generaron las Radicaciones de Servicios',
                                                    buttons: Ext.Msg.OK,
                                                    icon: Ext.MessageBox.INFO
                                                });
                                                this.NuevoServicio;
                                            }
                                        },
                                        failure: function(response,options){
                                            Ext.Msg.hide();
                                            Ext.MessageBox.show({
                                                title: 'Guardando Estudio',
                                                msg: 'Ocurrio un error al generar el numero de CAS o no se pudo establecer conexión con el servidor.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        },
                                        scope:this
                                    });
                                }
                            }
                        }
                    }
                });
            }else{
                Ext.Msg.show({
                    title: 'Radicar Servicios - [Datos Básicos]',
                    msg: 'El paciente selccionado no pertenece a la IPS y no esta autorizado para este cliente atender fuera del listado de atención!',
                    buttons: Ext.Msg.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.Msg.show({
                title: 'Radicar Servicios - [Datos Básicos]',
                msg: 'Existen campos obligatorios que están vacios..!',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    VerificaListado: function(){
        if (Ext.getCmp('fTdoc').getValue() == "" || Ext.getCmp('fTdoc').getValue() == null || Ext.getCmp('fDocID').getValue() == "" || Ext.getCmp('fDocID').getValue() == null)
        {
            Ext.Msg.show({
                title: 'Verificación del Listado de Atención',
                msg: 'Debe ingresar los datos de tipo de documento y numero de documento del paciente.',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        } else {
            verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(), Ext.getCmp('fDocID').getValue(),false,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
        }
    },
    Salir: function(){
        Ext.Msg.show({
            title: 'Salir',
            msg: 'Esta seguro que desea salir del sistema de radicación de servicios',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    NuevoServicio: function(){
        EsValido = false;
        Ext.Msg.show({
            title: 'Nuevo Registro',
            msg: 'Esta seguro que desea hacer un nuevo registro, si hace este se perdera la información ingresada hasta ahora',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmRadica').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    
                    Ext.getCmp('fIdPaciente').setValue(0);
                    Ext.getCmp('fCliente').clearValue();
                    Ext.getCmp('fPlan').clearValue();
                    Ext.getCmp('fSubPlan').clearValue();
                    Ext.getCmp('fContrato').clearValue();
                    Ext.getCmp('fCliente').setValue(null);
                    Ext.getCmp('fPlan').setValue(null);
                    Ext.getCmp('fSubPlan').setValue(null);
                    Ext.getCmp('fContrato').setValue(null);
                    Ext.getCmp('fPlan').store.removeAll(true);
                    Ext.getCmp('fSubPlan').store.removeAll(true);
                    Ext.getCmp('fContrato').store.removeAll(true);
                    Ext.getCmp('fClienteLA').setValue(0);
                    Ext.getCmp('fPlanLA').setValue(0);
                    Ext.getCmp('fSubPlanLA').setValue(0);
                    Ext.getCmp('fCliente').store.load({
                        params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}
                    });
                    Ext.getCmp('fPlan').disable();
                    Ext.getCmp('fSubPlan').disable();
                    Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                    Ext.getCmp('fEstadoCAS').setValue("");
                    Ext.getCmp('fFecRadicado').setValue("");
                    Ext.getCmp('fPacienteValido').setValue(0);
                    paso1 = false;
                    paso2 = false;
                    paso3 = false;
                    paso4 = false;
                    paso5 = false;
                    Ext.getCmp('fYaLegalizado').setValue(0);
                    Ext.getCmp('fYaLiquidado').setValue(0);
                    Ext.getCmp('fCas').setValue(0);
                    Ext.getCmp('fModificaCAS').setValue(1);
                    Ext.getCmp('gridConceptosRadicacion').store.removeAll();
                    EstblecerCamposEnabled();
                    Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
                }
            }
        });
    },
    LlamarAyuda : function(){
        MostrarAyuda(CodFrm);
    },
    UpdateDetalleSolMx: function(sm, rowIdx, r) {
        this.pnDetalleMx.update(r.data);
    },
    UpdateDetalleSolServicio: function(sm, rowIdx, r) {
        Ext.getCmp('pnDetalleServicio').update(r.data);
    },
    CrearProfesionalSolicitante: function() {
        var winProfeSol = new winProfeSolUi();
        winProfeSol.title = 'eOfiClinic .::Adicionar Profesional Solicitante::.';
        Ext.getCmp('btn_AdicionarProfeSol').setVisible(true);
        Ext.getCmp('btn_ModificarProfeSol').setVisible(false);
        Ext.getCmp('sysUsuario').setVisible(false);
        Ext.getCmp('sysFechaAct').setVisible(false);
        Ext.getCmp('intUsuario').setValue(ID_USUARIO);
        winProfeSol.show();
    },
    ValidarPrograma: function(cmb, rec, idx) {
        this.fFinalidad.setValue(rec.data.Finalidad);
        this.fExentoPrograma.setValue(rec.data.Exento);
    },
    MostrarEdad: function(f) {
        Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
    },
    ValidarParentesco: function(cmb, rec, idx) {
        if (cmb.getValue() != "C" && cmb.getValue() != "N"){
            this.fParentesco.enable();
            this.fParentesco.allowBlank = false;
        }else{
            this.fParentesco.clearValue();
            this.fParentesco.allowBlank = true;
            this.fParentesco.disable();
        }
    },
    ValidarRegimen: function(cmb, rec, idx) {
        this.fTafiliado.clearValue();
        this.fTafiliado.store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
        this.fRango.clearValue();
        this.fRango.store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
    },
    CargaCbPlan: function(cmb, rec, idx) {
        this.fUsaListado.setValue(rec.data.UsaListadoAtencion);
        this.fAtenderFueraListado.setValue(rec.data.AtenderFueraListado);
        this.fRequiereAutorizacion.setValue(rec.data.RequiereAutorizacion);
        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1 && Ext.getCmp('fPacienteValido').getValue() == 0)
            Ext.getCmp('fPacienteValido').setValue(1);
        if (rec.data.RequiereAutorizacion == "1"){
            this.fAutorizacion.enable();
            this.fAutorizacion.allowBlank = false;
        }else{
            this.fAutorizacion.allowBlank = true;
            this.fAutorizacion.setValue(null);
            this.fAutorizacion.clearInvalid();
            this.fAutorizacion.disable();
        }
        this.fFacturarParticular.setValue(rec.data.FacturarParticular);
        Ext.getCmp('fFacturarCopagos').setValue(rec.data.FacturarCopagos);
        Ext.getCmp('fCopagoDigitado').setValue(rec.data.CopagoDigitado);
        this.fUsaAuditoria.setValue(rec.data.UsaAuditoria);
        Ext.Ajax.request(
        {
            url: '../../controlador/conceptos/matrizconceptosxcliente.php',
            params:{
                pIdTabla: "USR_" + ID_USUARIO,
                pCliente: cmb.getValue(),
                pIPS: ID_IPS,
                pEsParticular: rec.data.FacturarParticular,
                pUsaAuditoria: rec.data.UsaAuditoria
            },
            success: function(response,options){
                //alert("otro");
                if(Ext.getCmp('fCas').getValue() != 0)
                {
                    Ext.Ajax.request(
                    {
                        url: '../../controlador/radicacionservicios/liquidarorden.php',
                        params:{
                            pCAS: Ext.getCmp('fCas').getValue(),
                            pIdTabla: "USR_" + ID_USUARIO
                        },
                        success: function(response,options){
                            //alert(Ext.getCmp('fCopagoDigitado').getValue());
                            if (Ext.getCmp('fCopagoDigitado').getValue() == 0)
                            {
                                Ext.Ajax.request(
                                {
                                    url: '../../controlador/radicacionservicios/calcularcopagos.php',
                                    params:{
                                        pCAS: Ext.getCmp('fCas').getValue(),
                                        pPorcentajeCopago: Ext.getCmp('fPorCopagos').getValue(),
                                        pMaxCopago: Ext.getCmp('fMaxCopago').getValue(),
                                        pVlrRango: Ext.getCmp('fvlrCuotaModeradoraIndicada').getValue(),
                                        pTipoAfiliado: Ext.getCmp('fTafiliado').getValue(),
                                        pFacturarPart: Ext.getCmp('fFacturarParticular').getValue(),
                                        pFacturaCopago: Ext.getCmp('fFacturarCopagos').getValue(),
                                        pExento: Ext.getCmp('fExentoPrograma').getValue()
                                    },
                                    success: function(response,options){
                                        Ext.getCmp('gridServicios').store.load({
                                            params: {
                                                pCAS: Ext.getCmp('fCas').getValue()
                                            }
                                        });
                                    },
                                    scope:this 
                                });
                            }
                        },
                        scope:this 
                    });
                }
            },
            failure: function(response,options){
                Ext.MessageBox.show({
                    title: 'Cargando Matriz de Conceptos',
                    msg: 'Ocurrio un error al al cargar la matriz de conceptos o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            },
            scope:this
        });
        //jorge
        this.fPlan.clearValue();
        this.fSubPlan.clearValue();
        this.fContrato.clearValue();
        Ext.getCmp('fPlan').store.removeAll(true);
        Ext.getCmp('fSubPlan').store.removeAll(true);
        Ext.getCmp('fContrato').store.removeAll(true);
        this.fPlan.store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        this.fPlan.enable();
        this.fContrato.store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        this.fContrato.enable();
        if (Ext.getCmp('fClienteLA').getValue() == 0)
            this.fEstado.clearValue();
        if (this.fUsaListado.getValue() == "1"){
            this.fEstado.enable();
            this.fEstado.allowBlank = false;
        } else {
            this.fEstado.disable();
            this.fEstado.allowBlank = true;
        }
        
    },
    CargaCbSubPlan: function(cmb, rec, idx) {
        this.fSubPlan.clearValue();
        Ext.getCmp('fSubPlan').store.removeAll(true);
        //alert(Ext.getCmp('fSubPlanLA').getValue());
        //if (Ext.getCmp('fSubPlanLA').getValue() == 0)
        //{
            this.fSubPlan.store.load({
                params: { 'pPlan': cmb.getValue() }
            });
        //}
        this.fSubPlan.enable();
    }
});

function EstblecerCamposEnabled(){
    Ext.getCmp('fTdoc').enable();
    Ext.getCmp('fDocID').enable();
    Ext.getCmp('fRegimen').enable();
    Ext.getCmp('fGenero').enable();
    Ext.getCmp('fApe1').enable();
    Ext.getCmp('fApe2').enable();
    Ext.getCmp('fNom1').enable();
    Ext.getCmp('fNom2').enable();
    Ext.getCmp('fFecNac').enable();
    Ext.getCmp('fDeptoMuni').enable();
    Ext.getCmp('fDireccion').enable();
    Ext.getCmp('fTel1').enable();
    Ext.getCmp('fTel2').enable();
    Ext.getCmp('fZona').enable();
    Ext.getCmp('fEmail').enable();
    Ext.getCmp('fTafiliado').enable();
    Ext.getCmp('fRango').enable();
    Ext.getCmp('fCliente').enable();
    Ext.getCmp('fFecSol').enable();
    Ext.getCmp('fPrograma').enable();
    Ext.getCmp('fProfeSol').enable();
}

function EstblecerCamposDisabled(){
    Ext.getCmp('fTdoc').disable();
    Ext.getCmp('fDocID').disable();
    Ext.getCmp('fRegimen').disable();
    Ext.getCmp('fGenero').disable();
    Ext.getCmp('fApe1').disable();
    Ext.getCmp('fApe2').disable();
    Ext.getCmp('fNom1').disable();
    Ext.getCmp('fNom2').disable();
    Ext.getCmp('fFecNac').disable();
    Ext.getCmp('fDeptoMuni').disable();
    Ext.getCmp('fDireccion').disable();
    Ext.getCmp('fTel1').disable();
    Ext.getCmp('fTel2').disable();
    Ext.getCmp('fZona').disable();
    Ext.getCmp('fEmail').disable();
    Ext.getCmp('fTafiliado').disable();
    Ext.getCmp('fRango').disable();
    Ext.getCmp('fCliente').disable();
    Ext.getCmp('fFecSol').disable();
    Ext.getCmp('fPrograma').disable();
    Ext.getCmp('fProfeSol').disable();
}

function fnBorrarConcepto(wConsecutivoDetale)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
        params:{
            PROCESO: 'EliminarConcepto',
            pConsecutivoDetalle: wConsecutivoDetale
        },
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    Ext.getCmp('gridServicios').store.reload();
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'Se elimino con exito el concepto seleccionado',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}