/*
* @category    Formulario Tasa Cambio
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/



winFrmTasaCambioUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Tasa de Cambio ::.',
    id: 'winFrmTasaCambio',
    closable:false,
    width:980,
    //height:280,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
                
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmTasaCambio',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Tasa Cambio',
                        name: 'Tasa Cambio',
                        emptyText: '$',
                        width: 150,
                        minValue: 0,
                        allowBlank: true,
                        id: 'intTasaCambio'
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        fieldLabel: 'Fecha Aplicacion',
                        name: 'Fecha',
                        allowBlank: false,
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        value: new Date().format('Y-m-d'),
                        id: 'sysFecha'
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnEditarAgenda',
                            text: 'Cambiar Cambio',
                            id: 'btnUnificar'
                        }
                    ]
                }
            }
        ];
        winFrmTasaCambioUi.superclass.initComponent.call(this);
    }
});
