/*
* @category    Formulario Cambiar Entidad
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmCambiarEntidadUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Cambiar Entidad x CAS ::.',
    id: 'winFrmCambiarEntidad',
    closable:false,
    width:980,
    //height:280,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
                
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmModificarEntidad',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysCASCambiarFechaRadica'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Paciente - CAS',
                                width: 790,
                                readOnly: true,
                                allowBlank: false,
                                emptyText: 'Seleccione....',
                                id: 'fPacienteCambiarFechaRadica'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar CAS',
                                id: 'btnBuscarPacienteUnificaMalo'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cliente',
                                width: 260,
                                allowBlank: false,
                                store: 'StoreCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Cliente....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysIdCliente',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(cmb.getValue() == null || cmb.getValue() == ""){
                                            Ext.getCmp('sysIdPlan').store.removeAll(true);
                                            Ext.getCmp('sysIdSubPlan').store.removeAll(true);
                                            Ext.getCmp('sysIdContrato').store.removeAll(true);
                                            Ext.getCmp('sysIdPlan').setValue(null);
                                            Ext.getCmp('sysIdSubPlan').setValue(null);
                                            Ext.getCmp('sysIdPlan').disable();
                                            Ext.getCmp('sysIdSubPlan').disable();
                                            Ext.getCmp('sysIdContrato').disable();
                                            
                                        }else{
                                            Ext.getCmp('sysIdPlan').store.removeAll(true);
                                            Ext.getCmp('sysIdSubPlan').store.removeAll(true);
                                            Ext.getCmp('sysIdContrato').store.removeAll(true);
                                            Ext.getCmp('sysIdPlan').setValue(null);
                                            Ext.getCmp('sysIdSubPlan').setValue(null);
                                            Ext.getCmp('sysIdSubPlan').disable();
                                            Ext.getCmp('sysIdPlan').store.load({
                                                params:{
                                                    pCliente: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('sysIdPlan').enable();
                                                }
                                            });
                                            Ext.getCmp('sysIdContrato').store.load({
                                                params:{
                                                    pCliente: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('sysIdContrato').enable();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Plan:'
                            },
                            {
                                xtype: 'combo',
                                width: 135,
                                listWidth: 250,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClientesPlan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysIdPlan',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(cmb.getValue() == null || cmb.getValue() == ""){
                                            Ext.getCmp('sysIdSubPlan').store.removeAll(true);
                                            Ext.getCmp('sysIdSubPlan').setValue(null);
                                            Ext.getCmp('sysIdSubPlan').disable();
                                        }else{
                                            Ext.getCmp('sysIdSubPlan').store.removeAll(true);
                                            Ext.getCmp('sysIdSubPlan').store.load({
                                                params:{
                                                    pPlan: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('sysIdSubPlan').enable();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'displayfield',
                                value: 'SubPlan:'
                            },
                            {
                                xtype: 'combo',
                                width: 135,
                                listWidth: 250,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClienteSubplan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdSubPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysIdSubPlan'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Contrato:'
                            },
                            {
                                xtype: 'combo',
                                width: 133,
                                listWidth: 250,
                                allowBlank: false,
                                disabled: true,
                                store: 'StoreClienteContrato',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdContrato',
                                displayField: 'Contrato',
                                emptyText: 'Seleccione Contrato....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysIdContrato'
                            }
                        ]
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnEditarAgenda',
                            text: 'Cambiar Entidad',
                                id: 'btnUnificar'
                        }
                    ]
                }
            }
        ];
        winFrmCambiarEntidadUi.superclass.initComponent.call(this);
    }
});
