/*
* @category    Formulario Registro de Concepto a Radicar
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddRegistroConceptoItemUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Conceptos a Radicar ::.',
    width: 980,
    height: 630,
    autoScroll: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAddRegistroConceptoItemUi',
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddConceptoItem',
                padding: 10,
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Concepto',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddConceptoItem'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirConceptoItem'
                        }
                    ]
                },
                items: [
                    {
                        html:'<img src="../../../resources/varios/conceptomed.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        anchor: '100%',
                        labelWidth: 125,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdProcedimientoItem',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIVAItem',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intVlrIVAItem',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intidTipoRegItem',
                                value: 0
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Concepto',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        readOnly: true,
                                        width: 100,
                                        allowBlank: false,
                                        style: 'color: #0000cc; font-weight: bold;',
                                        id: 'strCodConceptoItem'
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 650,
                                        height: 50,
                                        fieldLabel: 'Descripción',
                                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                        id: 'strDesConceptoItem'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Vlr Tarifa',
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrTarifaItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intVlrTarifaItem').getValue()==null || Ext.getCmp('intVlrTarifaItem').getValue()==""){
                                                        TARIFA = 0;  
                                                        Ext.getCmp('intVlrTarifaItem').setValue(0);
                                                    }
                                                    NET = TARIFA + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Vlr Cuota Moderadora:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrCuotaModeradoraItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intVlrCuotaModeradoraItem').getValue()==null || Ext.getCmp('intVlrCuotaModeradoraItem').getValue()==""){
                                                        CM = 0;  
                                                        Ext.getCmp('intVlrCuotaModeradoraItem').setValue(0);
                                                    }
                                                    NET = TARIFA + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Vlr Copago:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrCopagoItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intVlrCopagoItem').getValue()==null || Ext.getCmp('intVlrCopagoItem').getValue()==""){
                                                        COP = 0;  
                                                        Ext.getCmp('intVlrCopagoItem').setValue(0);
                                                    }
                                                    NET = TARIFA + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Vlr Descuentos',
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrDescuentosItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intVlrDescuentosItem').getValue()==null || Ext.getCmp('intVlrDescuentosItem').getValue()==""){
                                                        DES = 0;  
                                                        Ext.getCmp('intVlrDescuentosItem').setValue(0);
                                                    }
                                                    NET = TARIFA + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Vlr Neto:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        readOnly: true,
                                        id: 'intVlrNetoItem'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Fecha Atención',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Atención',
                                        width: 130,
                                        allowBlank: false,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFecAtencion'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Profesional:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width:550,
                                        allowBlank: true,
                                        store: 'StoreProfesionales',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Profesional....',
                                        submitValue: true,
                                        id: 'sysProfesionalAtendio'
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'RIPS CONSULTAS - AC',
                                layout: 'form',
                                width: 890,
                                autoHeight: true,
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                id: 'fsRIPSAC',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Diagnostico Principal',
                                                width:700,
                                                name: 'Diagnostico Principal',
                                                allowBlank: false,
                                                store: 'StoreCIE10',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Diagnostico....',
                                                submitValue: true,
                                                id: 'sysDiagPpalHC'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Principal',
                                                id: 'btnSearchDiagPpalHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagPpalHC');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                name: 'Diagnostico Relacionado1',
                                                width:700,
                                                allowBlank: true,
                                                store: 'StoreCIE10',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Diagnostico....',
                                                submitValue: true,
                                                id: 'sysDiagRel1HC'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                id: 'btnSearchDiagRel1HC',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagRel1HC');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                name: 'Diagnostico Relacionado Nro2',
                                                width:700,
                                                allowBlank: true,
                                                store: 'StoreCIE10',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Diagnostico....',
                                                submitValue: true,
                                                id: 'sysDiagRel2HC'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                id: 'btnSearchDiagRel2HC',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagRel2HC');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                name: 'Diagnostico Relacionado Nro3',
                                                width:700,
                                                allowBlank: true,
                                                store: 'StoreCIE10',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Diagnostico....',
                                                submitValue: true,
                                                id: 'sysDiagRel3HC'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                id: 'btnSearchDiagRel3HC',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagRel3HC');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo de Diagnostico',
                                        width:700,
                                        name: 'Tipo de Diagnostico',
                                        allowBlank: false,
                                        store: 'StoreTipoDiagnostico',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'sysTipoDiagosticoHC'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Finalidad Consulta',
                                        width:700,
                                        name: 'Finalidad Consulta',
                                        allowBlank: false,
                                        store: 'StoreFinalidadConsulta',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        value: 10,
                                        id: 'sysFinalidadConsultaHC'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Causa Externa',
                                        width:700,
                                        name: 'Causa Externa',
                                        allowBlank: false,
                                        store: 'StoreCausaExterna',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        value: 13,
                                        id: 'sysCausaExternaHC'
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'RIPS PROCEDIMIENTOS - AP',
                                layout: 'form',
                                width: 890,
                                autoHeight: true,
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                id: 'fsRIPSAP',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Diagnostico Principal',
                                                width:700,
                                                name: 'Diagnostico Principal',
                                                allowBlank: false,
                                                store: 'StoreCIE10',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Diagnostico....',
                                                submitValue: true,
                                                id: 'sysDiagPpalProc'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Principal',
                                                id: 'btnSearchDiagPpalProc',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagPpalProc');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Diagnostico Relacionado',
                                                width:700,
                                                name: 'Diagnostico Relacionado',
                                                allowBlank: true,
                                                store: 'StoreCIE10',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Diagnostico....',
                                                submitValue: true,
                                                id: 'sysDiagRel1Proc'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Relacionado',
                                                id: 'btnSearchDiagRel1Proc',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagRel1Proc');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Diagnostico Complicación',
                                                width:700,
                                                name: 'Diagnostico Complicación',
                                                allowBlank: true,
                                                store: 'StoreCIE10',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Diagnostico....',
                                                submitValue: true,
                                                id: 'sysDiagRel2Proc'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Diagnostico Complicación',
                                                id: 'btnSearchDiagRel1Proc',
                                                listeners:{
                                                    click : function(){
                                                        buscarcie10('sysDiagRel2Proc');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Ambito',
                                        width:700,
                                        name: 'Ambito',
                                        allowBlank: false,
                                        store: 'StoreAmbitoProcedimiento',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        value: 1,
                                        id: 'sysAmbitoProc'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Finalidad Procedimiento',
                                        width:700,
                                        name: 'Finalidad Procedimiento',
                                        allowBlank: false,
                                        store: 'StoreFinalidadProcedimiento',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'sysFinalidadProcedimientoProc'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Personal Atiende',
                                        width:700,
                                        name: 'Personal Atiende',
                                        allowBlank: false,
                                        store: 'StorePersonalAtiendeProcedimiento',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'sysPersonalAtiendeProcedimientoProc'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Forma Realización Acto Quirúrgico',
                                        width:700,
                                        name: 'Forma Realización Acto Quirúrgico',
                                        allowBlank: false,
                                        store: 'StoreFormaRealizacionProcedimiento',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        value: 1,
                                        id: 'sysFormaRealizaProcedimientoProc'
                                    }
                                ]
                            }/*,
                            {
                                xtype: 'fieldset',
                                title: 'RIPS OTROS CONCEPTOS - AT',
                                layout: 'form',
                                width: 890,
                                autoHeight: true,
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                id: 'fsRIPSAT',
                                items: [
                                ]
                            }*/
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ]
                
            }
        ];
        winAddRegistroConceptoItemUi.superclass.initComponent.call(this);
    }
});
