/*
* @category    Formulario Registro de Concepto a Radicar
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddRegistroConceptoItemUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Conceptos a Radicar ::.',
    width: 980,
    autoHeight: true,
    autoScroll: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAddRegistroConceptoItemUi',
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddConceptoItem',
                padding: 10,
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Concepto',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddConceptoItem'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirConceptoItem'
                        }
                    ]
                },
                items: [
                    {
                        html:'<img src="../../../resources/varios/conceptomed.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        anchor: '100%',
                        labelWidth: 125,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdProcedimientoItem',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIVAItem',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intVlrIVAItem',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intidTipoRegItem',
                                value: 0
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Concepto',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        readOnly: true,
                                        width: 100,
                                        allowBlank: false,
                                        style: 'color: #0000cc; font-weight: bold;',
                                        id: 'strCodConceptoItem'
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 650,
                                        height: 50,
                                        fieldLabel: 'Descripción',
                                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                        id: 'strDesConceptoItem'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Vlr Tarifa',
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        width: 110,
                                        id: 'intVlrTarifaItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = parseFloat(Ext.getCmp('intVlrTotalItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intVlrTarifaItem').getValue()==null || Ext.getCmp('intVlrTarifaItem').getValue()==""){
                                                        TARIFA = 0;  
                                                        Ext.getCmp('intVlrTarifaItem').setValue(0);
                                                    }
                                                    SUBTOT = TARIFA * CANT;
                                                    NET = SUBTOT + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Cantidad:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        minValue: 1,
                                        width: 30,
                                        value: 1,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intCantidadItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = parseFloat(Ext.getCmp('intVlrTotalItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intCantidadItem').getValue()==null || Ext.getCmp('intCantidadItem').getValue()==""){
                                                        CM = 0;  
                                                        Ext.getCmp('intCantidadItem').setValue(1);
                                                    }
                                                    SUBTOT = TARIFA * CANT;
                                                    NET = SUBTOT + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Subtotal:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        width: 110,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrTotalItem',
                                        readOnly: true
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Vlr Cuota Moderadora:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        width: 80,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrCuotaModeradoraItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = parseFloat(Ext.getCmp('intVlrTotalItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intVlrCuotaModeradoraItem').getValue()==null || Ext.getCmp('intVlrCuotaModeradoraItem').getValue()==""){
                                                        CM = 0;  
                                                        Ext.getCmp('intVlrCuotaModeradoraItem').setValue(0);
                                                    }
                                                    SUBTOT = TARIFA * CANT;
                                                    NET = SUBTOT + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Vlr Copago:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        width: 110,
                                        id: 'intVlrCopagoItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = parseFloat(Ext.getCmp('intVlrTotalItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intVlrCopagoItem').getValue()==null || Ext.getCmp('intVlrCopagoItem').getValue()==""){
                                                        COP = 0;  
                                                        Ext.getCmp('intVlrCopagoItem').setValue(0);
                                                    }
                                                    SUBTOT = TARIFA * CANT;
                                                    NET = SUBTOT + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Vlr Descuentos',
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        width: 110,
                                        id: 'intVlrDescuentosItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = parseFloat(Ext.getCmp('intVlrTotalItem').getValue());
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intVlrIVAItem').getValue());
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var NET = 0;
                                                    if(Ext.getCmp('intVlrDescuentosItem').getValue()==null || Ext.getCmp('intVlrDescuentosItem').getValue()==""){
                                                        DES = 0;  
                                                        Ext.getCmp('intVlrDescuentosItem').setValue(0);
                                                    }
                                                    SUBTOT = TARIFA * CANT;
                                                    NET = SUBTOT + IVA - CM - COP - DES;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Vlr Neto:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        readOnly: true,
                                        id: 'intVlrNetoItem'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Fecha Atención',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Atención',
                                        width: 130,
                                        allowBlank: false,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFecAtencion'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Profesional:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width:550,
                                        allowBlank: true,
                                        store: 'StoreProfesionales',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Profesional....',
                                        submitValue: true,
                                        id: 'sysProfesionalAtendio'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ]
                
            }
        ];
        winAddRegistroConceptoItemUi.superclass.initComponent.call(this);
    }
});
