/*
* @category    Programacion Eventos Formulario Radicacion de Servicios Anatomopatologia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
var CodFrm = "BS00001";
var ID_EMPRESA;
var ID_SEDE;
var ID_IPS;
var ID_USUARIO;
var gCAS;
var paso1 = false;
var paso2 = false;
var paso3 = false;
var paso4 = false;
var paso5 = false;
MaximizarVentana();
winRadicacionServiciosAnatomopatologia = Ext.extend(winRadicacionServiciosAnatomopatologiaUi, {
    initComponent: function() {
        
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        
        this.title = NOM_APLICACION + " ©  .:: Radicación de Servicios Anatomopatologia ::.";
        
        stCliente = new StoreCliente();
        stCliente.load({params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}});
        winRadicacionServiciosAnatomopatologia.superclass.initComponent.call(this);
        Ext.getCmp('fClienteLA').setValue(0);
        Ext.getCmp('fPlanLA').setValue(0);
        Ext.getCmp('fSubPlanLA').setValue(0);
        Ext.getCmp('fPacienteValido').setValue(0);
        Ext.getCmp('fIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('fIdSede').setValue(ID_SEDE);
        Ext.getCmp('fIdIPS').setValue(ID_IPS);
        Ext.getCmp('bolCrearCASxServicio').setValue(true);
                
        this.setPagePosition((screen.width - 1004)/2, 5);
        this.fNomEmpresa.setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        this.fNomSede.setValue("SEDE: " + Ext.get('nomsede').getValue());
        this.fNomIPS.setValue("IPS: " + Ext.get('nomips').getValue());
        this.fNomUSR.setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        this.title = Ext.get('ofiversion').getValue() + " - [Radicación de Servicios Anatomopatologia]";
        el = Ext.get('FecSistema');
        el = Ext.get('FecControl');
        var fCliente = Ext.getCmp('fCliente').on("select",this.CargaCbPlan,this);
        var fCliente1 = Ext.getCmp('fCliente').on("change",this.ChangeCargaCbPlan,this);
        var fPlan = Ext.getCmp('fPlan').on("select",this.CargaCbSubPlan,this);
        var fPlan1 = Ext.getCmp('fPlan').on("change",this.ChangeCargaCbSubPlan,this);
        var fRegimen = Ext.getCmp('fRegimen').on("select",this.ValidarRegimen,this);
        var fTafiliado = Ext.getCmp('fTafiliado').on("select",this.ValidarParentesco,this);
        var fFecNac = Ext.getCmp('fFecNac').on("Blur",this.MostrarEdad,this);
        var fPrograma = Ext.getCmp('fPrograma').on("select",this.ValidarPrograma,this);
        var btnAddProfeSol = Ext.getCmp('btnAddProfeSol').on("click",this.CrearProfesionalSolicitante,this);
        var btnActualizaPac  = Ext.getCmp('btnActualizaPac').on("click",this.ActualizaInfoPaciente,this);
        var btnAyuda = Ext.getCmp('btnAyuda').on("click",this.LlamarAyuda,this);
        var btnNuevo = Ext.getCmp('btnNuevo').on("click",this.NuevoServicio, this);
        var btnSalir = Ext.getCmp('btnSalir').on("click",this.Salir, this);
        var btnVerificaPacienteListado = Ext.getCmp('btnVerificaPacienteListado').on("click",this.VerificaListado,this);
        var btnRadicar = Ext.getCmp('btnRadicar').on("click",this.GuardarDatosBasicos, this);
        var strdocpac_citas_special = Ext.getCmp('fDocID').on("specialkey",this.ValidarNumeroDocumentoPacSK,this);
        var fRango =  Ext.getCmp('fRango').on("select",this.SelectRangoSalarial,this);
        var btnBuscarPacienteRadica = Ext.getCmp('btnBuscarPacienteRadica').on("click",this.BuscarPaciente,this);
        
        stCIE10 = new StoreCIE10();
        el = Ext.get('Legalizar');
        gCAS = el.getValue();
        
        EstblecerCamposEnabled();
        Ext.getCmp('sysTextoEliminado').setValue("");
        Ext.getCmp('btnReactivarCAS').setVisible(false);
        Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
        
    },
    ChangeCargaCbPlan:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fContrato').store.removeAll(true);
            Ext.getCmp('intIdProcedimiento').store.removeAll(true);
            
            Ext.getCmp('intIdProcedimiento').setValue(null);
            Ext.getCmp('fPlan').setValue(null);
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fContrato').setValue(null);
            Ext.getCmp('fContrato').disable();
        }
    },
    ChangeCargaCbSubPlan:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fSubPlan').disable();
        }
    },
    BuscarPaciente: function(){
        buscarpaciente("Radicacion");
    },
    SelectRangoSalarial: function(cmb, rec, idx) {
        Ext.getCmp('fPorCopagos').setValue(rec.data.Porcentaje);
        Ext.getCmp('fMaxCopago').setValue(rec.data.TopeEvento);
        Ext.getCmp('fvlrCuotaModeradoraIndicada').setValue(rec.data.VlrCuotaModeradora);
    },
    ValidarNumeroDocumentoPacSK: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            Ext.getCmp('fPacienteValido').setValue(0);
            Ext.getCmp('fGenero').setValue("");
            Ext.getCmp('fApe1').setValue("");
            Ext.getCmp('fApe2').setValue("");
            Ext.getCmp('fNom1').setValue("");
            Ext.getCmp('fNom2').setValue("");
            Ext.getCmp('fEdad').setValue("");
            Ext.getCmp('fDeptoMuni').setValue("");
            Ext.getCmp('fDireccion').setValue("");
            Ext.getCmp('fZona').setValue("");
            Ext.getCmp('fTel1').setValue("");
            Ext.getCmp('fTel2').setValue("");
            Ext.getCmp('fEmail').setValue("");
            Ext.getCmp('fFecNac').setValue("");
            Ext.getCmp('fEdad').setValue("");
            Ext.getCmp('fRegimen').setValue(1);
            Ext.getCmp('fTafiliado').setValue("");
            Ext.getCmp('fParentesco').setValue("");
            Ext.getCmp('fRango').setValue("");
            Ext.getCmp('fEstado').setValue("");
            Ext.getCmp('fPacienteValido').setValue(0);
            Ext.Msg.wait('Cargando Información del Paciente... por favor espere!');
            Ext.Ajax.request(
            {
                url: '../../controlador/pacientes/pacientes_cargardatos.php',
                params:{
                    pTdoc: Ext.getCmp('fTdoc').getValue(),
                    pDocumento: Ext.getCmp('fDocID').getValue()
                },
                success: function(response,options)
                {
                    var el = Ext.get('response'); 
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                        Ext.Msg.hide();
                        Ext.getCmp('fIdPaciente').setValue(0);
                        verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(),Ext.getCmp('fDocID').getValue(),true,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
                        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                            Ext.getCmp('fPacienteValido').setValue(1);
                    } else {
                        Ext.getCmp('fIdPaciente').setValue(Contenido[0]);
                        Ext.getCmp('fTdoc').setValue(Contenido[1]);
                        Ext.getCmp('fGenero').setValue(Contenido[9]);
                        Ext.getCmp('fApe1').setValue(Contenido[3]);
                        Ext.getCmp('fApe2').setValue(Contenido[4]);
                        Ext.getCmp('fNom1').setValue(Contenido[5]);
                        Ext.getCmp('fNom2').setValue(Contenido[6]);
                        Ext.getCmp('fEdad').setValue(Contenido[8]);
                        Ext.getCmp('fDeptoMuni').setValue(Contenido[15]);
                        Ext.getCmp('fDireccion').setValue(Contenido[10]);
                        Ext.getCmp('fZona').setValue(Contenido[11]);
                        Ext.getCmp('fTel1').setValue(Contenido[12]);
                        Ext.getCmp('fTel2').setValue(Contenido[13]);
                        Ext.getCmp('fEmail').setValue(Contenido[14]);
                        if(Contenido[7] !== null && Contenido[7] !== "" && Contenido[7] !== "00-0-0000"){
                            var xfecnac = Contenido[7].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
                            Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fFecNac').getValue().format('Y/m/d')));
                        }
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/pacientes/pacientes_sedeips.php',
                            params:{
                                pPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                pIPS: Ext.getCmp('fIdIPS').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null)
                                    if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                                        Ext.getCmp('fPacienteValido').setValue(1);
                                else
                                    Ext.getCmp('fPacienteValido').setValue(1);
                            },
                            failure: function(response,options){
                                if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                                    Ext.getCmp('fPacienteValido').setValue(1);
                            },
                            scope:this 
                        });
                        Ext.Msg.hide();
                        verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(),Ext.getCmp('fDocID').getValue(),true,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
                    }
                },
                failure: function(response,options){
                    var el = Ext.get('response');
                    alert("error al comunicarse con el servidor.");
                },
                scope:this 
            });       
        }
    },
    ActualizaInfoPaciente: function(){
        if (Ext.getCmp('fIdPaciente').getValue() != 0 && Ext.getCmp('fApe1').isValid() && Ext.getCmp('fNom1').isValid() && Ext.getCmp('fRegimen').isValid() && Ext.getCmp('fGenero').isValid() && Ext.getCmp('fFecNac').isValid() && Ext.getCmp('fDeptoMuni').isValid() && Ext.getCmp('fDireccion').isValid() && Ext.getCmp('fTel1').isValid() && Ext.getCmp('fZona').isValid() && Ext.getCmp('fTafiliado').isValid() && Ext.getCmp('fRango').isValid())
        {
            Ext.Msg.show({
                title: 'Actualizar Paciente',
                msg: 'Esta seguro que desea actualizar la información del paciente',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes"){
                        var wFecNac = null;
                        if(Ext.getCmp('fFecNac').getValue() !== "" && Ext.getCmp('fFecNac').getValue() !== null){
                            wFecNac = Ext.getCmp('fFecNac').getValue().format("Y-m-d");
                        }
                        Ext.Ajax.request({
                            url: '../../controlador/radicaanatomopatologia/controlador_anatomopatologia.php',
                            params:{
                                task: 'ACTUALIZAR_PAC',
                                pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                pTDoc: Ext.getCmp('fTdoc').getValue(),
                                pDocID: Ext.getCmp('fDocID').getValue(),
                                pRegimen: Ext.getCmp('fRegimen').getValue(),
                                pGenero: Ext.getCmp('fGenero').getValue(),
                                pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                pFecNac: wFecNac,
                                pEdad: QuitarAcentosTxt(Ext.getCmp('fEdad').getValue().toUpperCase()),
                                pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                pZona: Ext.getCmp('fZona').getValue(),
                                pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                pParentesco: Ext.getCmp('fParentesco').getValue(),
                                pRango: Ext.getCmp('fRango').getValue(),
                                pEstado: Ext.getCmp('fEstado').getValue(),
                                pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                pIdSede: Ext.getCmp('fIdSede').getValue(),
                                pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                pUsuario: Ext.get('idusuario').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                    Ext.MessageBox.show({
                                        title: 'Actualizando Paciente',
                                        msg: 'Ocurrio un error al actualizar la información del paciente o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                } else {
                                    Ext.MessageBox.show({
                                        title: 'Actualizando Paciente',
                                        msg: 'Se actualizo la información del paciente con exito...!',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                }
                            },
                            failure: function(response,options){
                                Ext.MessageBox.show({
                                    title: 'Actualizando Paciente',
                                    msg: 'Ocurrio un error al actualizar la información del paciente o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            },
                            scope:this
                        });
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Actualizando Paciente',
                msg: 'El Paciente no ha sido creado o por favor verifique los datos que son requeridos para actualizar el paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    GuardarDatosBasicos: function(){
        var frm = Ext.getCmp('frmRadica').getForm();
        if ( frm.isValid() ){
            //if (Ext.getCmp('fPacienteValido').getValue() == 1){
                Ext.Msg.show({
                    title: 'Radicar Servicios',
                    msg: 'Esta seguro que desea Radicar la información  con los conceptos registrados',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            var wFecNac = null;
                            if(Ext.getCmp('fFecNac').getValue() !== "" && Ext.getCmp('fFecNac').getValue() !== null){
                                wFecNac = Ext.getCmp('fFecNac').getValue().format("Y-m-d");
                            }
                            Ext.Msg.wait('Guardando Radicación de Servicios... por favor espere!');
                            var parametrosConceptos = "";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysidTipoReg').getValue() +  "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('fFecSol').getValue().format("Y-m-d") +  "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysIdProcedimiento').getValue() +  "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysCodConcepto').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysDesConcepto').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('intExamen_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('strPrefijoExamen_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('strNroExamen_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('intParteCuerpo_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('strPrioridad_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('intPlacas_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('intFrascos_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('intBolsas_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('intOtros_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('strCriteriosCalidad_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('bolCumpleCriterioCalidad_conceptos').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysCantidad').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysVlrTarifa').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysIVA').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysVlrIVA').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + "0|^|";
                            parametrosConceptos = parametrosConceptos + "0|^|";
                            parametrosConceptos = parametrosConceptos + "0|^|";
                            parametrosConceptos = parametrosConceptos + Ext.getCmp('sysVlrTarifa').getValue() + "|^|";
                            parametrosConceptos = parametrosConceptos + "|¬|";
                            if (Ext.getCmp('fCas').getValue() == 0){
                                Ext.Ajax.request({
                                    url: '../../controlador/radicaanatomopatologia/controlador_anatomopatologia.php',
                                    params:{
                                        task: 'CREAR_RADICACION',
                                        pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                        pTDoc: Ext.getCmp('fTdoc').getValue(),
                                        pDocID: Ext.getCmp('fDocID').getValue(),
                                        pRegimen: Ext.getCmp('fRegimen').getValue(),
                                        pGenero: Ext.getCmp('fGenero').getValue(),
                                        pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                        pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                        pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                        pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                        pFecNac: wFecNac,
                                        pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                        pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                        pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                        pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                        pZona: Ext.getCmp('fZona').getValue(),
                                        pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                        pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                        pParentesco: Ext.getCmp('fParentesco').getValue(),
                                        pRango: Ext.getCmp('fRango').getValue(),
                                        pEstado: Ext.getCmp('fEstado').getValue(),
                                        pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                        pIdSede: Ext.getCmp('fIdSede').getValue(),
                                        pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                        pUsuario: Ext.get('idusuario').getValue(),
                                        pEdad: Ext.getCmp('fEdad').getValue(),
                                        pExento: Ext.getCmp('fExento').getValue(),
                                        pTutela: Ext.getCmp('fTutela').getValue(),
                                        pCliente: Ext.getCmp('fCliente').getValue(),
                                        pPlan: Ext.getCmp('fPlan').getValue(),
                                        pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                        pContrato: Ext.getCmp('fContrato').getValue(),
                                        pUsaListado: Ext.getCmp('fUsaListado').getValue(),
                                        pAtenderFueraListado: Ext.getCmp('fAtenderFueraListado').getValue(),
                                        pRequiereAutorizacion: Ext.getCmp('fRequiereAutorizacion').getValue(),
                                        pFacturarParticular: Ext.getCmp('fFacturarParticular').getValue(),
                                        pFacturarCopagos: Ext.getCmp('fFacturarCopagos').getValue(),
                                        pCopagoDigitado: Ext.getCmp('fCopagoDigitado').getValue(),
                                        pPorCopagos: Ext.getCmp('fPorCopagos').getValue(),
                                        pMaxCopago: Ext.getCmp('fMaxCopago').getValue(),
                                        pvlrCuotaModeradoraIndicada: Ext.getCmp('fvlrCuotaModeradoraIndicada').getValue(),
                                        pFecSol: Ext.getCmp('fFecSol').getValue().format("Y-m-d"),
                                        pPrograma: Ext.getCmp('fPrograma').getValue(),
                                        pAutorizacion: Ext.getCmp('fAutorizacion').getValue().toUpperCase(),
                                        pProfeSol: Ext.getCmp('fProfeSol').getValue(),
                                        pFinalidad: Ext.getCmp('fFinalidad').getValue(),
                                        pExentoPrograma: Ext.getCmp('fExentoPrograma').getValue(),
                                        pCrearCASxServicio: Ext.getCmp('bolCrearCASxServicio').getValue(),
                                        pConceptos: parametrosConceptos
                                    },
                                    success: function(response,options)
                                    {
                                        var Respuesta = response.responseText;
                                        var Contenido = Respuesta.split('^');
                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                            Ext.getCmp('fIdPaciente').setValue(0);
                                            Ext.Msg.hide();
                                            Ext.MessageBox.show({
                                                title: 'Guardando Paciente',
                                                msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        } else {
                                            Ext.Msg.hide();
                                            Ext.Msg.show({
                                                title: 'Generar Radicación de Servicios',
                                                msg: 'Se Genero la Radicacio de Servicios Nro. ' + Contenido[0],
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.MessageBox.INFO
                                            });
                                            //Limpiar Formularios
                                            var frm = Ext.getCmp('frmRadicaDatPac').getForm();
                                            frm.reset();
                                            frm.clearInvalid();
                                            var frm1 = Ext.getCmp('frmRadicaDatExam').getForm();
                                            frm1.reset();
                                            frm1.clearInvalid();
                                            Ext.getCmp('fIdPaciente').setValue(0);
                                            Ext.getCmp('fEstadoCAS').setValue("");
                                            Ext.getCmp('fFecRadicado').setValue("");
                                            Ext.getCmp('fPacienteValido').setValue(0);
                                            paso1 = false;
                                            paso2 = false;
                                            paso3 = false;
                                            paso4 = false;
                                            paso5 = false;
                                            Ext.getCmp('fYaLegalizado').setValue(0);
                                            Ext.getCmp('fYaLiquidado').setValue(0);
                                            Ext.getCmp('fCas').setValue(0);
                                            Ext.getCmp('fModificaCAS').setValue(0);
                                            Ext.getCmp('sysCantidad').setValue(1);
                                            EstblecerCamposEnabled();
                                            Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
                                        }
                                    },
                                    failure: function(response,options){
                                        Ext.Msg.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardando Estudio',
                                            msg: 'Ocurrio un error al generar el numero de CAS o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    },
                                    scope:this
                                });
                            }
                        }
                    }
                });
            //}else{
            //    Ext.Msg.show({
            //        title: 'Radicar Servicios - [Datos Básicos]',
            //        msg: 'Existen campos obligatorios que están vacios..!',
            //        buttons: Ext.Msg.OK,
            //        icon: Ext.MessageBox.ERROR
            //    });
            //}
        }
    },
    VerificaListado: function(){
        if (Ext.getCmp('fTdoc').getValue() == "" || Ext.getCmp('fTdoc').getValue() == null || Ext.getCmp('fDocID').getValue() == "" || Ext.getCmp('fDocID').getValue() == null)
        {
            Ext.Msg.show({
                title: 'Verificación del Listado de Atención',
                msg: 'Debe ingresar los datos de tipo de documento y numero de documento del paciente.',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        } else {
            verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(), Ext.getCmp('fDocID').getValue(),false,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
        }
    },
    Salir: function(){
        Ext.Msg.show({
            title: 'Salir',
            msg: 'Esta seguro que desea salir del sistema de radicación de servicios',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    NuevoServicio: function(){
        EsValido = false;
        Ext.Msg.show({
            title: 'Nuevo Registro',
            msg: 'Esta seguro que desea hacer un nuevo registro, si hace este se perdera la información ingresada hasta ahora',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmRadica').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    var frm1 = Ext.getCmp('frmRadicaDatPac').getForm();
                    frm1.reset();
                    frm1.clearInvalid();
                    var frm2 = Ext.getCmp('frmRadicaDatExam').getForm();
                    frm2.reset();
                    frm2.clearInvalid();
                    Ext.getCmp('fIdPaciente').setValue(0);
                    Ext.getCmp('fCliente').clearValue();
                    Ext.getCmp('fPlan').clearValue();
                    Ext.getCmp('fSubPlan').clearValue();
                    Ext.getCmp('fContrato').clearValue();
                    Ext.getCmp('fCliente').setValue(null);
                    Ext.getCmp('fPlan').setValue(null);
                    Ext.getCmp('fSubPlan').setValue(null);
                    Ext.getCmp('fContrato').setValue(null);
                    Ext.getCmp('fPlan').store.removeAll(true);
                    Ext.getCmp('fSubPlan').store.removeAll(true);
                    Ext.getCmp('fContrato').store.removeAll(true);
                    Ext.getCmp('fClienteLA').setValue(0);
                    Ext.getCmp('fPlanLA').setValue(0);
                    Ext.getCmp('fSubPlanLA').setValue(0);
                    Ext.getCmp('fCliente').store.load({
                        params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}
                    });
                    Ext.getCmp('fPlan').disable();
                    Ext.getCmp('fSubPlan').disable();
                    Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                    Ext.getCmp('fEstadoCAS').setValue("");
                    Ext.getCmp('fFecRadicado').setValue("");
                    Ext.getCmp('fPacienteValido').setValue(0);
                    paso1 = false;
                    paso2 = false;
                    paso3 = false;
                    paso4 = false;
                    paso5 = false;
                    Ext.getCmp('fYaLegalizado').setValue(0);
                    Ext.getCmp('fYaLiquidado').setValue(0);
                    Ext.getCmp('fCas').setValue(0);
                    Ext.getCmp('fModificaCAS').setValue(1);
                    Ext.getCmp('sysCantidad').setValue(1);
                    EstblecerCamposEnabled();
                    Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
                }
            }
        });
    },
    LlamarAyuda : function(){
        MostrarAyuda(CodFrm);
    },
    UpdateDetalleSolMx: function(sm, rowIdx, r) {
        this.pnDetalleMx.update(r.data);
    },
    UpdateDetalleSolServicio: function(sm, rowIdx, r) {
        Ext.getCmp('pnDetalleServicio').update(r.data);
    },
    CrearProfesionalSolicitante: function() {
        var winProfeSol = new winProfeSolUi();
        winProfeSol.title = 'eOfiClinic .::Adicionar Profesional Solicitante::.';
        Ext.getCmp('btn_AdicionarProfeSol').setVisible(true);
        Ext.getCmp('btn_ModificarProfeSol').setVisible(false);
        Ext.getCmp('sysUsuario').setVisible(false);
        Ext.getCmp('sysFechaAct').setVisible(false);
        Ext.getCmp('intUsuario').setValue(ID_USUARIO);
        winProfeSol.show();
    },
    ValidarPrograma: function(cmb, rec, idx) {
        Ext.getCmp('fFinalidad').setValue(rec.data.Finalidad);
        Ext.getCmp('fExentoPrograma').setValue(rec.data.Exento);
    },
    MostrarEdad: function(f) {
        Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
    },
    ValidarParentesco: function(cmb, rec, idx) {
        if (cmb.getValue() != "C" && cmb.getValue() != "N"){
            Ext.getCmp('fParentesco').enable();
            Ext.getCmp('fParentesco').allowBlank = false;
        }else{
            Ext.getCmp('fParentesco').clearValue();
            Ext.getCmp('fParentesco').allowBlank = true;
            Ext.getCmp('fParentesco').disable();
        }
    },
    ValidarRegimen: function(cmb, rec, idx) {
        Ext.getCmp('fTafiliado').clearValue();
        Ext.getCmp('fTafiliado').store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
        Ext.getCmp('fRango').clearValue();
        Ext.getCmp('fRango').store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
    },
    CargaCbPlan: function(cmb, rec, idx) {
        Ext.getCmp('sysIdProcedimiento').setValue(0);
        Ext.getCmp('fUsaListado').setValue(rec.data.UsaListadoAtencion);
        Ext.getCmp('fAtenderFueraListado').setValue(rec.data.AtenderFueraListado);
        Ext.getCmp('fRequiereAutorizacion').setValue(rec.data.RequiereAutorizacion);
        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1 && Ext.getCmp('fPacienteValido').getValue() == 0)
            Ext.getCmp('fPacienteValido').setValue(1);
        if (rec.data.RequiereAutorizacion == "1"){
            Ext.getCmp('fAutorizacion').enable();
            Ext.getCmp('fAutorizacion').allowBlank = false;
        }else{
            Ext.getCmp('fAutorizacion').allowBlank = true;
            Ext.getCmp('fAutorizacion').setValue(null);
            Ext.getCmp('fAutorizacion').clearInvalid();
            Ext.getCmp('fAutorizacion').disable();
        }
        Ext.getCmp('fFacturarParticular').setValue(rec.data.FacturarParticular);
        Ext.getCmp('fFacturarCopagos').setValue(rec.data.FacturarCopagos);
        Ext.getCmp('fCopagoDigitado').setValue(rec.data.CopagoDigitado);
        Ext.getCmp('fUsaAuditoria').setValue(rec.data.UsaAuditoria);
        Ext.getCmp('intIdProcedimiento').setValue(null);
        Ext.getCmp('intIdProcedimiento').store.load({
            params:{
                pIPS: ID_IPS,
                pCliente: cmb.getValue()
            }
        });
        //jorge
        Ext.getCmp('fPlan').clearValue();
        Ext.getCmp('fSubPlan').clearValue();
        Ext.getCmp('fContrato').clearValue();
        Ext.getCmp('fPlan').store.removeAll(true);
        Ext.getCmp('fSubPlan').store.removeAll(true);
        Ext.getCmp('fContrato').store.removeAll(true);
        Ext.getCmp('fPlan').store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        Ext.getCmp('fPlan').enable();
        Ext.getCmp('fContrato').store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        Ext.getCmp('fContrato').enable();
        if (Ext.getCmp('fClienteLA').getValue() == 0)
            Ext.getCmp('fEstado').clearValue();
        if (Ext.getCmp('fUsaListado').getValue() == "1"){
            Ext.getCmp('fEstado').enable();
            Ext.getCmp('fEstado').allowBlank = false;
        } else {
            Ext.getCmp('fEstado').disable();
            Ext.getCmp('fEstado').allowBlank = true;
        }
        
    },
    CargaCbSubPlan: function(cmb, rec, idx) {
        Ext.getCmp('fSubPlan').clearValue();
        Ext.getCmp('fSubPlan').store.removeAll(true);
        //alert(Ext.getCmp('fSubPlanLA').getValue());
        //if (Ext.getCmp('fSubPlanLA').getValue() == 0)
        //{
            Ext.getCmp('fSubPlan').store.load({
                params: { 'pPlan': cmb.getValue() }
            });
        //}
        Ext.getCmp('fSubPlan').enable();
    }
});

function EstblecerCamposEnabled(){
    Ext.getCmp('fTdoc').enable();
    Ext.getCmp('fDocID').enable();
    Ext.getCmp('fRegimen').enable();
    Ext.getCmp('fGenero').enable();
    Ext.getCmp('fApe1').enable();
    Ext.getCmp('fApe2').enable();
    Ext.getCmp('fNom1').enable();
    Ext.getCmp('fNom2').enable();
    Ext.getCmp('fFecNac').enable();
    Ext.getCmp('fDeptoMuni').enable();
    Ext.getCmp('fDireccion').enable();
    Ext.getCmp('fTel1').enable();
    Ext.getCmp('fTel2').enable();
    Ext.getCmp('fZona').enable();
    Ext.getCmp('fEmail').enable();
    Ext.getCmp('fTafiliado').enable();
    Ext.getCmp('fRango').enable();
    Ext.getCmp('fCliente').enable();
    Ext.getCmp('fFecSol').enable();
    Ext.getCmp('fPrograma').enable();
    Ext.getCmp('fProfeSol').enable();
}

function EstblecerCamposDisabled(){
    Ext.getCmp('fTdoc').disable();
    Ext.getCmp('fDocID').disable();
    Ext.getCmp('fRegimen').disable();
    Ext.getCmp('fGenero').disable();
    Ext.getCmp('fApe1').disable();
    Ext.getCmp('fApe2').disable();
    Ext.getCmp('fNom1').disable();
    Ext.getCmp('fNom2').disable();
    Ext.getCmp('fFecNac').disable();
    Ext.getCmp('fDeptoMuni').disable();
    Ext.getCmp('fDireccion').disable();
    Ext.getCmp('fTel1').disable();
    Ext.getCmp('fTel2').disable();
    Ext.getCmp('fZona').disable();
    Ext.getCmp('fEmail').disable();
    Ext.getCmp('fTafiliado').disable();
    Ext.getCmp('fRango').disable();
    Ext.getCmp('fCliente').disable();
    Ext.getCmp('fFecSol').disable();
    Ext.getCmp('fPrograma').disable();
    Ext.getCmp('fProfeSol').disable();
}
