/*
* @category    Formulario Grid Programas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmProgramasUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Programas ::.',
    id: 'winFrmProgramas',
    closable:false,
    width:980,
    height:600,
    plain:true,
    resizable : false,
    //y:120,
    layout: 'fit',
    initComponent: function() {
        
        var stProgramas = new StoreGridProgramas();
        var stTipoAtencion = new StoreGridTipoAtencion();
        var stProgramasPlantillas = new StoreGridProgramasPlantillas();
        var stProgramasServicios = new StoreGridProgramasServicios();
        
        this.items = [
            {
                xtype: 'panel',
                autoHeight: true,
                layout: 'table',
                layoutConfig: {
                    columns: 3
                },
                items: [
                    {
                        xtype: 'grid',
                        id: 'gridProgramas',
                        store: stProgramas,
                        title: 'Programas',
                        anchor: "100%",
                        border: false,
                        frame: true,
                        width: 400,
                        height: 558,
                        columns: [
                            {
                                xtype: 'gridcolumn',
                                header: 'IdPrograma',
                                sortable: false,
                                width: 1,
                                hidden: true,
                                hideable: false,
                                dataIndex: 'IdPrograma'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Descripcion',
                                sortable: false,
                                width: 365,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Descripcion'
                            }
                        ],
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        viewConfig: {
                            getRowClass: function(record, index) {
                                if (record.get('Activo') == '0')
                                    return 'Negado';
                                else
                                    return;
                            }
                        },
                        bbar:
                        {
                            xtype: 'toolbar',
                            items: [
                                {
                                    xtype: 'button',
                                    text: 'Adicionar Programa',
                                    iconCls: 'btnAddRow',
                                    id: 'btnAddPrograma',
                                    listeners: {
                                        click : function() {
                                            var winAddPrograma = new winAddProgramaUi();
                                            Ext.getCmp('btnModificarPrograma').setVisible(false);
                                            Ext.getCmp('btnGuardarPrograma').setVisible(true);
                                            winAddPrograma.show();
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Modificar Programa',
                                    iconCls: 'btnEditRow',
                                    id: 'btnEditPrograma',
                                    listeners: {
                                        click : function() {
                                            if(Ext.getCmp('gridProgramas').selModel.getCount() == 1){
                                                var selections = Ext.getCmp('gridProgramas').selModel.getSelections();
                                                var winAddPrograma = new winAddProgramaUi();
                                                Ext.getCmp('sysIdPrograma').setValue(selections[0].json.IdPrograma);
                                                Ext.getCmp('sysPrograma').setValue(selections[0].json.Descripcion);
                                                Ext.getCmp('sysFinalidad').setValue(selections[0].json.Finalidad);
                                                if(selections[0].json.Exento == 1){
                                                    Ext.getCmp('sysExento').setValue("SI");
                                                }else{
                                                    Ext.getCmp('sysExento').setValue("NO")
                                                }
                                                if(selections[0].json.Activo == 1){
                                                    Ext.getCmp('bolActivo').setValue("SI");
                                                }else{
                                                    Ext.getCmp('bolActivo').setValue("NO")
                                                }
                                                Ext.getCmp('btnModificarPrograma').setVisible(true);
                                                Ext.getCmp('btnGuardarPrograma').setVisible(false);
                                                winAddPrograma.show();
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    {
                        xtype: 'panel',
                        height: 558,
                        width: 560,
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridTipoAtencion',
                                store: stTipoAtencion,
                                anchor: "100%",
                                border: false,
                                frame: true,
                                width: 560,
                                height: 185,
                                loadMask: true,
                                stripeRows: true,
                                title: 'Tipo Atencion',
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Descripcion',
                                        sortable: false,
                                        width: 430,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Descripcion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Turnos',
                                        sortable: false,
                                        align: 'center',
                                        width: 90,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Turnos'
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        if (record.get('Activo') == '0')
                                            return 'Negado';
                                        else
                                            return;
                                    }
                                },
                                bbar:
                                {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'button',
                                            text: 'Adicionar Tipo Atencion',
                                            iconCls: 'btnAddRow',
                                            id: 'btnAddTipoAtencion',
                                            listeners: {
                                                click : function() {
                                                    if(Ext.getCmp('gridProgramas').selModel.getCount() == 1){
                                                    var selections = Ext.getCmp('gridProgramas').selModel.getSelections();
                                                        var winAddTipoAtencion = new winAddTipoAtencionUi();
                                                        Ext.getCmp('sysIdPrograma').setValue(selections[0].json.IdPrograma);
                                                        Ext.getCmp('btnModificarTipoAtencion').setVisible(false);
                                                        Ext.getCmp('btnGuardarTipoAtencion').setVisible(true);
                                                        winAddTipoAtencion.show();
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar Tipo Atencion',
                                            iconCls: 'btnEditRow',
                                            id: 'btnEditTipoAtencion',
                                            listeners: {
                                                click : function() {
                                                    if(Ext.getCmp('gridTipoAtencion').selModel.getCount() == 1){
                                                        var selections = Ext.getCmp('gridTipoAtencion').selModel.getSelections();
                                                        var winAddTipoAtencion = new winAddTipoAtencionUi();
                                                        Ext.getCmp('sysIdTipoAtencion').setValue(selections[0].json.IdTipoAtencion);
                                                        Ext.getCmp('sysIdPrograma').setValue(selections[0].json.IdPrograma);
                                                        Ext.getCmp('sysTipoAtencion').setValue(selections[0].json.Descripcion);
                                                        Ext.getCmp('intTurnos').setValue(selections[0].json.Turnos);
                                                        if(selections[0].json.Activo == 1){
                                                            Ext.getCmp('bolActivo').setValue("SI");
                                                        }else{
                                                            Ext.getCmp('bolActivo').setValue("NO")
                                                        }
                                                        Ext.getCmp('btnModificarTipoAtencion').setVisible(true);
                                                        Ext.getCmp('btnGuardarTipoAtencion').setVisible(false);
                                                        winAddTipoAtencion.show();
                                                    }
                                                }
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                xtype: 'grid',
                                id: 'gridProgramasPlantillas',
                                store: stProgramasPlantillas,
                                anchor: "100%",
                                border: false,
                                frame: true,
                                width: 560,
                                height: 185,
                                loadMask: true,
                                stripeRows: true,
                                title: 'Plantillas',
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Descripcion',
                                        sortable: false,
                                        width: 520,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'NomPlantilla'
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        if (record.get('Activo') == '0')
                                            return 'Negado';
                                        else
                                            return;
                                    }
                                },
                                bbar:
                                {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'button',
                                            text: 'Adicionar Plantilla',
                                            iconCls: 'btnAddRow',
                                            id: 'btnAddPlantilla',
                                            listeners: {
                                                click : function() {
                                                    if(Ext.getCmp('gridProgramas').selModel.getCount() == 1){
                                                        var selections = Ext.getCmp('gridProgramas').selModel.getSelections();
                                                        var winAddPlantillas = new winAddPlantillasUi();
                                                        Ext.getCmp('sysIdPrograma').setValue(selections[0].json.IdPrograma);
                                                        winAddPlantillas.show();
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar Plantilla',
                                            iconCls: 'btnDelRow',
                                            id: 'btnDelPlantilla',
                                            listeners: {
                                                click : function() {
                                                    if(Ext.getCmp('gridProgramasPlantillas').selModel.getCount() === 1){
                                                        var selections = Ext.getCmp('gridProgramasPlantillas').selModel.getSelections();
                                                        Ext.Msg.show({
                                                            title: 'Eliminar Plantilla',
                                                            msg: 'Esta Seguro que Desea Eliminar La Plantilla ' + selections[0].json.NomPlantilla + '?',
                                                            buttons: Ext.Msg.YESNO,
                                                            icon: Ext.Msg.QUESTION,
                                                            fn: function(btn){
                                                                if(btn ==="yes"){
                                                                    fnEliminarConcepto("../../controlador/programas/controlador_programas.php",{task: "ELIMINAR_PLANTILLAS", pIdPrograma: selections[0].json.IdPrograma, pPlantilla: selections[0].json.PlantillaHC}, 'gridProgramasPlantillas');
                                                                }
                                                            }
                                                        });
                                                    }
                                                }
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                xtype: 'grid',
                                id: 'gridProgramasServicios',
                                store: stProgramasServicios,
                                anchor: "100%",
                                border: false,
                                frame: true,
                                width: 425,
                                height: 185,
                                loadMask: true,
                                stripeRows: true,
                                title: 'Servicios',
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Descripcion',
                                        sortable: false,
                                        width: 250,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Procedimiento'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Estadio',
                                        sortable: false,
                                        width: 70,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Estadio'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Genero',
                                        sortable: false,
                                        width: 70,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Genero'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'PeriodoDias',
                                        sortable: false,
                                        width: 70,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'PeriodoDias'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Ingreso',
                                        sortable: false,
                                        width: 70,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Ingreso'
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        if (record.get('Activo') == '0')
                                            return 'Negado';
                                        else
                                            return;
                                    }
                                },
                                bbar:
                                {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'button',
                                            text: 'Adicionar Servicio',
                                            iconCls: 'btnAddRow',
                                            id: 'btnAddServicio'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar Servicio',
                                            iconCls: 'btnEditRow',
                                            id: 'btnEditServicio'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar Servicio',
                                            iconCls: 'btnDelRow',
                                            id: 'btnDelServicio'
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmProgramasUi.superclass.initComponent.call(this);
    }
});


function fnEliminarConcepto(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}