/*
* @category    Formulario Adicionar Programa
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var qExento = 0;
var qActivo = 0;

winAddProgramaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Programa ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddProgramaUi',
    initComponent: function() {
        
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddPrograma',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysIdPrograma'
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Programa',
                        name: 'Programa',
                        anchor: '100%',
                        allowBlank: false,
                        id: 'sysPrograma'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Finalidad',
                        anchor: '100%',
                        name: 'Finalidad',
                        allowBlank: false,
                        store: 'StoreFinalidadConsulta',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione....',
                        submitValue: true,
                        value: 10,
                        id: 'sysFinalidad'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Exento',
                        name: 'Exento',
                        anchor: '100%',
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'sysExento'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Activo',
                        name: 'Activo',
                        anchor: '100%',
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'bolActivo'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarPrograma',
                            listeners:{
                                click : function(){
                                    guardarPrograma();
                                }
                            }
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnModificarPrograma',
                            listeners:{
                                click : function(){
                                    
                                    modificarPrograma();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddProgramaUi.superclass.initComponent.call(this);
    }
});


function guardarPrograma(){
    Ext.Msg.show({
        title: 'Guardar Programa....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes"){
                var frm = Ext.getCmp('frmAddPrograma').getForm();
                if (frm.isValid())
                {
                    
                    if(Ext.getCmp('sysExento').getValue() == "SI" ){
                        qExento = 1;
                    }else{
                        qExento = 0;
                    }
                    if(Ext.getCmp('bolActivo').getValue() == "SI"){
                        qActivo = 1;
                    }else{
                        qActivo = 0;
                    }
                    frm.submit({
                        url: '../../controlador/programas/controlador_programas.php',
                        params: {
                            task: 'INSERTAR_PROGRAMA',
                            pPrograma: Ext.getCmp('sysPrograma').getValue(),
                            pFinalidad: Ext.getCmp('sysFinalidad').getValue(),
                            pExento: qExento,
                            pActivo: qActivo,
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Programa',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridProgramas').store.load({
                                        params: {
                                            pEmpresa: ID_EMPRESA
                                        }
                                    });
                                    Ext.getCmp('winAddProgramaUi').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Programa',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
        
}

function modificarPrograma(){
    Ext.Msg.show({
        title: 'Modificar Programa....!',
        msg: 'Esta seguro que desea Modificar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes"){
              var frm = Ext.getCmp('frmAddPrograma').getForm();
                if (frm.isValid())
                {
                    if(Ext.getCmp('sysExento').getValue() == "SI"){
                        qExento = 1;
                    }else{
                        qExento = 0;
                    }
                    if(Ext.getCmp('bolActivo').getValue() == "SI"){
                        qActivo = 1;
                    }else{
                        qActivo = 0;
                    }
                    frm.submit({
                        url: '../../controlador/programas/controlador_programas.php',
                        params: {
                            task: 'MODIFICAR_PROGRAMA',
                            pIdPrograma: Ext.getCmp('sysIdPrograma').getValue(),
                            pPrograma: Ext.getCmp('sysPrograma').getValue(),
                            pFinalidad: Ext.getCmp('sysFinalidad').getValue(),
                            pExento: qExento,
                            pActivo: qActivo,
                            pEmpresa: ID_EMPRESA,
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Programa',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridProgramas').store.load({
                                        params: {
                                            pEmpresa: ID_EMPRESA
                                        }
                                    });
                                    Ext.getCmp('winAddProgramaUi').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Modificar Programa',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}