winProgramarCxUi = Ext.extend(Ext.Container, {
    width: 985,
    height: 535,
    //x:10,
    //y:10,
    layout: 'border',
    id: 'winProgramaCx',
    border: 'false',
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        stProfesionalesxIPS = new StoreProfesionales();
        var xg = Ext.grid;
        
        var stBodegasUsuario = new StoreBodegas();
        stBodegasUsuario.load({
            params: {
                pIPS: ID_IPS,
                pUsuario: ID_USUARIO
            }
        });
		
        function VerInfoCita(value, metaData, record, rowIndex, colIndex, store){  
            reshtml = '<table border="0"><tr><td>' + record.get('TipDoc') + ' ' + record.get('Documento') + ' - ' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre')  + ' ' + record.get('PrimerApellido')  + ' ' + record.get('SegundoApellido') + '<br><hr>';
            reshtml +=  value + '</td></tr><tr><td>' + record.get('CodProced') + ' - ' + record.get('DesProced') + '</td></tr>';  
            if(record.get('CAS') !== "" && parseInt(record.get('CAS')) !== 0 && record.get('CAS') !== null){
                reshtml += '<tr><td><hr></td></tr><tr><td>CITA ASIGNADA - CAS: ' + record.get('CAS') + '</td></tr>'; 
                reshtml += '<tr><td>' + record.get('NomProfesional') + '</td></tr>'; 
                reshtml += '<tr><td>FECHA: ' + record.get('FecCita') + ' HORA: ' + record.get('HoraCita') + '</td></tr>'; 
            }
            reshtml += '<tr><td><hr>' + record.get('NomCliente') + '</br>' + record.get('NomPlan') + '</br>' + record.get('NomSubPlan') + '</td></tr>'; 
            reshtml += '</table>'; 
            return reshtml;
        }
		
        var chkColumnSeleccionarMx = new xg.CheckColumn({
            header: ' ',
            dataIndex: 'Seleccionar',
            id: 'chkColumnSeleccionarMx',
            value: false,
            width: 20
         });
     
        this.items = [
            {
                xtype: 'panel',
                title: 'Criterios de Selección',
                region: 'west',
                width: 405,
                layout: 'form',
                frame: true,
                height: 490,
                //padding: 5,
                id: 'pnCriterios',
                items: [
                    {
                        xtype: 'form',
                        title: '',
                        padding: 5,
                        border: false,
                        id: 'frmCriteriosSeleccion',
                        items: [
                            {
                                xtype: 'hidden',
                                fieldLabel: 'Empresa',
                                anchor: '100%',
                                allowBlank: true,
                                value: ID_EMPRESA,
                                id: 'intEmpresa'
                            },
                            {
                                xtype: 'hidden',
                                fieldLabel: 'Sede',
                                anchor: '100%',
                                allowBlank: true,
                                value: ID_SEDE,
                                id: 'intSede'
                            },
                            {
                                xtype: 'hidden',
                                fieldLabel: 'IPS',
                                anchor: '100%',
                                allowBlank: true,
                                value: ID_IPS,
                                id: 'intIPS'
                            },
                            {
                                xtype: 'hidden',
                                fieldLabel: 'Usuario',
                                anchor: '100%',
                                allowBlank: true,
                                value: ID_USUARIO,
                                id: 'intUsuario'
                            },
                            {
                                xtype: 'panel',
                                title: '',
                                height: 310,
                                anchor: '100%',
                                layout: 'form',
                                //frame: true,
                                border: false,
                                autoScroll: true,
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Periodo - Desde',
                                        anchor: '100%',
                                        allowBlank: true,
                                        id: 'fecDesde'
                                    },
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Periodo - Hasta',
                                        anchor: '100%',
                                        allowBlank: true,
                                        id: 'fecHasta'
                                    },
                                    {
                                        xtype: 'combo',
                                        anchor: '100%',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        title: '',
                                        fieldLabel: 'Profesional Solicitante',
                                        listWidth: 670,
                                        valueField: 'idProfeSolicitante',
                                        displayField: 'Descripcion',
                                        store: 'StoreProfeSol',
                                        triggerAction: 'all',
                                        mode: 'local',
                                        emptyText: 'Seleccione...!',
                                        allowBlank: true,
                                        id: 'intSolicitante'
                                    },
                                    {
                                        xtype: 'combo',
                                        anchor: '100%',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        title: '',
                                        fieldLabel: 'Cliente',
                                        listWidth: 450,
                                        valueField: 'IdCliente',
                                        displayField: 'Descripcion',
                                        store: 'StoreCliente',
                                        triggerAction: 'all',
                                        mode: 'local',
                                        emptyText: 'Seleccione...!',
                                        allowBlank: true,
                                        id: 'intCliente'
                                    },
                                    {
                                        xtype: 'combo',
                                        anchor: '100%',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        listWidth: 450,
                                        title: '',
                                        fieldLabel: 'Plan',
                                        store: 'StoreClientesPlan',
                                        valueField: 'IdPlan',
                                        displayField: 'Descripcion',
                                        triggerAction: 'all',
                                        mode: 'local',
                                        emptyText: 'Seleccione...!',
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'intPlan'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Sub Plan',
                                        anchor: '100%',
                                        allowBlank: true,
                                        disabled: true,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        store: 'StoreClienteSubplan',
                                        displayField: 'Descripcion',
                                        valueField: 'IdSubPlan',
                                        mode: 'local',
                                        emptyText: 'Seleccione...!',
                                        listWidth: 450,
                                        forceSelection: true,
                                        id: 'intSubPlan'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Contrato',
                                        anchor: '100%',
                                        listWidth: 450,
                                        allowBlank: true,
                                        disabled: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        store: 'StoreClienteContrato',
                                        valueField: 'IdContrato',
                                        displayField: 'Contrato',
                                        mode: 'local',
                                        emptyText: 'Selecione....',
                                        forceSelection: true,
                                        id: 'intContrato'
                                    },
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Doc. Paciente',
                                        anchor: '100%',
                                        allowBlank: true,
                                        emptyText: 'Digite Nro de Documento ID....',
                                        id: 'strPaciente'
                                    },
                                    {
                                        xtype: 'hidden',
                                        fieldLabel: 'Concepto',
                                        allowBlank: true,
                                        id: 'intIdProcedimiento'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        anchor: '100%',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                readOnly: true,
                                                width: 96,
                                                allowBlank: true,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'sysCodConcepto'
                                            },
                                            {
                                                xtype: 'textfield',
                                                readOnly: true,
                                                width: 150,
                                                height: 80,
                                                fieldLabel: 'Concepto',
                                                style: 'vertical-align:top; font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                                id: 'sysDesConcepto'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Concepto',
                                                listeners: {
                                                    click: function(){
                                                        buscarconceptoBasico('Search');
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                fbar: {
                                    xtype: 'toolbar',
                                    buttonAlign: 'center',
                                    items: [
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnReport',
                                            text: 'Filtrar Registros',
                                            id: 'idGenerarFiltro',
                                            handler: function(){
                                               var pDesde = null;
                                               var pHasta = null;
                                               if(Ext.getCmp('fecDesde').getValue() != null && Ext.getCmp('fecDesde').getValue() != ""){
                                                   pDesde = Ext.getCmp('fecDesde').getValue().format('Y-m-d');
                                               } 
                                               if(Ext.getCmp('fecHasta').getValue() != null && Ext.getCmp('fecHasta').getValue() != ""){
                                                   pHasta = Ext.getCmp('fecDesde').getValue().format('Y-m-d');
                                               } 
                                               Ext.getCmp('gridCitasxProgramar').store.load({
                                                    params: {
                                                        task: 'VER_CITASxPROGRAMAR',
                                                        pDesde: pDesde,
                                                        pHasta: pHasta,
                                                        pProfesionalSol: Ext.getCmp('intSolicitante').getValue(),
                                                        pProfesionalRem: Ext.getCmp('intSolicitante').getValue(),
                                                        pCliente: Ext.getCmp('intCliente').getValue(),
                                                        pPlan: Ext.getCmp('intPlan').getValue(),
                                                        pSubPlan: Ext.getCmp('intSubPlan').getValue(),
                                                        pContrato: Ext.getCmp('intContrato').getValue(),
                                                        pConcepto: Ext.getCmp('intIdProcedimiento').getValue(),
                                                        pDocPaciente: Ext.getCmp('strPaciente').getValue()
                                                    }
                                                });
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'panel',
                title: '<center>Programación</center>',
                region: 'center',
                padding: 5,
                frame: true,
                layout: 'form',
                items: [
                    {
                        xtype: 'combo',
                        width: 450,
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        fieldLabel: 'Enf. Jefe',
                        listWidth: 670,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionalesxIPS,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        id: 'intEnfermeraJefe'
                    },
                    {
                        xtype: 'combo',
                        width: 450,
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        fieldLabel: 'Cirujano',
                        listWidth: 670,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionalesxIPS,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        id: 'intCirujano'
                    },
                    {
                        xtype: 'combo',
                        width: 450,
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        fieldLabel: 'Anestesiologo',
                        listWidth: 670,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionalesxIPS,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        id: 'intAnestesiologo'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                fieldLabel: 'Fecha',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'fecFechaProgramacion'
                            },
                            {
                                html: ' - Hora Cx: '
                            },
                            {
                                xtype: 'timefield',
                                width: 90,
                                allowBlank: false,
                                forceSelection: false,
                                minValue: '06:00 AM',
                                maxValue: '09:00 PM',
                                emptyText: 'p.e. 07:00',
                                //format:'H:i',
                                id: 'strHoraProgramacion'
                            }
                        ]
                    },
                    {
                        xtype: 'editorgrid',
                        store: 'StoreGridHistorialCitasxProgramar',
                        height: 360,
                        flex: 1,
                        viewConfig: {
                            forceFit:true
                        },
			id: 'gridCitasxProgramar',
                        tbar: [
                            {
                                xtype: 'button',
                                iconCls: 'btnAddRow',
                                text: 'Programar Cx',
                                handler: function(){

                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnEditRow',
                                text: 'Registrar Seguimiento',
                                handler: function(){

                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ],
                        columnLines: true,
                        stripeRows: true,
                        clicksToEdit: 1,
                        cm: new xg.ColumnModel([
                            chkColumnSeleccionarMx,
                            {
                                xtype: 'gridcolumn',
                                header: 'Fecha Radicado',
                                sortable: true,
                                width: 90,
                                dataIndex: 'FechaRadicado',
                                id: 'FechaRadicado'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Especialidad',
                                sortable: false,
                                width: 570,
                                dataIndex: 'Especialidad',
                                renderer: VerInfoCita,
                                id: 'Especialidad'
                            }
                        ]),
                        plugins: [chkColumnSeleccionarMx],
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                    },
                    {
                        bbar: {
                            xtype: 'toolbar',
                            items: [
                                '->',
                                {
                                    xtype: 'button',
                                    iconCls: 'btnSalir',
                                    text: 'Salir',
                                    id: 'btnSalirMacroInformes',
                                    handler: function(){
                                        window.close();
                                    }
                                }
                            ]
                        }
                    }
                ]
            }
        ];
        winProgramarCxUi.superclass.initComponent.call(this);
    }
});
