
/*
* @category    Formulario Seleccion Plantilla HC y Apertura HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddEvolucionOfimedicalUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Apertura Proceso Programacion Cirugia ::.',
    x: ((screen.width - 1004)/2)+10,
    y: 50,
    width: 998,
    height: 610,
    modal: true,
    closable: false,
    frame: true,
    padding: 10,
    labelWidth: 150,
    autoScroll: true,
    layout: 'form',
    id: 'winAddEvolucionOfimedicalUi',
    style: 'background:transparent;',
    initComponent: function() {
        
        //var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Formulario..."});
        //myMask.show();
        var yaRadico = false;
        var stGrid = new StoreGridPlantillasHC();
        var stConceptosPaqueteServicios = new StoreConceptosxPaquete();
        
        var xg = Ext.grid;
               
        var chkColumnSeleccionarConcepto = new xg.CheckColumn({
           header: ' ',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarConcepto',
           value: false,
           width: 10
        });
        
        //var strcitaInfoAdd = new Ext.form.TextField(
         
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        var intVlrTarifaConcepto = new Ext.form.NumberField({
            minValue: 0,
            decimalPrecision: 0,
            allowBlank: false
        });
        
        stGrid.setBaseParam('pEmpresa', ID_EMPRESA);
        stGrid.load();
        this.bbar = [
            '->',
            {
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners: {
                    click : function() {
                        Ext.Msg.show({
                            title: 'eOfiClinic',
                            msg: 'Esta seguro que desea cerrar la ventana?',
                            buttons: Ext.Msg.YESNO,
                            icon: Ext.Msg.QUESTION,
                            fn: function(btn)
                            {
                                if(btn=="yes")
                                {
                                    Ext.getCmp('winAddEvolucionOfimedicalUi').close();
                                }
                            }
                        });
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'hidden',
                id: 'sysEmpresaPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysSedePlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysIPSPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysActividadPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysPlantillaPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysUsuarioPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysProfesionalPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysPacientePlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysConsecutivoDetalle_HC'
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                readOnly: true,
                id: 'sysHoraPlantillaHC'
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                readOnly: true,
                id: 'sysFechaLegalizaPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysHoraEstimadaPlantillaHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'CAS',
                id: 'sysCASPlantillaHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Profesional',
                id: 'sysNomProfesionalPlantillaHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Cliente',
                id: 'sysClientePlantillaHC'
            },
            /*
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdPlan_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdSubPlan_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdContrato_HC'
            },
            */
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Actividad Programada',
                id: 'sysActividadPlantillaHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Paciente',
                id: 'sysNomPacientePlantillaHC'
            },
            {
                xtype: 'hidden',
                readOnly: true,
                width: 96,
                allowBlank: true,
                style: 'color: #0000cc; font-weight: bold;',
                id: 'sysCodConcepto'
            },
            {
                xtype: 'hidden',
                readOnly: true,
                width: 455,
                height: 50,
                fieldLabel: 'Descripción',
                style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                id: 'sysDesConcepto'
            },
            {
                xtype: 'hidden',
                id: 'sysIVA',
                value: 0
            },
            {
                xtype: 'hidden',
                id: 'sysVlrIVA',
                value: 0
            },
            {
                xtype: 'hidden',
                id: 'sysidTipoReg',
                value: 0
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                value: 1,
                id: 'sysUbicacionPlantillaHC'
            },
            {
                xtype: 'fieldset',
                title: 'Datos del Cliente',
                layout: 'form',
                anchor: '99%',
                autoHeight: true,
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                id: 'fsServicioIdentify',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        fieldLabel: 'Cliente',
                        items: [
                            
                            {
                                xtype: 'combo',
                                width: 180,
                                listWidth: 450,
                                allowBlank: false,
                                store: 'StoreCliente',
                                displayField: 'Descripcion',
                                valueField: 'Codigo',
                                emptyText: 'Selecione Cliente....',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                autoSelect: false,
                                typeAheadDelay: 50,
                                triggerAction: 'all',
                                id: 'sysIdCliente_HC',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        Ext.getCmp('sysIdPlan_HC').setValue(null);
                                        Ext.getCmp('sysIdSubPlan_HC').setValue(null);
                                        Ext.getCmp('sysIdContrato_HC').setValue(null);
                                        Ext.getCmp('sysIdPlan_HC').store.load({
                                            params: {
                                                pCliente: 0
                                            }
                                        });
                                        Ext.getCmp('sysIdSubPlan_HC').store.load({
                                            params: {
                                                pPlan: 0
                                            }
                                        });
                                        Ext.getCmp('sysIdContrato_HC').store.load({
                                             params: {
                                                pCliente: cmb.getValue()
                                             }
                                         });
                        
                                        if (cmb.getValue() != null && cmb.getValue() != ""){
                                             Ext.getCmp('sysIdPlan_HC').store.load({
                                                 params: {
                                                    pCliente: cmb.getValue()
                                                 },
                                                 callback: function(){
                                                    Ext.getCmp('sysIdPlan_HC').enable();
                                                    Ext.getCmp('sysIdContrato_HC').store.load({
                                                         params: {
                                                            pCliente: cmb.getValue()
                                                         },
                                                         callback: function(){
                                                            Ext.getCmp('sysIdContrato_HC').enable()
                                                         }
                                                     });
                                                 }
                                             });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Plan:' //&nbsp;
                            },
                            {
                                xtype: 'combo',
                                disabled: true,
                                width: 160,
                                listWidth: 450,
                                allowBlank: false,
                                mode: 'local',
                                store: 'StoreClientesPlan',
                                valueField: 'IdPlan',
                                displayField: 'Descripcion',
                                typeAhead: true,
                                triggerAction: 'all',
                                typeAheadDelay: 50,
                                emptyText: 'Selecione Plan....',
                                forceSelection: true,
                                id: 'sysIdPlan_HC',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        Ext.getCmp('sysIdSubPlan_HC').setValue(null);
                                        Ext.getCmp('sysIdSubPlan_HC').store.load({
                                            params: {
                                                pPlan: 0
                                            }
                                        });
                                        if (cmb.getValue() != null && cmb.getValue() != ""){
                                             Ext.getCmp('sysIdSubPlan_HC').store.load({
                                                 params: {
                                                    pPlan: cmb.getValue()
                                                 },
                                                 callback: function(){
                                                    Ext.getCmp('sysIdSubPlan_HC').enable();
                                                 }
                                             });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'displayfield',
                                value: 'SubPlan:' //&nbsp;
                            },
                            {
                                xtype: 'combo',
                                disabled: true,
                                width: 160,
                                listWidth: 450,
                                allowBlank: false,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                store: 'StoreClienteSubplan',
                                displayField: 'Descripcion',
                                valueField: 'IdSubPlan',
                                mode: 'local',
                                emptyText: 'Selecione Sub Plan....',
                                forceSelection: true,
                                id: 'sysIdSubPlan_HC'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Contrato:' //&nbsp;
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Contrato',
                                disabled: true,
                                width: 155,
                                listWidth: 450,
                                allowBlank: false,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                store: 'StoreClienteContrato',
                                valueField: 'IdContrato',
                                displayField: 'Contrato',
                                mode: 'local',
                                emptyText: 'Selecione Contrato....',
                                forceSelection: true,
                                id: 'sysIdContrato_HC'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        fieldLabel: 'Fecha Entrega Orden por la EPS',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Entrega Orden por la EPS',
                                allowBlank: false,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'sysFechaPlantillaHC'
                            },
                            {
                                xtype: 'displayfield',
                                value: '&nbsp;&nbsp;&nbsp;Nro Autorización'
                            },
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                style: 'text-align:center;',
                                id: 'sysNroAutorizacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Paquete:'
                            },
                            {
                                xtype: 'combo',
                                width: 400,
                                allowBlank: false,
                                store: 'StorePaqueteServicios',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intIdPaqueteServicio',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        if (cmb.getValue() == null || cmb.getValue() == ""){
                                            Ext.getCmp('gridConceptosPaqueteServicios').store.load({
                                                params: {
                                                    pPaquete: 0
                                                }
                                            });
                                        }else{
                                            Ext.getCmp('gridConceptosPaqueteServicios').store.load({
                                                params: {
                                                    pPaquete: cmb.getValue()
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'editorgrid',
                        id: 'gridConceptosPaqueteServicios',
                        store: stConceptosPaqueteServicios,
                        anchor: "100%",
                        height: 205,
                        border: false,
                        frame: true,
                        loadMask: true,
                        stripeRows: true,
                        clicksToEdit: 1,
                        title: 'Conceptos - Procedimientos',
                        cm: new xg.ColumnModel([
                            chkColumnSeleccionarConcepto,
                            {
                                header: 'IdPaqueteServicio',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'IdPaqueteServicio',
                                width: 1,
                                hidden: true,
                                hideable: false
                            },
                            {
                                header: 'IdProcedimiento',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'IdProcedimiento',
                                width: 1,
                                hidden: true,
                                hideable: false
                            },
                            {
                                header: 'CodProced',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'CodProced',
                                width: 1,
                                hidden: true,
                                hideable: false
                            },
                            {
                                header: 'Descripción',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'DesProced',
                                width: 700
                            },
                            {
                                header: 'Tarifa',
                                readOnly: false,
                                sortable: false,
                                dataIndex: 'VlrTarifa',
                                renderer:  Ext.util.Format.Currency,
                                editor: intVlrTarifaConcepto,
                                align: 'right',
                                width: 150
                            }
                        ]),
                        plugins: [chkColumnSeleccionarConcepto],
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        viewConfig: {
                            forceFit:true
                        },
                        columnLines: true
                    }
                ]
            },
            {
                xtype: 'hidden',
                fieldLabel: 'Numero de Personas a Cargo',
                allowBlank: true,
                value: 0,
                width: 100,
                id: 'strNroPersonasCargoProceso'
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                width: 300,
                id: 'strCargoAspiraProceso'
            },
            {
                xtype: 'hidden',
                width: 335,
                allowBlank: true,
                id: 'strEmpresaAspiraProceso'
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                width: 300,
                value: "NO APLICA",
                id: 'strCargoEmpresaActualProceso'
            },
            {
                xtype: 'hidden',
                width: 175,
                allowBlank: true,
                value: "NO APLICA",
                id: 'strEmpresaActualProceso'
            },
            {
                xtype: 'hidden',
                width: 110,
                allowBlank: true,
                id: 'strNomSedeEmpresaActualProceso'
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                width: 100,
                emptyText: 'Años',
                id: 'strAntiguedadCargoActualProceso'
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                width: 100,
                emptyText: 'Años',
                id: 'strAntiguedadOficioProceso'
            },
            {
                xtype: 'hidden',
                fieldLabel: 'Tipo Examen',
                width: 100,
                listWidth: 150,
                name: 'TIPO EXAMEN',
                allowBlank: true,
                store: 'StoreTipoExamenSaludOcupacional',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                submitValue: true,
                id: 'strTipoExamenProceso'
            },
            {
                xtype: 'hidden',
                width: 180,
                listWidth: 500,
                name: 'EPS',
                allowBlank: true,
                store: 'StoreSGSSEPS',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                value: 'NO APLICA',
                id: 'strEPSProceso'
            },
            {
                xtype: 'hidden',
                width: 125,
                listWidth: 500,
                name: 'PENSION',
                allowBlank: true,
                store: 'StoreSGSSPENSION',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                value: 'NO APLICA',
                id: 'strPENSIONProceso'
            },
            {
                xtype: 'hidden',
                width: 140,
                listWidth: 500,
                name: 'ARP',
                allowBlank: true,
                store: 'StoreSGSSARP',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                value: 'DESCONOCIDO',
                id: 'strARPProceso'
            },
            {
                xtype: 'hidden',
                width: 315,
                allowBlank: true,
                store: 'StoreTipoVinculacionContrato',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                id: 'strTipoVinculacionContratoProceso'
            },
            {
                xtype: 'hidden',
                width: 315,
                allowBlank: true,
                store: 'StoreTurnoLaboral',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                emptyText: 'Seleccione....',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                id: 'strTurnoProceso'
            },
            {
                fbar: {
                    xtype: 'toolbar',
                    buttonAlign: 'right',
                    items: [
                        {
                            xtype: 'button',
                            iconCls: 'btnGuardar',
                            tooltip: 'Crear Registro de Programacion de la Cirugia',
                            id: 'btnCrearHC',
                            text: 'Crear Registro de Programacion de la Cirugia',
                            handler:function(){
                                if(yaRadico == true){
                                    Ext.MessageBox.show({
                                        title: 'Error',
                                        msg: 'Ya Inicio el Proceso para este Paciente',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }else{
                                    if(Ext.getCmp('sysUbicacionPlantillaHC').getValue() != "" && Ext.getCmp('sysUbicacionPlantillaHC').getValue() != null && Ext.getCmp('sysIdCliente_HC').getValue() != "" && Ext.getCmp('sysIdCliente_HC').getValue() != null && Ext.getCmp('sysIdPlan_HC').getValue() != "" && Ext.getCmp('sysIdPlan_HC').getValue() != null && Ext.getCmp('sysIdSubPlan_HC').getValue() != "" && Ext.getCmp('sysIdSubPlan_HC').getValue() != null && Ext.getCmp('sysIdContrato_HC').getValue() != "" && Ext.getCmp('sysIdContrato_HC').getValue() != null && Ext.getCmp('sysFechaPlantillaHC').getValue() != "" && Ext.getCmp('sysFechaPlantillaHC').getValue() != null){
                                        var conceptosseleccionados = false;
                                        var parametrosConceptosSeleccionados = null;
                                        Ext.getCmp('gridConceptosPaqueteServicios').store.filterBy(function(record,id){
                                            return record.get('Seleccionar') == true;
                                        });
                                        Ext.getCmp('gridConceptosPaqueteServicios').store.each(function(record){
                                            conceptosseleccionados = true;
                                            parametrosConceptosSeleccionados = parametrosConceptosSeleccionados + record.get('IdProcedimiento') + "^" + record.get('CodProced') + "^" + record.get('DesProced') + "^" + record.get('VlrTarifa') + "¬";
                                        });
                                        if(conceptosseleccionados == true){
                                            yaRadico = true;
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/asistencial/partisalud.php",
                                                params:{
                                                    task: "CrearProceso",
                                                    pEmpresa: ID_EMPRESA,
                                                    pConsultorio: Ext.getCmp('sysUbicacionPlantillaHC').getValue(),
                                                    pCliente: Ext.getCmp('sysIdCliente_HC').getValue(),
                                                    pPlan: Ext.getCmp('sysIdPlan_HC').getValue(),
                                                    pSubPlan: Ext.getCmp('sysIdSubPlan_HC').getValue(),
                                                    pContrato: Ext.getCmp('sysIdContrato_HC').getValue(),
                                                    pFecha:  Ext.getCmp('sysFechaPlantillaHC').getValue().format('Y/m/d'),
                                                    pProfesional: 1,
                                                    pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                                                    pEdadPaciente: Ext.getCmp('strEdad').getValue(),
                                                    pDeptoMunici: Ext.getCmp('strDeptoMuni').getValue(), 
                                                    pAutorizacion: Ext.getCmp('sysNroAutorizacion').getValue(),
                                                    pPersonasCargo: Ext.getCmp('strNroPersonasCargoProceso').getValue(),
                                                    pCargoAspira: Ext.getCmp('strCargoAspiraProceso').getValue(),
                                                    pEmpresaAspira: Ext.getCmp('strEmpresaAspiraProceso').getValue(),
                                                    pCargoActual: Ext.getCmp('strCargoEmpresaActualProceso').getValue(),
                                                    pEmpresaActual: Ext.getCmp('strEmpresaActualProceso').getValue(),
                                                    pSedeActual: Ext.getCmp('strNomSedeEmpresaActualProceso').getValue(),
                                                    pAntiguedadCrgo: Ext.getCmp('strAntiguedadCargoActualProceso').getValue(),
                                                    pAntiguedadOficio: Ext.getCmp('strAntiguedadOficioProceso').getValue(),
                                                    pTipoExamen: Ext.getCmp('strTipoExamenProceso').getValue(),
                                                    pEPS: Ext.getCmp('strEPSProceso').getValue(),
                                                    pPENSION: Ext.getCmp('strPENSIONProceso').getValue(),
                                                    pARP: Ext.getCmp('strARPProceso').getValue(),
                                                    pTipoVinculacion: Ext.getCmp('strTipoVinculacionContratoProceso').getValue(),
                                                    pTurno: Ext.getCmp('strTurnoProceso').getValue(), 
                                                    pFecNac: Ext.getCmp('fecFecNac').getValue(), 
                                                    pEdad: Ext.getCmp('strEdad').getValue(), 
                                                    pEstadoCivil: Ext.getCmp('strEstadoCivilPac').getValue(), 
                                                    pEscolaridad: Ext.getCmp('strEscolaridadPac').getValue(), 
                                                    pDireccion: Ext.getCmp('strDireccion').getValue(), 
                                                    pTelefono: Ext.getCmp('strTel1').getValue(), 
                                                    pMuni: Ext.getCmp('strDeptoMuni').getValue(), 
                                                    pUsuario: ID_USUARIO,
                                                    pConceptos: parametrosConceptosSeleccionados
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); 
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    var NroCAS = Contenido[0];
                                                    if(NroCAS > 0){
                                                        Ext.getCmp('gridProcesoPartisaludxPac').store.load({
                                                            params:{
                                                                pPaciente: Ext.getCmp('intIdPaciente').getValue()
                                                            }
                                                        });
                                                        //Ext.getCmp('gridHistorialLaboral').setVisible(true);
                                                        Ext.MessageBox.show({
                                                            title: 'Proceso',
                                                            msg: 'Se inicio el proceso con exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        Ext.getCmp('winAddEvolucionOfimedicalUi').close();
                                                    } else {
                                                        Ext.Msg.hide();
                                                        Ext.MessageBox.show({
                                                            title: 'Crear Registro Evolución',
                                                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                },
                                                failure: function(response,options)
                                                {
                                                    yaRadico = false;
                                                    Ext.MessageBox.hide();
                                                    Ext.MessageBox.show({
                                                        title: 'Crear Registro Evolución',
                                                        msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Debe seleccionar minimo un concepto - procedimiento',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        }
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los campos de la pantalla son requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddEvolucionOfimedicalUi.superclass.initComponent.call(this);
    }
});
