/*
* @category    Formulario Profesional Solicitante
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winProfeSolUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Profesional Solicitante ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winProfeSolUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmProfeSol',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdProfeSol',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripcion',
                                name: 'strDescripcion',
                                allowBlank: false,
                                id: 'strDescripcionProfeSol'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Espacialidad',
                                name: 'strEspacialidad',
                                allowBlank: true,
                                id: 'strEspecialidadProfeSol'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Direccion',
                                name: 'strDireccion',
                                allowBlank: true,
                                id: 'strDireccionProfeSol'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Telefono',
                                name: 'strTelefono',
                                allowBlank: true,
                                id: 'strTelefonoProfeSol'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Usuario',
                                name: 'sysUsuario',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Fecha Modificación',
                                name: 'sysFechaAct',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysFechaAct'
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AdicionarProfeSol',
                            handler:function(){
                                fnGuardarProfesol();
                            }
                        },
                        {
                            xtype: 'button',
                            text: 'Modificar',
                            iconCls: 'btnGuardar',
                            id: 'btn_ModificarProfeSol'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirProfeSol',
                            listeners: {
                                click: function(){
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'Esta seguro que desea cerrar la ventana?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                               Ext.getCmp('winProfeSolUi').close();
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winProfeSolUi.superclass.initComponent.call(this);
    }
});

function fnGuardarProfesol(wCas,wUsuario){
    var frm = Ext.getCmp('frmProfeSol').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: '../../controlador/profesol/controlador_profesol.php',
            params:{
                task: 'INSERTAR',
                pNomBaseDatos: BD_MULTIPRESTADOR,
                CAMPOS: listacampos
            },
            success: function(res,req){
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        try {
                            var campo = Ext.getCmp('fProfeSol');
                            if ( campo != null ) {
                                Ext.getCmp('fProfeSol').store.load({
                                    params: {
                                        pNomBaseDatos: BD_MULTIPRESTADOR
                                    }
                                });
                            }
                        }catch(ex){
                        }
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        try {
                            var campo1 = Ext.getCmp('sysProfeSol');
                            if ( campo1 != null ) {
                                Ext.getCmp('sysProfeSol').store.load({
                                    params: {
                                        pNomBaseDatos: BD_MULTIPRESTADOR
                                    }
                                });
                            }
                        }catch(ex){
                        }
                        try {
                            var campo2 = Ext.getCmp('intProfeSol');
                            if ( campo2 != null ) {
                                Ext.getCmp('intProfeSol').store.load({
                                    params: {
                                        pNomBaseDatos: BD_MULTIPRESTADOR
                                    }
                                });
                            }
                        }catch(ex){
                        }
                        
                        Ext.getCmp('winProfeSolUi').close();
                        break;

                    default:
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options){
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}