/*
* @category    Formulario Profesional Solicitante
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winProfeSolUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Profesional Solicitante ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winProfeSolUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmProfeSol',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdProfeSol',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripcion',
                                name: 'strDescripcion',
                                allowBlank: false,
                                id: 'strDescripcion'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Espacialidad',
                                name: 'strEspacialidad',
                                allowBlank: true,
                                id: 'strEspecialidad'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Direccion',
                                name: 'strDireccion',
                                allowBlank: true,
                                id: 'strDireccion'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Telefono',
                                name: 'strTelefono',
                                allowBlank: true,
                                id: 'strTelefono'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Usuario',
                                name: 'sysUsuario',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Fecha Modificación',
                                name: 'sysFechaAct',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysFechaAct'
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AdicionarProfeSol'
                        },
                        {
                            xtype: 'button',
                            text: 'Modificar',
                            iconCls: 'btnGuardar',
                            id: 'btn_ModificarProfeSol'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirProfeSol'
                        }
                    ]
                }
            }
        ];
        winProfeSolUi.superclass.initComponent.call(this);
    }
});
