/*
* @category    Formulario Grid Profesionales Solicitantes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmProfeSolUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Profesionales Solicitantes ::.',
    id: 'winFrmProfeSol',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var mybbar = new utilBbarUi();
        var stGrid = new StoreGridProfeSolicitantes();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'grid',
                id: 'gridProfeSol',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'Codigo',
                        id: 'Codigo'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 330,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Especialidad',
                        sortable: false,
                        width: 300,
                        dataIndex: 'Especialidad',
                        id: 'Especialidad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Dirección',
                        sortable: false,
                        width: 150,
                        dataIndex: 'Direccion',
                        id: 'Direccion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Telefono',
                        sortable: false,
                        width: 150,
                        dataIndex: 'Telefono',
                        id: 'Telefono'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Profesional',
                                iconCls: 'btnAddRow',
                                id: 'btnAddProfeSolicitante'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar Profesional',
                                iconCls: 'btnEditRow',
                                id: 'btnEditProfeSolicitante'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Profesional',
                                iconCls: 'btnDelRow',
                                id: 'btnDelProfeSolicitante'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            new Ext.app.SearchField({
                                id: 'qryProfeSol',
                                store: stGrid,
                                ValparamP1: ID_EMPRESA,
                                emptyText: 'Escriba el criterio que desea buscar',
                                params: {pEmpresa: Ext.get('idempresa').getValue(), start: 0, limit: 15},
                                width: 120
                            })
                        ]
                    },
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: stGrid,
                    displayInfo: true
                })
            }
        ];
        winFrmProfeSolUi.superclass.initComponent.call(this);
    }
});
