/*
* @category    Formulario Grid Lista Profesiones
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEditListaProfesionesUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Editar Lista de Profesiones ::.',
    id: 'winEditListaProfesiones',
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    closable: true,
    modal: true,
    y: 120,
    layout: 'fit',
    initComponent: function() {
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        var textField = new Ext.form.TextField({
            style: 'text-transform:uppercase;'
        });

        var st = new StoreProfesion();
        st.load();
        
        this.items = [
           {
                xtype: 'editorgrid',
                id: 'gridProfesiones',
                store: st,
                anchor: "100%",
                border: false,
                frame: true,
                layout: 'fit',
                columns: [
                    new Ext.grid.RowNumberer(),
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'OldDescripcion',
                        id: 'OldDescripcion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: true,
                        editor: textField,
                        width: 930,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar',
                                iconCls: 'btnEditRow',
                                id: 'btnEditProfesiones',
                                listeners:{
                                    click : function(){
                                        var modified = Ext.getCmp('gridProfesiones').getStore().getModifiedRecords();
                                        if(!Ext.isEmpty(modified)){
                                            var recordsToSend = [];
                                            Ext.each(modified, function(record) {
                                                recordsToSend.push(Ext.apply({OldDescripcion: QuitarAcentosTxt(record.data.OldDescripcion.toUpperCase())},{Descripcion: QuitarAcentosTxt(record.data.Descripcion.toUpperCase())}));
                                            });
                                            Ext.getCmp('gridProfesiones').el.mask('Guardando Información...', 'x-mask-loading');
                                            Ext.getCmp('gridProfesiones').stopEditing();
                                            recordsToSend = Ext.encode(recordsToSend);
                                            Ext.Ajax.request({
                                                url : '../../controlador/profesiones/controlador_profesiones.php',
                                                params :{
                                                    task: 'Modificar',
                                                    records : recordsToSend
                                                },
                                                scope:this,
                                                success : function(response) {
                                                    Ext.getCmp('gridProfesiones').getStore().commitChanges();
                                                    Ext.getCmp('gridProfesiones').store.reload();
                                                    Ext.getCmp('strProfesionPac').store.reload();
                                                    Ext.getCmp('gridProfesiones').el.unmask();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        winEditListaProfesionesUi.superclass.initComponent.call(this);
    }
});
