/*
* @category    Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winProfesionalesUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Profesionales ::.',
    width: 970,
    height: 580,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winProfesionalesUi',
    initComponent: function() {
        
        function renderTopic(value, p, record){
            return String.format(
                '<b style="color:#36C;">{0}</b><table border="0"><tr><td>Codigo Interno:</td><td>{1}</td></tr><tr><td>Codigo CUPS:</td><td>{2}</td></tr></table>',
                value, record.data.CodProced, record.data.CUPSCodigo);
        }
        
        function renderInfoAddCita(value, p, record){
            return String.format(
                '<table border="0"><tr><td><b>{0}</b></td></tr><tr><td>{1}</td></tr></table>',
                value, record.data.InfoAddCita);
        }
        
        function renderPlantillaProced(value, p, record){
            return String.format(
                '<b style="color:#36C;">{0}</b><table border="0"><tr><tr><td>Concepto:</td><td>{1}</td></tr><td>Interno:</td><td>{2}</td></tr><tr><td>CUPS:</td><td>{3}</td></tr></table>',
                value, record.data.DesProced, record.data.CodProced, record.data.CUPSCodigo);
        }
        
        function renderFillFechaAgenda(value,metaData, record){
            switch (record.data.estado)
            {
                case "0":
                    metaData.attr = 'style="background-color:#FCC;text-align: center;"';
                    return value;
                    break;
                case "1":
                    metaData.attr =  'style="background-color:#ffffcc;text-align: center;"';
                    return value;
                    break;
                case "2":
                    metaData.attr =  'style="background-color:#006666;text-align: center;"';
                    return value;
                    break;
                default:
                    //return 'SinCitas';
                    metaData.attr =  'style="text-align: center;"';
                    return value;
                    break;
            }
	}
        
        function renderEstadoAgenda(value, p, record){
            switch (record.data.estado)
            {
                case "a":
                    return String.format(
                        '<b>Agenda Abierta Sin Citas Asignadas</b>',
                        value);
                    break;
                case "1":
                    return String.format(
                        '<b>Agenda Abierta Con Citas Asignadas</b>',
                        value);
                    break;
                case "2":
                    return String.format(
                        '<b>Agenda Cerrada</b>',
                        value);
                    break;
                case "0":
                    return String.format(
                        '<b>Agenda Anulada</b><hr>Motivo Anlución: {2} </br>Fecha Anulación: {1} - Usuario: {0}',
                        record.data.UsuarioQuienAnula, record.data.FechaAnula, record.data.MotivoAnula);
                    break;
                default:
                    break;
            }
            
        }
        
        var stGridSedeIPSxProfe = new StoreGridProfesionalesxSEDExIPS();
        var stGridConultoriosxProfe = new StoreGridConsultoriosxProfesional();
        var stGridPlantillaCitas = new StoreGridProfesionalesPlantillaCitas();
        var stGridPlantillaxProced = new StoreGridProfesionalesPlantillaProced();
        var stGridPlantillaHoras = new StoreGridProfesionalesPlantillaCitasHorario();
        var stGridProcedimientosxProfe = new StoreGridProfesionalesProgramarProcedimientos();
        var stGridAgendasxProfe = new StoreGridProfesionalesAgendasProgramadas();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                height: 535,
                anchor: '100%',
                id: 'frmProfesionales',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/profesionalespeq.png" align="left" alt=""/>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 130,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysPrestador'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intidProfesional',
                                value: 0
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'ID Profesional',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        allowNegative: false,
                                        allowDecimals: false,
                                        width: 200,
                                        fieldLabel: 'Documento ID',
                                        allowBlank: false,
                                        emptyText: 'Documento de ID',
                                        id: 'intDocProfesional'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        fieldLabel: 'Nro. Registro o Tarjeta Profesional',
                                        maxLength: 20,
                                        allowBlank: false,
                                        emptyText: 'Nro. Registro Tarjeta',
                                        id: 'strRegistroProfesional'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 90,
                                        maxLength: 10,
                                        allowBlank: false,
                                        emptyText: 'Cod. Rapido',
                                        id: 'strCodigoRapidoProfesional'
                                    },
                                    {
                                        html:'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp',border: false
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtusr',
                                        style: 'color: #666;',
                                        value: 'Usuario:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        fieldLabel: 'Usuario',
                                        readOnly: true,
                                        allowBlank: true,
                                        style: 'background:transparent;border-top-style: none;	border-right-style: none; border-bottom-style: none;border-left-style: none;',
                                        id: 'sysUsuario'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtfec',
                                        style: 'color: #666;',
                                        value: 'FechaAct:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        fieldLabel: 'Fecha Modificación',
                                        style: 'background:transparent;border-top-style: none;	border-right-style: none; border-bottom-style: none;border-left-style: none;',
                                        readOnly: true,
                                        allowBlank: true,
                                        id: 'sysFechaAct'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripción / Nombre',
                                allowBlank: false,
                                emptyText: 'Digite la Descripción o Nombre',
                                id: 'strDescripcion'
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Tipo / Especialidad',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 150,
                                        fieldLabel: 'Tipo',
                                        anchor: '100%',
                                        triggerAction: 'all',
                                        mode: 'local',
                                        typeAhead: true,
                                        emptyText: 'Tipo...!',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        store: 'StoreTipoProfesional',
                                        forceSelection: false,
                                        allowBlank: false,
                                        id: 'strTipoProfesional'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 613,
                                        fieldLabel: 'Especialidad',
                                        anchor: '100%',
                                        triggerAction: 'all',
                                        mode: 'local',
                                        typeAhead: true,
                                        emptyText: 'Especialidad...!',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        store: 'StoreEspecialidad',
                                        forceSelection: false,
                                        allowBlank: false,
                                        id: 'strIdEspecialidad'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Dir / Tel / Email',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        fieldLabel: 'Dirección',
                                        maxLength: 100,
                                        width: 268,
                                        allowBlank: false,
                                        emptyText: 'Dirección',
                                        id: 'strDireccion'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        fieldLabel: 'Teléfono',
                                        maxLength: 100,
                                        width: 245,
                                        allowBlank: false,
                                        emptyText: 'Teléfono',
                                        id: 'strTelefono'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        fieldLabel: 'Email',
                                        maxLength: 200,
                                        width: 245,
                                        vtype: 'email',
                                        allowBlank: false,
                                        emptyText: 'Email',
                                        id: 'strEmail'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Verificar',
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysProgAge',
                                        value: 'Programar Agendas:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Programar Agendas',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolProgramarAgenda'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysModKardex',
                                        value: '     -     Modificar Kardex Programas:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Modificar Kardex',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolModificaKardex'
                                    },
                                    {
                                        html:'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',border: false
                                    },
                                    {
                                        xtype: 'displayfield',
                                        style: 'color:#00C;',
                                        id: 'sysActivo',
                                        value: 'ACTIVO:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolActivo'
                                    }
                                ]
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'tabpanel',
                                id: 'tbOpcionesProfesionales',
                                enableTabScroll : true,
                                activeTab: 0,
                                height: 295,
                                items: [
                                    {
                                        xtype: 'panel',
                                        title: 'Asociar Sede / IPS',
                                        items:[
                                            {
                                                xtype: 'grid',
                                                id: 'gridSedesIPSxProfe',
                                                store: stGridSedeIPSxProfe,
                                                anchor: "100%",
                                                height: 270,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                columns: [
                                                    {
                                                        header: 'idSEDE',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'idsede',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'Descripción de la Sede',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'sede',
                                                        width: 435
                                                    },
                                                    {
                                                        header: 'idIPS',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'idips',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'Descripción de la IPS',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'ips',
                                                        width: 435
                                                    }
                                                ],
                                                tbar:
                                                    {
                                                        xtype: 'toolbar',
                                                        items: [
                                                            {
                                                                xtype: 'button',
                                                                text: 'Adicionar',
                                                                iconCls: 'btnAddRow',
                                                                id: 'btnAddItemGridSedeIPS'
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                text: 'Eliminar',
                                                                iconCls: 'btnDelRow',
                                                                id: 'btnDelItemGridSedeIPS'
                                                            }
                                                        ]
                                                    },
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                iconCls:'icon-grid',
                                                view: new Ext.grid.GroupingView({
                                                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                                                })
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        title: 'Asociar Consultorios',
                                        items:[
                                            {
                                                xtype: 'grid',
                                                id: 'gridConsultoriosIPSxProfe',
                                                store: stGridConultoriosxProfe,
                                                anchor: "100%",
                                                height: 270,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                columns: [
                                                    {
                                                        header: 'idProfesional',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'idProfesional',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'idIPS',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'idIPS',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'idConsultorio',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'idConsultorio',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'Descripción del Consultorio',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'Consultorio',
                                                        width: 865
                                                    }
                                                ],
                                                tbar:
                                                    {
                                                        xtype: 'toolbar',
                                                        items: [
                                                            {
                                                                xtype: 'button',
                                                                text: 'Adicionar',
                                                                iconCls: 'btnAddRow',
                                                                id: 'btnAddItemGridConsultorios'
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                text: 'Eliminar',
                                                                iconCls: 'btnDelRow',
                                                                id: 'btnDelItemGridConsultorios'
                                                            }
                                                        ]
                                                    },
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                iconCls:'icon-grid'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        title: 'Plantilla Resultados Procedimientos',
                                        items: [
                                            {
                                                xtype: 'container',
                                                width: 902,
                                                height: 270,
                                                layout: 'border',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        region: 'center',
                                                        anchor: '100%',
                                                        height: 270,
                                                        items: [
                                                            {
                                                                xtype: 'htmleditor',
                                                                id: 'sysDetallePlantillaProcedimiento',
                                                                allowBlank: false,
                                                                width: 620,
                                                                height: 265,
                                                                readOnly: true,
                                                                enableAlignments : false,
                                                                enableColors : false,
                                                                enableFont : false,
                                                                enableFontSize : false,
                                                                enableFormat : false,
                                                                enableLinks : false,
                                                                enableLists : false,
                                                                enableSourceEdit : false
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'grid',
                                                        id: 'gridPlantillasResxProcexProfe',
                                                        region: 'west',
                                                        title: 'Plantillas',
                                                        frame: true,
                                                        loadMask: true,
                                                        flex: 1,
                                                        width: 280,
                                                        height: 240,
                                                        store: stGridPlantillaxProced,
                                                        tbar:
                                                        {
                                                            xtype: 'toolbar',
                                                            items: [
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Adicionar',
                                                                    iconCls: 'btnAddRow',
                                                                    id: 'btnAddItemGridPlantillaProced'
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Modificar',
                                                                    iconCls: 'btnEditRow',
                                                                    id: 'btnEditItemGridPlantillaProced'
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Eliminar',
                                                                    iconCls: 'btnDelRow',
                                                                    id: 'btnDelItemGridPlantillaProced'
                                                                }
                                                            ]
                                                        },
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        columns: [
                                                            {
                                                                header: 'Plantilla',
                                                                readOnly: true,
                                                                sortable: true,
                                                                dataIndex: 'nomPlantilla',
                                                                renderer: renderPlantillaProced,
                                                                width: 270
                                                            }
                                                        ],
                                                        viewConfig: {
                                                            forceFit:true
                                                        },
                                                        columnLines: true
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        title: 'Consultas / Procedimientos a Programar',
                                        items:[
                                            {
                                                xtype: 'grid',
                                                id: 'gridProgProcedxProfe',
                                                store: stGridProcedimientosxProfe,
                                                anchor: "100%",
                                                height: 270,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                columns: [
                                                    {
                                                        header: 'idProfesional',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'idProfesional',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'IdProced',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'IdProced',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'Tipo de Estudio',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'TipoEstudio',
                                                        width: 150
                                                    },
                                                    {
                                                        header: 'Procedimiento / Consulta',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'DesProced',
                                                        renderer: renderTopic,
                                                        width: 715
                                                    }
                                                ],
                                                tbar:
                                                    {
                                                        xtype: 'toolbar',
                                                        items: [
                                                            {
                                                                xtype: 'button',
                                                                text: 'Adicionar',
                                                                iconCls: 'btnAddProcedimiento',
                                                                id: 'btnAddItemGridProcedxProfe'
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                text: 'Eliminar',
                                                                iconCls: 'btnDelProcedimiento',
                                                                id: 'btnDelItemGridProcedxProfe'
                                                            },
                                                            '->',
                                                            new Ext.app.SearchField({
                                                                id: 'qryProcedimientoProfesional',
                                                                store: stGridProcedimientosxProfe,
                                                                emptyText: 'Escriba el criterio que desea buscar',
                                                                params: {pProfesional: 0, start: 0, limit: 15},
                                                                ValparamP1: ID_PROFESIONAL_EDIT,
                                                                width: 120
                                                            })
                                                        ]
                                                    },
                                                iconCls:'icon-grid',
                                                view: new Ext.grid.GroupingView({
                                                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                                                }),
                                                viewConfig: {
                                                    forceFit:true
                                                },
                                                columnLines: true
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        title: 'Plantilla de Citas',
                                        items: [
                                            {
                                                xtype: 'container',
                                                width: 902,
                                                height: 270,
                                                layout: 'border',
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        //border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        id: 'gridPlantillasHorarioxProfe',
                                                        title: 'Horarios Asociados a la Plantilla',
                                                        region: 'center',
                                                        store: stGridPlantillaHoras,
                                                        tbar:
                                                        {
                                                            xtype: 'toolbar',
                                                            items: [
                                                                '->',
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Adicionar',
                                                                    iconCls: 'btnAddHour',
                                                                    id: 'btnAddItemGridHorarioPlantilla'
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Eliminar',
                                                                    iconCls: 'btnDelHour',
                                                                    id: 'btnDelItemGridHorarioPlantilla'
                                                                }
                                                            ]
                                                        },
                                                        iconCls:'icon-grid',
                                                        columns: [
                                                            {
                                                                header: 'idPlantilla',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'idPlantilla',
                                                                width: 1,
                                                                hidden: true,
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'idTipoHorario',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'idTipoHorario',
                                                                width: 1,
                                                                hidden: true,
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'IdCita',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'IdCita',
                                                                width: 1,
                                                                hidden: true,
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'Descripción de la Hora',
                                                                readOnly: true,
                                                                sortable: true,
                                                                dataIndex: 'DesCita',
                                                                renderer: renderInfoAddCita,
                                                                width: 300
                                                            },
                                                            {
                                                                header: 'Hora Estimada Atención',
                                                                readOnly: true,
                                                                sortable: true,
                                                                dataIndex: 'HoraAtencion',
                                                                width: 145
                                                            },
                                                            {
                                                                header: 'Grupo Prioritario',
                                                                readOnly: true,
                                                                sortable: true,
                                                                dataIndex: 'GrupoPrioritario'
                                                            },
                                                            {
                                                                header: 'Asignación WEB',
                                                                readOnly: true,
                                                                sortable: true,
                                                                dataIndex: 'AsignarWeb'
                                                            },
                                                        ],
                                                        viewConfig: {
                                                            forceFit:true
                                                        },
                                                        columnLines: true
                                                    },
                                                    {
                                                        xtype: 'grid',
                                                        id: 'gridPlantillasxProfe',
                                                        title: 'Plantillas',
                                                        region: 'west',
                                                        //border: true,
                                                        frame: true,
                                                        loadMask: true,
                                                        width: 220,
                                                        height: 240,
                                                        store: stGridPlantillaCitas,
                                                        tbar:
                                                        {
                                                            xtype: 'toolbar',
                                                            items: [
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Adicionar',
                                                                    iconCls: 'btnAddRow',
                                                                    id: 'btnAddItemGridPlantilla'
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Eliminar',
                                                                    iconCls: 'btnDelRow',
                                                                    id: 'btnDelItemGridPlantilla'
                                                                }
                                                            ]
                                                        },
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        iconCls:'icon-grid',
                                                        columns: [
                                                            {
                                                                header: 'Descripción',
                                                                readOnly: true,
                                                                sortable: true,
                                                                dataIndex: 'Descripcion',
                                                                width: 200
                                                            }
                                                        ],
                                                        viewConfig: {
                                                            forceFit:true
                                                        },
                                                        columnLines: true
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        title: 'Programación de Agendas',
                                        items:[
                                            {
                                                xtype: 'grid',
                                                id: 'gridProgramaAgendaxProfe',
                                                store: stGridAgendasxProfe,
                                                anchor: "100%",
                                                height: 270,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                columns: [
                                                    {
                                                        header: 'idAgenda',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'idAgenda',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },
                                                    {
                                                        header: 'Consultorio',
                                                        readOnly: true,
                                                        sortable: false,
                                                        hideable: false,
                                                        hidden: true,
                                                        dataIndex: 'Consultorio',
                                                        width: 0
                                                    },
                                                    {
                                                        header: 'Plantilla',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'Plantilla',
                                                        width: 200
                                                    },
                                                    {
                                                        header: 'Fecha Programada',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'fecAgenda',
                                                        width: 120,
                                                        renderer: renderFillFechaAgenda
                                                    },
                                                    {
                                                        header: 'Estado',
                                                        readOnly: true,
                                                        sortable: true,
                                                        dataIndex: 'estado',
                                                        renderer: renderEstadoAgenda,
                                                        width: 540
                                                    }
                                                ],
                                                tbar:
                                                    {
                                                        xtype: 'toolbar',
                                                        items: [
                                                            {
                                                                xtype: 'button',
                                                                text: 'Programar',
                                                                iconCls: 'btnProgramarAgenda',
                                                                id: 'btnAddItemGridAgendaProgramar'
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                text: 'Anular',
                                                                iconCls: 'btnAnularAgenda',
                                                                id: 'btnDelItemGridAgendaProgramar'
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            '->',
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            'Consultorio/Unidad: ',
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccionar...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreConsultoriosxIPS',
                                                                forceSelection: true,
                                                                allowBlank: true,
                                                                id: 'intidConsultorioxIPS'
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            'Desde: ',
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Desde',
                                                                anchor: '24%',
                                                                emptyText: '(dia/mes/año)',
                                                                style: 'text-align:center;',
                                                                allowBlank: false,
                                                                value:  Ext.get('fecDesde').getValue(),
                                                                id: 'Desde'
                                                            },
                                                            ' - Hasta: ',
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Hasta',
                                                                anchor: '24%',
                                                                emptyText: '(dia/mes/año)',
                                                                style: 'text-align:center;',
                                                                allowBlank: false,
                                                                value:  Ext.get('fecHasta').getValue(),
                                                                id: 'Hasta'
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                text: 'Buscar',
                                                                iconCls: 'btnFind',
                                                                id: 'btnSearchItemGridAgendaProgramara'
                                                            }
                                                        ]
                                                    },
                                                bbar:
                                                    {
                                                        xtype: 'toolbar',
                                                        items: [
                                                            {
                                                                xtype: 'button',
                                                                text: 'Ver Detalle Agenda',
                                                                iconCls: 'btnEditarAgenda',
                                                                id: 'btnEditItemGridAgendaProgramar'
                                                            }
                                                        ]
                                                    },
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                                iconCls:'icon-grid',
                                                view: new Ext.grid.GroupingView({
                                                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                                                }),
                                                viewConfig: {
                                                    forceFit:true
                                                },
                                                columnLines: true
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_AdicionarItemFrm',
                            id: 'btn_AdicionarItemFrm'
                        },
                        {
                            xtype: 'button',
                            text: 'Modificar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_ModificarItemFrm',
                            id: 'btn_ModificarItemFrm'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            ref: '../btn_SalirItemFrm',
                            id: 'btn_SalirItemFrm'
                        }
                    ]
                }
            }
        ];
        winProfesionalesUi.superclass.initComponent.call(this);
    }
});
